#[derive(Debug, Clone, Copy)]
pub enum SetGroupSettingValue {
    Maintain,
    Decrease,
    Increase,
    /// Percentage as an integer from 0-100
    SetOpenPercentage(u8),
    /// Setpoint as an integer
    SetTargetSetpoint(u8),
}

#[derive(Debug, Clone, Copy)]
pub enum SetGroupControlMethod {
    Maintain,
    Toggle,
    Percentage,
    Temperature,
}

#[derive(Debug, Clone, Copy)]
pub enum SetGroupPower {
    Maintain,
    ChangeToNextState,
    SetOff,
    SetOn,
    SetTurbo,
}

#[derive(Debug, PartialEq, Clone, Copy)]
pub enum GroupPowerState {
    Off,
    On,
    Turbo,
}

#[derive(Debug, PartialEq, Clone, Copy)]
pub enum GroupControlMethod {
    Temperature,
    Percentage,
}

#[derive(Debug, Clone, Copy)]
pub enum SetACPowerState {
    Maintain,
    Toggle,
    Off,
    On,
}

#[derive(Debug, Clone, Copy)]
pub enum SetACMode {
    Maintain,
    Auto,
    Heat,
    Dry,
    Fan,
    Cool,
}

#[derive(Debug, PartialEq, Clone, Copy)]
pub enum ACMode {
    Auto,
    Heat,
    Dry,
    Fan,
    Cool,
    AutoHeat,
    AutoCool,
}

#[derive(Debug, PartialEq, Clone, Copy)]
pub enum ACFanSpeed {
    Auto,
    Quiet,
    Low,
    Medium,
    High,
    Powerful,
    Turbo,
}

#[derive(Debug, Clone, Copy)]
pub enum SetACSetpoint {
    Maintain,
    /// Temperature in degrees celsius.
    Value(u8),
    /// Decrease by 1 degree celsius.
    Decrease,
    /// Increase by 1 degree celsius.
    Increase,
}

#[derive(Debug, PartialEq, Clone, Copy)]
pub enum ACPowerState {
    Off,
    On,
}
