use crate::states;

/// The state of an AC unit.
#[derive(Debug, PartialEq)]
pub struct ACStatus {
    pub power_state: Option<states::ACPowerState>,
    /// Valid values are `0`-`3`.
    pub number: u8,
    pub mode: Option<states::ACMode>,
    pub fan_speed: Option<states::ACFanSpeed>,
    pub spill: bool,
    pub has_timer: bool,
    pub target_setpoint: u8,
    pub temperature: Option<f64>,
    // TODO: Add further error information
    pub error_code: u16,
}
