use crate::states;

/// The state of a group.
#[derive(Debug, PartialEq)]
pub struct GroupStatus {
    pub power_state: states::GroupPowerState,
    /// Valid values are `0`-`15`.
    pub group_number: u8,
    pub control_method: states::GroupControlMethod,
    pub open_percentage: u8,
    pub battery_low: bool,
    pub turbo_support: bool,
    pub target_setpoint: u8,
    pub has_sensor: bool,
    pub current_temperature: Option<f64>,
    pub spill: bool,
}
