use super::parse_message;
use super::GroupControlMessage;

use crate::states;

#[test]
#[should_panic(expected = "bytes length is too short to be a valid AT4 message.")]
fn test_parse_error_on_invalid_length() {
    parse_message(&[]).unwrap();
}

#[test]
#[should_panic(expected = "invalid header.")]
fn test_parse_error_on_invalid_header() {
    parse_message(&[0; 10]).unwrap();
}

#[test]
#[should_panic(expected = "invalid address byte.")]
fn test_parse_error_on_address_byte() {
    parse_message(&[0x55, 0x55, 0, 0, 0, 0, 0, 0, 0, 0]).unwrap();
}

#[test]
#[should_panic(expected = "bytes length is not long enough for parsed length.")]
fn test_parse_error_on_invalid_parsed_length() {
    parse_message(&[0x55, 0x55, 0, 0x80, 0, 0, 0xff, 0xab, 0, 0, 0]).unwrap();
}

#[test]
#[should_panic(expected = "crc check failed.")]
fn test_parse_error_on_invalid_crc() {
    parse_message(&[
        0x55, 0x55, 0xb0, 0x80, 0x01, 0x2b, 0x00, 0x0c, 0x40, 0x64, 0x00, 0x00, 0xff, 0x00, 0x41,
        0xe4, 0x1a, 0x80, 0x61, 0x80, 0x65, 0x78,
    ])
    .unwrap();
}

#[test]
fn test_parses_message() {
    let result = parse_message(&[
        0x55, 0x55, 0xb0, 0x80, 0x01, 0x2b, 0x00, 0x0c, 0x40, 0x64, 0x00, 0x00, 0xff, 0x00, 0x41,
        0xe4, 0x1a, 0x80, 0x61, 0x80, 0x65, 0x79,
    ]);

    match result {
        Err(reason) => println!("error: {}", reason),
        _ => {}
    }
}
