use crate::states;

#[derive(Debug)]
pub struct GroupStatus {
    power_state: states::GroupPowerState,
    /// Valid values are `0`-`15`.
    group_number: u8,
    control_method: states::GroupControlMethod,
    open_percentage: f64,
    battery_low: bool,
    turbo_support: bool,
    target_setpoint: f64,
    has_sensor: bool,
    current_temperature: Option<f64>,
    spill: bool,
}
