use crate::states;

#[derive(Debug)]
pub struct ACStatus {
    power_state: Option<states::ACPowerState>,
    /// Valid values are `0`-`3`.
    number: u8,
    mode: Option<states::ACMode>,
    fan_speed: Option<states::ACFanSpeed>,
    spill: bool,
    has_timer: bool,
    target_setpoint: f64,
    temperature: Option<f64>,
    // TODO: Add error
}
