#[derive(Debug)]
pub enum SetGroupSettingValue {
    Maintain,
    Decrease,
    Increase,
    /// Percentage as an integer from 0-100
    SetOpenPercentage(u8),
    /// Setpoint as an integer
    SetTargetSetpoint(u8),
}

#[derive(Debug)]
pub enum SetGroupControlMethod {
    Maintain,
    Toggle,
    Percentage,
    Temperature,
}

#[derive(Debug)]
pub enum SetGroupPower {
    Maintain,
    ChangeToNextState,
    SetOff,
    SetOn,
    SetTurbo,
}

#[derive(Debug)]
pub enum GroupPowerState {
    Off,
    On,
    Turbo,
}

#[derive(Debug)]
pub enum GroupControlMethod {
    Temperature,
    Percentage,
}

#[derive(Debug)]
pub enum SetACPowerState {
    Maintain,
    Toggle,
    Off,
    On,
}

#[derive(Debug)]
pub enum ACMode {
    Auto,
    Heat,
    Dry,
    Fan,
    Cool,
}

#[derive(Debug)]
pub enum ACFanSpeed {
    Auto,
    Quiet,
    Low,
    Medium,
    High,
    Powerful,
    Turbo,
}

#[derive(Debug)]
pub enum SetACSetpoint {
    Maintain,
    Value(f64),
    /// Decrease by 1 degree celsius.
    Decrease,
    /// Increase by 1 degree celsius.
    Increase,
}

#[derive(Debug)]
pub enum ACPowerState {
    Off,
    On,
}
