[![AsyncAPI Logo](./assets/logo.png)](https://www.asyncapi.com)

<hr/>

<p align="center">
  <a href="https://iqvia.com" target="_blank">
    <img src="./assets/iqvia.png" alt="IQVIA logo" height="40">
  </a>
  &nbsp;&nbsp;&nbsp;&nbsp;
  <a href="https://mulesoft.com" target="_blank">
    <img src="./assets/mulesoft.png" alt="Mulesoft logo" height="40">
  </a>
  &nbsp;&nbsp;&nbsp;&nbsp;
  <a href="https://salesforce.com" target="_blank">
    <img src="./assets/salesforce.png" alt="Salesforce logo" height="40">
  </a>
  &nbsp;&nbsp;&nbsp;&nbsp;
  <a href="https://sap.com" target="_blank">
    <img src="./assets/sap.svg" alt="SAP logo" height="40">
  </a>
  &nbsp;
  <a href="https://slack.com" target="_blank">
    <img src="./assets/slack.svg" alt="Slack logo" height="40">
  </a>
  &nbsp;
  <a href="https://solace.com" target="_blank">
    <img src="./assets/solace.png" alt="Solace logo" height="40">
  </a>
  &nbsp;
  <a href="https://tibco.com" target="_blank">
    <img src="./assets/tibco.png" alt="TIBCO logo" height="40">
  </a>
</p>

<p align="center">
  :raised_hands: Platinum sponsors. <a href="https://opencollective.com/asyncapi">Join them!</a> :raised_hands:
</p>

## Read the specification

The latest draft specification can be found at [spec/asyncapi.md](./spec/asyncapi.md) which tracks the latest commit to the master branch in this repository.

- [Version 2.3.0](https://github.com/asyncapi/spec/blob/v2.3.0/spec/asyncapi.md) (latest)
- [Version 2.2.0](https://github.com/asyncapi/spec/blob/v2.2.0/spec/asyncapi.md)
- [Version 2.1.0](https://github.com/asyncapi/spec/blob/v2.1.0/spec/asyncapi.md)
- [Version 2.0.0](https://github.com/asyncapi/spec/blob/2.0.0/versions/2.0.0/asyncapi.md)
- [Version 1.2.0](https://github.com/asyncapi/spec/blob/1.2.0/README.md) (deprecated)
- [Version 1.1.0](https://github.com/asyncapi/spec/blob/1.1.0/README.md) (deprecated)
- [Version 1.0.0](https://github.com/asyncapi/spec/blob/1.0.0/README.md) (deprecated)

**Looking for the JSON Schema files?** Check out our [spec-json-schemas](https://github.com/asyncapi/spec-json-schemas) repo.

**Feel like contributing?** Check out our [community repo](https://www.github.com/asyncapi/community).

## Examples

#### :bulb: Streetlights

Demonstrates how to use AsyncAPI to define an API that controls city streetlights.

> :point_right: [See more](./examples/streetlights-mqtt.yml)

#### <img src="./assets/slack.png" width="15" alt="Slack icon">&nbsp;&nbsp; Slack Events API

Partial definition of the Slack Events API. Find the official one [here](https://github.com/slackapi/slack-api-specs/blob/master/events-api/slack_events_api_async_v1.json).

> :point_right: [See more](./examples/slack-rtm.yml)

#### <img src="./assets/gitter.png" width="15" alt="Gitter icon">&nbsp;&nbsp; Gitter Streaming API

Definition of the Gitter streaming API.

> :point_right: [See more](./examples/gitter-streaming.yml)

#### <img src="./assets/gemini.svg" width="15" alt="Gemini icon">&nbsp;&nbsp; Gemini WebSocket API

Definition of the Gemini Websocket API.

> :point_right: [See more](./examples/websocket-gemini.yml)

#### :heavy_plus_sign: and more...

Check out the [examples](https://github.com/asyncapi/asyncapi/blob/master/examples) directory for more examples.

## Contributors

Thanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tr>
    <td align="center"><a href="http://www.fmvilas.com"><img src="https://avatars3.githubusercontent.com/u/242119?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Fran Méndez</b></sub></a><br /><a href="#question-fmvilas" title="Answering Questions">💬</a> <a href="https://github.com/asyncapi/spec/issues?q=author%3Afmvilas" title="Bug reports">🐛</a> <a href="#blog-fmvilas" title="Blogposts">📝</a> <a href="https://github.com/asyncapi/spec/commits?author=fmvilas" title="Documentation">📖</a> <a href="#ideas-fmvilas" title="Ideas, Planning, & Feedback">🤔</a> <a href="#infra-fmvilas" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="#maintenance-fmvilas" title="Maintenance">🚧</a> <a href="https://github.com/asyncapi/spec/pulls?q=is%3Apr+reviewed-by%3Afmvilas" title="Reviewed Pull Requests">👀</a> <a href="#tutorial-fmvilas" title="Tutorials">✅</a> <a href="#talk-fmvilas" title="Talks">📢</a></td>
    <td align="center"><a href="http://resume.github.io/?derberg"><img src="https://avatars1.githubusercontent.com/u/6995927?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Lukasz Gornicki</b></sub></a><br /><a href="https://github.com/asyncapi/spec/commits?author=derberg" title="Documentation">📖</a> <a href="#ideas-derberg" title="Ideas, Planning, & Feedback">🤔</a> <a href="https://github.com/asyncapi/spec/pulls?q=is%3Apr+reviewed-by%3Aderberg" title="Reviewed Pull Requests">👀</a> <a href="#question-derberg" title="Answering Questions">💬</a> <a href="#blog-derberg" title="Blogposts">📝</a> <a href="#talk-derberg" title="Talks">📢</a> <a href="#maintenance-derberg" title="Maintenance">🚧</a> <a href="#infra-derberg" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
    <td align="center"><a href="http://mermade.github.io"><img src="https://avatars0.githubusercontent.com/u/21603?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Mike Ralphson</b></sub></a><br /><a href="#question-MikeRalphson" title="Answering Questions">💬</a> <a href="https://github.com/asyncapi/spec/commits?author=MikeRalphson" title="Documentation">📖</a> <a href="#ideas-MikeRalphson" title="Ideas, Planning, & Feedback">🤔</a> <a href="#infra-MikeRalphson" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="https://github.com/asyncapi/spec/pulls?q=is%3Apr+reviewed-by%3AMikeRalphson" title="Reviewed Pull Requests">👀</a> <a href="#maintenance-MikeRalphson" title="Maintenance">🚧</a></td>
    <td align="center"><a href="https://github.com/rmelian"><img src="https://avatars3.githubusercontent.com/u/4565267?v=4?s=100" width="100px;" alt=""/><br /><sub><b>raisel melian</b></sub></a><br /><a href="#question-rmelian" title="Answering Questions">💬</a> <a href="https://github.com/asyncapi/spec/issues?q=author%3Armelian" title="Bug reports">🐛</a> <a href="https://github.com/asyncapi/spec/commits?author=rmelian" title="Documentation">📖</a> <a href="#ideas-rmelian" title="Ideas, Planning, & Feedback">🤔</a> <a href="#maintenance-rmelian" title="Maintenance">🚧</a> <a href="https://github.com/asyncapi/spec/pulls?q=is%3Apr+reviewed-by%3Armelian" title="Reviewed Pull Requests">👀</a></td>
    <td align="center"><a href="https://github.com/SensibleWood"><img src="https://avatars2.githubusercontent.com/u/2420069?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Chris Wood</b></sub></a><br /><a href="#ideas-SensibleWood" title="Ideas, Planning, & Feedback">🤔</a> <a href="https://github.com/asyncapi/spec/commits?author=SensibleWood" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/jschabowsky"><img src="https://avatars1.githubusercontent.com/u/26606293?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Jonathan Schabowsky</b></sub></a><br /><a href="https://github.com/asyncapi/spec/commits?author=jschabowsky" title="Documentation">📖</a> <a href="#ideas-jschabowsky" title="Ideas, Planning, & Feedback">🤔</a></td>
    <td align="center"><a href="https://github.com/vromero"><img src="https://avatars1.githubusercontent.com/u/1119553?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Victor Romero</b></sub></a><br /><a href="#ideas-vromero" title="Ideas, Planning, & Feedback">🤔</a> <a href="https://github.com/asyncapi/spec/pulls?q=is%3Apr+reviewed-by%3Avromero" title="Reviewed Pull Requests">👀</a></td>
    <td align="center"><a href="http://antoniogarrote.wordpress.com"><img src="https://avatars1.githubusercontent.com/u/8277?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Antonio Garrote</b></sub></a><br /><a href="#ideas-antoniogarrote" title="Ideas, Planning, & Feedback">🤔</a> <a href="https://github.com/asyncapi/spec/pulls?q=is%3Apr+reviewed-by%3Aantoniogarrote" title="Reviewed Pull Requests">👀</a> <a href="https://github.com/asyncapi/spec/commits?author=antoniogarrote" title="Documentation">📖</a></td>
    <td align="center"><a href="https://ramses.tech"><img src="https://avatars0.githubusercontent.com/u/9660342?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Jonathan Stoikovitch</b></sub></a><br /><a href="#example-jstoiko" title="Examples">💡</a> <a href="#ideas-jstoiko" title="Ideas, Planning, & Feedback">🤔</a> <a href="https://github.com/asyncapi/spec/pulls?q=is%3Apr+reviewed-by%3Ajstoiko" title="Reviewed Pull Requests">👀</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/jonaslagoni"><img src="https://avatars1.githubusercontent.com/u/13396189?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Jonas Lagoni</b></sub></a><br /><a href="https://github.com/asyncapi/spec/issues?q=author%3Ajonaslagoni" title="Bug reports">🐛</a> <a href="https://github.com/asyncapi/spec/commits?author=jonaslagoni" title="Documentation">📖</a> <a href="#ideas-jonaslagoni" title="Ideas, Planning, & Feedback">🤔</a> <a href="#question-jonaslagoni" title="Answering Questions">💬</a> <a href="https://github.com/asyncapi/spec/pulls?q=is%3Apr+reviewed-by%3Ajonaslagoni" title="Reviewed Pull Requests">👀</a> <a href="#example-jonaslagoni" title="Examples">💡</a></td>
    <td align="center"><a href="https://waleedashraf.me/"><img src="https://avatars0.githubusercontent.com/u/8335457?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Waleed Ashraf</b></sub></a><br /><a href="#talk-WaleedAshraf" title="Talks">📢</a> <a href="#ideas-WaleedAshraf" title="Ideas, Planning, & Feedback">🤔</a></td>
    <td align="center"><a href="https://github.com/jerzyn"><img src="https://avatars0.githubusercontent.com/u/1447151?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Andrzej Jarzyna</b></sub></a><br /><a href="#talk-jerzyn" title="Talks">📢</a></td>
    <td align="center"><a href="https://linkedin.com/in/emmelyn"><img src="https://avatars1.githubusercontent.com/u/4294106?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Emmelyn Wang</b></sub></a><br /><a href="#blog-lifewingmate" title="Blogposts">📝</a> <a href="#ideas-lifewingmate" title="Ideas, Planning, & Feedback">🤔</a> <a href="https://github.com/asyncapi/spec/commits?author=lifewingmate" title="Documentation">📖</a> <a href="#talk-lifewingmate" title="Talks">📢</a></td>
    <td align="center"><a href="https://marcd.dev"><img src="https://avatars0.githubusercontent.com/u/1815312?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Marc DiPasquale</b></sub></a><br /><a href="#blog-Mrc0113" title="Blogposts">📝</a> <a href="#talk-Mrc0113" title="Talks">📢</a> <a href="https://github.com/asyncapi/spec/pulls?q=is%3Apr+reviewed-by%3AMrc0113" title="Reviewed Pull Requests">👀</a> <a href="https://github.com/asyncapi/spec/issues?q=author%3AMrc0113" title="Bug reports">🐛</a> <a href="#ideas-Mrc0113" title="Ideas, Planning, & Feedback">🤔</a> <a href="#video-Mrc0113" title="Videos">📹</a></td>
    <td align="center"><a href="http://www.gerald-loeffler.net/"><img src="https://avatars.githubusercontent.com/u/1985716?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Gerald Loeffler</b></sub></a><br /><a href="https://github.com/asyncapi/spec/commits?author=GeraldLoeffler" title="Documentation">📖</a> <a href="https://github.com/asyncapi/spec/issues?q=author%3AGeraldLoeffler" title="Bug reports">🐛</a> <a href="#ideas-GeraldLoeffler" title="Ideas, Planning, & Feedback">🤔</a></td>
    <td align="center"><a href="http://dalelane.co.uk/"><img src="https://avatars.githubusercontent.com/u/1444788?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Dale Lane</b></sub></a><br /><a href="#blog-dalelane" title="Blogposts">📝</a> <a href="#ideas-dalelane" title="Ideas, Planning, & Feedback">🤔</a> <a href="#video-dalelane" title="Videos">📹</a> <a href="#talk-dalelane" title="Talks">📢</a> <a href="#tutorial-dalelane" title="Tutorials">✅</a> <a href="https://github.com/asyncapi/spec/commits?author=dalelane" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/magicmatatjahu"><img src="https://avatars.githubusercontent.com/u/20404945?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Maciej Urbańczyk</b></sub></a><br /><a href="https://github.com/asyncapi/spec/pulls?q=is%3Apr+reviewed-by%3Amagicmatatjahu" title="Reviewed Pull Requests">👀</a> <a href="#ideas-magicmatatjahu" title="Ideas, Planning, & Feedback">🤔</a></td>
    <td align="center"><a href="https://vladimirgorej.com/"><img src="https://avatars.githubusercontent.com/u/193286?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Vladimir Gorej</b></sub></a><br /><a href="https://github.com/asyncapi/spec/commits?author=char0n" title="Documentation">📖</a></td>
  </tr>
  <tr>
    <td align="center"><a href="http://www.lornajane.net/"><img src="https://avatars.githubusercontent.com/u/172607?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Lorna Jane Mitchell</b></sub></a><br /><a href="#talk-lornajane" title="Talks">📢</a> <a href="#ideas-lornajane" title="Ideas, Planning, & Feedback">🤔</a></td>
    <td align="center"><a href="http://medium.com/@lbroudoux"><img src="https://avatars.githubusercontent.com/u/1538635?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Laurent Broudoux</b></sub></a><br /><a href="https://github.com/asyncapi/spec/commits?author=lbroudoux" title="Documentation">📖</a> <a href="#blog-lbroudoux" title="Blogposts">📝</a> <a href="#talk-lbroudoux" title="Talks">📢</a> <a href="#example-lbroudoux" title="Examples">💡</a> <a href="#ideas-lbroudoux" title="Ideas, Planning, & Feedback">🤔</a> <a href="https://github.com/asyncapi/spec/pulls?q=is%3Apr+reviewed-by%3Albroudoux" title="Reviewed Pull Requests">👀</a></td>
    <td align="center"><a href="https://github.com/jmenning-solace"><img src="https://avatars.githubusercontent.com/u/62108913?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Jesse Menning</b></sub></a><br /><a href="#blog-jmenning-solace" title="Blogposts">📝</a> <a href="#talk-jmenning-solace" title="Talks">📢</a> <a href="https://github.com/asyncapi/spec/pulls?q=is%3Apr+reviewed-by%3Ajmenning-solace" title="Reviewed Pull Requests">👀</a> <a href="#ideas-jmenning-solace" title="Ideas, Planning, & Feedback">🤔</a></td>
    <td align="center"><a href="https://github.com/smoya"><img src="https://avatars.githubusercontent.com/u/1083296?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Sergio Moya</b></sub></a><br /><a href="https://github.com/asyncapi/spec/pulls?q=is%3Apr+reviewed-by%3Asmoya" title="Reviewed Pull Requests">👀</a> <a href="#ideas-smoya" title="Ideas, Planning, & Feedback">🤔</a> <a href="#question-smoya" title="Answering Questions">💬</a></td>
    <td align="center"><a href="https://github.com/balogal"><img src="https://avatars.githubusercontent.com/u/80794567?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Alexander Balogh</b></sub></a><br /><a href="https://github.com/asyncapi/spec/commits?author=balogal" title="Documentation">📖</a> <a href="https://github.com/asyncapi/spec/issues?q=author%3Abalogal" title="Bug reports">🐛</a></td>
    <td align="center"><a href="https://github.com/KhudaDad414"><img src="https://avatars.githubusercontent.com/u/32505158?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Khuda Dad Nomani</b></sub></a><br /><a href="#example-KhudaDad414" title="Examples">💡</a> <a href="https://github.com/asyncapi/spec/issues?q=author%3AKhudaDad414" title="Bug reports">🐛</a></td>
    <td align="center"><a href="https://github.com/aaronkorver"><img src="https://avatars.githubusercontent.com/u/8387325?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Aaron Korver</b></sub></a><br /><a href="https://github.com/asyncapi/spec/commits?author=aaronkorver" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/xunto"><img src="https://avatars.githubusercontent.com/u/5288053?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Orlov Valentine</b></sub></a><br /><a href="https://github.com/asyncapi/spec/commits?author=xunto" title="Documentation">📖</a></td>
    <td align="center"><a href="https://lejenome.tik.tn"><img src="https://avatars.githubusercontent.com/u/2295241?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Moez Bouhlel</b></sub></a><br /><a href="https://github.com/asyncapi/spec/commits?author=lejenome" title="Documentation">📖</a></td>
  </tr>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!
