// Copyright (c) 2021 Harry [Majored] [hello@majored.pw]
// MIT License (https://github.com/Majored/rs-async-zip/blob/main/LICENSE)

//! # async_zip
//! 
//! An asynchronous ZIP archive reading/writing crate with a heavy focus on streaming support.
//! 
//! ## Features
//! - Asynchronous design powered by `tokio`.
//! - Support for Stored, Deflate, Bzip2, LZMA, zstd, and xz compression methods.
//! - Aims for resonable [specification](https://pkware.cachefly.net/webdocs/casestudies/APPNOTE.TXT) compliance.
//! 
//! ## Note
//! This crate is far from complete or in working order. Version 0.0.1 is only being pushed to crates.io to reserve the 'async_zip' crate name.

pub(crate) mod delim;
pub(crate) mod header;
pub mod error;
pub mod stream;