use serde::Deserialize;
use serde_json::Value;
use std::{error::Error, fmt};

pub mod client;
mod config;

#[derive(Deserialize)]
struct KrakenResult {
    pub error: Vec<String>,
    #[serde(default)]
    pub result: Value,
}

struct KrakenError {
    pub er_list: Vec<String>,
}

impl Error for KrakenError {}

impl fmt::Display for KrakenError {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(f, "{:?}", self.er_list)
    }
}

impl fmt::Debug for KrakenError {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(f, "Kraken Errors: {:?}", self.er_list)
    }
}
