pub const API_URL: &str = "https://api.kraken.com";
pub const API_VER: &str = "0";

const PUBLIC_METHODS: &'static [&'static str] = &[
    "Time",
    "Assets",
    "AssetPairs",
    "Ticker",
    "Depth",
    "Trades",
    "Spread",
    "OHLC",
];

const PRIVATE_METHODS: &'static [&'static str] = &[
    "Balance",
    "TradeBalance",
    "OpenOrders",
    "ClosedOrders",
    "QueryOrders",
    "TradesHistory",
    "QueryTrades",
    "OpenPositions",
    "Ledgers",
    "QueryLedgers",
    "TradeVolume",
    "AddOrder",
    "CancelOrder",
    "DepositMethods",
    "DepositAddresses",
    "DepositStatus",
    "WithdrawInfo",
    "Withdraw",
    "WithdrawStatus",
    "WithdrawCancel",
    "GetWebSocketsToken",
];

pub fn method_type(method: &str) -> &str {
    if PRIVATE_METHODS.contains(&method) {
        "private"
    } else if PUBLIC_METHODS.contains(&method) {
        "public"
    } else {
        "invalid"
    }
}
