This is a minimal interface for the [Kraken exchange REST API](https://docs.kraken.com/rest/) using the [async-std](https://async.rs/) runtime.

# Prerequisites
To use the **```private```** endpoints you will need to generate an **```API-Key```** and an **```API-Secret```** to authenticate to the desired Kraken account.  
[How to generate an API key pair?](https://support.kraken.com/hc/en-us/articles/360000919966-How-to-generate-an-API-key-pair-)

# Usage
Automatically add to your **```Cargo.toml```** with
```shell
cargo add async_kraken
```
or manually adding as dependecy in **```Cargo.toml```**:
```toml
[dependencies]
#..
async_kraken = {version = 0.1.0}
```

# Example
```rust
use async_kraken::client::KrakenClient;

fn get_keys() -> (String, String) {
    let content = std::fs::read_to_string("key").expect("File not found");
    let lines: Vec<&str> = content.lines().collect();

    let key = String::from(lines[0]);
    let secret = String::from(lines[1]);

    (key, secret)
}

#[async_std::main]
async fn main() {
    // # Only public endpoints
    // let k = KrakenClient::new();

    // # Public and private enpoints
    let (key, secret) = get_keys();
    let k = KrakenClient::with_credentials(key, secret);

    match k.api_request("Time", serde_json::json!({})).await {
        Ok(json) => println!("{:?}", json),
        Err(e) => println!("{:?}", e),
    };

    match k.api_request("OHLC", serde_json::json!({"pair":"doteur", "interval":30, "since":0})).await
    {
        Ok(json) => println!("{:?}", json),
        Err(e) => println!("{:?}", e),
    };

    match k.api_request("Balance", serde_json::json!({})).await {
        Ok(json) => println!("{:?}", json),
        Err(e) => println!("{:?}", e),
    };
}
```
# Disclaimer

This software comes without any kind of warranties.

You are the sole responsible of your gains or loses.
