// ======================================
// This file was automatically generated.
// ======================================

use serde_derive::{Deserialize, Serialize};

use crate::client::{Client, Response};
use crate::ids::{CustomerId, MandateId, PaymentIntentId, PaymentMethodId};
use crate::params::{Expand, Expandable, List, Metadata, Object, RangeQuery, Timestamp};
use crate::resources::{
    Account, ApiErrors, Application, Charge, Currency, Customer, Invoice, PaymentIntentOffSession,
    PaymentMethod, PaymentMethodDetailsCardInstallmentsPlan, Review, Shipping,
};

/// The resource representing a Stripe "PaymentIntent".
///
/// For more details see <https://stripe.com/docs/api/payment_intents/object>
#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntent {
    /// Unique identifier for the object.
    pub id: PaymentIntentId,

    /// Amount intended to be collected by this PaymentIntent.
    ///
    /// A positive integer representing how much to charge in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal) (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal currency).
    /// The minimum amount is $0.50 US or [equivalent in charge currency](https://stripe.com/docs/currencies#minimum-and-maximum-charge-amounts).
    /// The amount value supports up to eight digits (e.g., a value of 99999999 for a USD charge of $999,999.99).
    pub amount: i64,

    /// Amount that can be captured from this PaymentIntent.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub amount_capturable: Option<i64>,

    /// Amount that was collected by this PaymentIntent.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub amount_received: Option<i64>,

    /// ID of the Connect application that created the PaymentIntent.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub application: Option<Expandable<Application>>,

    /// The amount of the application fee (if any) that will be requested to be applied to the payment and transferred to the application owner's Stripe account.
    ///
    /// The amount of the application fee collected will be capped at the total payment amount.
    /// For more information, see the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub application_fee_amount: Option<i64>,

    /// Settings to configure compatible payment methods from the [Stripe Dashboard](https://dashboard.stripe.com/settings/payment_methods).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub automatic_payment_methods: Option<PaymentFlowsAutomaticPaymentMethodsPaymentIntent>,

    /// Populated when `status` is `canceled`, this is the time at which the PaymentIntent was canceled.
    ///
    /// Measured in seconds since the Unix epoch.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub canceled_at: Option<Timestamp>,

    /// Reason for cancellation of this PaymentIntent, either user-provided (`duplicate`, `fraudulent`, `requested_by_customer`, or `abandoned`) or generated by Stripe internally (`failed_invoice`, `void_invoice`, or `automatic`).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub cancellation_reason: Option<PaymentIntentCancellationReason>,

    /// Controls when the funds will be captured from the customer's account.
    pub capture_method: PaymentIntentCaptureMethod,

    /// Charges that were created by this PaymentIntent, if any.
    #[serde(default)]
    pub charges: List<Charge>,

    /// The client secret of this PaymentIntent.
    ///
    /// Used for client-side retrieval using a publishable key.
    /// The client secret can be used to complete a payment from your frontend.
    /// It should not be stored, logged, embedded in URLs, or exposed to anyone other than the customer.
    /// Make sure that you have TLS enabled on any page that includes the client secret.  Refer to our docs to [accept a payment](https://stripe.com/docs/payments/accept-a-payment?integration=elements) and learn about how `client_secret` should be handled.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub client_secret: Option<String>,

    pub confirmation_method: PaymentIntentConfirmationMethod,

    /// Time at which the object was created.
    ///
    /// Measured in seconds since the Unix epoch.
    pub created: Timestamp,

    /// Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase.
    ///
    /// Must be a [supported currency](https://stripe.com/docs/currencies).
    pub currency: Currency,

    /// ID of the Customer this PaymentIntent belongs to, if one exists.
    ///
    /// Payment methods attached to other Customers cannot be used with this PaymentIntent.
    ///
    /// If present in combination with [setup_future_usage](https://stripe.com/docs/api#payment_intent_object-setup_future_usage), this PaymentIntent's payment method will be attached to the Customer after the PaymentIntent has been confirmed and any required actions from the user are complete.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub customer: Option<Expandable<Customer>>,

    /// An arbitrary string attached to the object.
    ///
    /// Often useful for displaying to users.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,

    /// ID of the invoice that created this PaymentIntent, if it exists.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub invoice: Option<Expandable<Invoice>>,

    /// The payment error encountered in the previous PaymentIntent confirmation.
    ///
    /// It will be cleared if the PaymentIntent is later updated for any reason.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_payment_error: Option<Box<ApiErrors>>,

    /// Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
    pub livemode: bool,

    /// Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object.
    ///
    /// This can be useful for storing additional information about the object in a structured format.
    /// For more information, see the [documentation](https://stripe.com/docs/payments/payment-intents/creating-payment-intents#storing-information-in-metadata).
    #[serde(default)]
    pub metadata: Metadata,

    /// If present, this property tells you what actions you need to take in order for your customer to fulfill a payment using the provided source.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_action: Option<PaymentIntentNextAction>,

    /// The account (if any) for which the funds of the PaymentIntent are intended.
    ///
    /// See the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts) for details.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub on_behalf_of: Option<Expandable<Account>>,

    /// ID of the payment method used in this PaymentIntent.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub payment_method: Option<Expandable<PaymentMethod>>,

    /// Payment-method-specific configuration for this PaymentIntent.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub payment_method_options: Option<PaymentIntentPaymentMethodOptions>,

    /// The list of payment method types (e.g.
    ///
    /// card) that this PaymentIntent is allowed to use.
    pub payment_method_types: Vec<String>,

    /// If present, this property tells you about the processing state of the payment.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub processing: Option<PaymentIntentProcessing>,

    /// Email address that the receipt for the resulting payment will be sent to.
    ///
    /// If `receipt_email` is specified for a payment in live mode, a receipt will be sent regardless of your [email settings](https://dashboard.stripe.com/account/emails).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub receipt_email: Option<String>,

    /// ID of the review associated with this PaymentIntent, if any.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub review: Option<Expandable<Review>>,

    /// Indicates that you intend to make future payments with this PaymentIntent's payment method.
    ///
    /// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete.
    ///
    /// If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.  When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<PaymentIntentSetupFutureUsage>,

    /// Shipping information for this PaymentIntent.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub shipping: Option<Shipping>,

    /// For non-card charges, you can use this value as the complete description that appears on your customers’ statements.
    ///
    /// Must contain at least one letter, maximum 22 characters.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub statement_descriptor: Option<String>,

    /// Provides information about a card payment that customers see on their statements.
    ///
    /// Concatenated with the prefix (shortened descriptor) or statement descriptor that’s set on the account to form the complete statement descriptor.
    /// Maximum 22 characters for the concatenated descriptor.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub statement_descriptor_suffix: Option<String>,

    /// Status of this PaymentIntent, one of `requires_payment_method`, `requires_confirmation`, `requires_action`, `processing`, `requires_capture`, `canceled`, or `succeeded`.
    ///
    /// Read more about each PaymentIntent [status](https://stripe.com/docs/payments/intents#intent-statuses).
    pub status: PaymentIntentStatus,

    /// The data with which to automatically create a Transfer when the payment is finalized.
    ///
    /// See the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts) for details.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transfer_data: Option<TransferData>,

    /// A string that identifies the resulting payment as part of a group.
    ///
    /// See the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts) for details.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transfer_group: Option<String>,
}

impl PaymentIntent {
    /// Returns a list of PaymentIntents.
    pub fn list(client: &Client, params: ListPaymentIntents<'_>) -> Response<List<PaymentIntent>> {
        client.get_query("/payment_intents", &params)
    }

    /// Creates a PaymentIntent object.
    ///
    /// After the PaymentIntent is created, attach a payment method and [confirm](https://stripe.com/docs/api/payment_intents/confirm)
    /// to continue the payment.
    ///
    /// You can read more about the different payment flows available via the Payment Intents API [here](https://stripe.com/docs/payments/payment-intents).  When `confirm=true` is used during creation, it is equivalent to creating and confirming the PaymentIntent in the same call.
    /// You may use any parameters available in the [confirm API](https://stripe.com/docs/api/payment_intents/confirm) when `confirm=true` is supplied.
    pub fn create(client: &Client, params: CreatePaymentIntent<'_>) -> Response<PaymentIntent> {
        client.post_form("/payment_intents", &params)
    }

    /// Retrieves the details of a PaymentIntent that has previously been created.
    ///
    /// Client-side retrieval using a publishable key is allowed when the `client_secret` is provided in the query string.
    /// When retrieved with a publishable key, only a subset of properties will be returned.
    /// Please refer to the [payment intent](https://stripe.com/docs/api#payment_intent_object) object reference for more details.
    pub fn retrieve(
        client: &Client,
        id: &PaymentIntentId,
        expand: &[&str],
    ) -> Response<PaymentIntent> {
        client.get_query(&format!("/payment_intents/{}", id), &Expand { expand })
    }

    /// Updates properties on a PaymentIntent object without confirming.
    ///
    /// Depending on which properties you update, you may need to confirm the
    /// PaymentIntent again.
    ///
    /// For example, updating the `payment_method` will always require you to confirm the PaymentIntent again.
    /// If you prefer to update and confirm at the same time, we recommend updating properties via the [confirm API](https://stripe.com/docs/api/payment_intents/confirm) instead.
    pub fn update(
        client: &Client,
        id: &PaymentIntentId,
        params: UpdatePaymentIntent<'_>,
    ) -> Response<PaymentIntent> {
        client.post_form(&format!("/payment_intents/{}", id), &params)
    }
}

impl Object for PaymentIntent {
    type Id = PaymentIntentId;
    fn id(&self) -> Self::Id {
        self.id.clone()
    }
    fn object(&self) -> &'static str {
        "payment_intent"
    }
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentFlowsAutomaticPaymentMethodsPaymentIntent {
    /// Automatically calculates compatible payment methods.
    pub enabled: bool,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntentNextAction {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub alipay_handle_redirect: Option<PaymentIntentNextActionAlipayHandleRedirect>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub boleto_display_details: Option<PaymentIntentNextActionBoleto>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub card_await_notification: Option<PaymentIntentNextActionCardAwaitNotification>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub konbini_display_details: Option<PaymentIntentNextActionKonbini>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub oxxo_display_details: Option<PaymentIntentNextActionDisplayOxxoDetails>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub redirect_to_url: Option<PaymentIntentNextActionRedirectToUrl>,

    /// Type of the next action to perform, one of `redirect_to_url`, `use_stripe_sdk`, `alipay_handle_redirect`, `oxxo_display_details`, or `verify_with_microdeposits`.
    #[serde(rename = "type")]
    pub type_: String,

    /// When confirming a PaymentIntent with Stripe.js, Stripe.js depends on the contents of this dictionary to invoke authentication flows.
    ///
    /// The shape of the contents is subject to change and is only intended to be used by Stripe.js.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub use_stripe_sdk: Option<serde_json::Value>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub verify_with_microdeposits: Option<PaymentIntentNextActionVerifyWithMicrodeposits>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub wechat_pay_display_qr_code: Option<PaymentIntentNextActionWechatPayDisplayQrCode>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub wechat_pay_redirect_to_android_app:
        Option<PaymentIntentNextActionWechatPayRedirectToAndroidApp>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub wechat_pay_redirect_to_ios_app: Option<PaymentIntentNextActionWechatPayRedirectToIosApp>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntentNextActionAlipayHandleRedirect {
    /// The native data to be used with Alipay SDK you must redirect your customer to in order to authenticate the payment in an Android App.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub native_data: Option<String>,

    /// The native URL you must redirect your customer to in order to authenticate the payment in an iOS App.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub native_url: Option<String>,

    /// If the customer does not exit their browser while authenticating, they will be redirected to this specified URL after completion.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub return_url: Option<String>,

    /// The URL you must redirect your customer to in order to authenticate the payment.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntentNextActionBoleto {
    /// The timestamp after which the boleto expires.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expires_at: Option<Timestamp>,

    /// The URL to the hosted boleto voucher page, which allows customers to view the boleto voucher.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub hosted_voucher_url: Option<String>,

    /// The boleto number.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub number: Option<String>,

    /// The URL to the downloadable boleto voucher PDF.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pdf: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntentNextActionCardAwaitNotification {
    /// The time that payment will be attempted.
    ///
    /// If customer approval is required, they need to provide approval before this time.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub charge_attempt_at: Option<Timestamp>,

    /// For payments greater than INR 5000, the customer must provide explicit approval of the payment with their bank.
    ///
    /// For payments of lower amount, no customer action is required.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub customer_approval_required: Option<bool>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntentNextActionDisplayOxxoDetails {
    /// The timestamp after which the OXXO voucher expires.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expires_after: Option<Timestamp>,

    /// The URL for the hosted OXXO voucher page, which allows customers to view and print an OXXO voucher.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub hosted_voucher_url: Option<String>,

    /// OXXO reference number.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub number: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntentNextActionKonbini {
    /// The timestamp at which the pending Konbini payment expires.
    pub expires_at: Timestamp,

    /// The URL for the Konbini payment instructions page, which allows customers to view and print a Konbini voucher.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub hosted_voucher_url: Option<String>,

    pub stores: PaymentIntentNextActionKonbiniStores,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntentNextActionKonbiniStores {
    /// FamilyMart instruction details.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub familymart: Option<PaymentIntentNextActionKonbiniFamilymart>,

    /// Lawson instruction details.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub lawson: Option<PaymentIntentNextActionKonbiniLawson>,

    /// Ministop instruction details.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ministop: Option<PaymentIntentNextActionKonbiniMinistop>,

    /// Seicomart instruction details.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub seicomart: Option<PaymentIntentNextActionKonbiniSeicomart>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntentNextActionKonbiniFamilymart {
    /// The confirmation number.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub confirmation_number: Option<String>,

    /// The payment code.
    pub payment_code: String,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntentNextActionKonbiniLawson {
    /// The confirmation number.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub confirmation_number: Option<String>,

    /// The payment code.
    pub payment_code: String,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntentNextActionKonbiniMinistop {
    /// The confirmation number.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub confirmation_number: Option<String>,

    /// The payment code.
    pub payment_code: String,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntentNextActionKonbiniSeicomart {
    /// The confirmation number.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub confirmation_number: Option<String>,

    /// The payment code.
    pub payment_code: String,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntentNextActionRedirectToUrl {
    /// If the customer does not exit their browser while authenticating, they will be redirected to this specified URL after completion.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub return_url: Option<String>,

    /// The URL you must redirect your customer to in order to authenticate the payment.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntentNextActionVerifyWithMicrodeposits {
    /// The timestamp when the microdeposits are expected to land.
    pub arrival_date: Timestamp,

    /// The URL for the hosted verification page, which allows customers to verify their bank account.
    pub hosted_verification_url: String,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntentNextActionWechatPayDisplayQrCode {
    /// The data being used to generate QR code.
    pub data: String,

    /// The base64 image data for a pre-generated QR code.
    pub image_data_url: String,

    /// The image_url_png string used to render QR code.
    pub image_url_png: String,

    /// The image_url_svg string used to render QR code.
    pub image_url_svg: String,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntentNextActionWechatPayRedirectToAndroidApp {
    /// app_id is the APP ID registered on WeChat open platform.
    pub app_id: String,

    /// nonce_str is a random string.
    pub nonce_str: String,

    /// package is static value.
    pub package: String,

    /// an unique merchant ID assigned by WeChat Pay.
    pub partner_id: String,

    /// an unique trading ID assigned by WeChat Pay.
    pub prepay_id: String,

    /// A signature.
    pub sign: String,

    /// Specifies the current time in epoch format.
    pub timestamp: String,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntentNextActionWechatPayRedirectToIosApp {
    /// An universal link that redirect to WeChat Pay app.
    pub native_url: String,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntentPaymentMethodOptions {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub acss_debit: Option<PaymentIntentPaymentMethodOptionsAcssDebitUnion>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub afterpay_clearpay: Option<PaymentIntentPaymentMethodOptionsAfterpayClearpayUnion>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub alipay: Option<PaymentIntentPaymentMethodOptionsAlipayUnion>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub au_becs_debit: Option<PaymentIntentPaymentMethodOptionsAuBecsDebitUnion>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub bacs_debit: Option<PaymentIntentPaymentMethodOptionsBacsDebitUnion>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub bancontact: Option<PaymentIntentPaymentMethodOptionsBancontactUnion>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub boleto: Option<PaymentIntentPaymentMethodOptionsBoletoUnion>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub card: Option<PaymentIntentPaymentMethodOptionsCardUnion>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub card_present: Option<PaymentIntentPaymentMethodOptionsCardPresentUnion>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub eps: Option<PaymentIntentPaymentMethodOptionsEpsUnion>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub fpx: Option<PaymentIntentPaymentMethodOptionsFpxUnion>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub giropay: Option<PaymentIntentPaymentMethodOptionsGiropayUnion>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub grabpay: Option<PaymentIntentPaymentMethodOptionsGrabpayUnion>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub ideal: Option<PaymentIntentPaymentMethodOptionsIdealUnion>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub interac_present: Option<PaymentIntentPaymentMethodOptionsInteracPresentUnion>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub klarna: Option<PaymentIntentPaymentMethodOptionsKlarnaUnion>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub konbini: Option<PaymentIntentPaymentMethodOptionsKonbiniUnion>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub oxxo: Option<PaymentIntentPaymentMethodOptionsOxxoUnion>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub p24: Option<PaymentIntentPaymentMethodOptionsP24Union>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub sepa_debit: Option<PaymentIntentPaymentMethodOptionsSepaDebitUnion>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub sofort: Option<PaymentIntentPaymentMethodOptionsSofortUnion>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub wechat_pay: Option<PaymentIntentPaymentMethodOptionsWechatPayUnion>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntentPaymentMethodOptionsAcssDebit {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub mandate_options: Option<PaymentIntentPaymentMethodOptionsMandateOptionsAcssDebit>,

    /// Indicates that you intend to make future payments with this PaymentIntent's payment method.
    ///
    /// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete.
    ///
    /// If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.  When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<PaymentIntentPaymentMethodOptionsAcssDebitSetupFutureUsage>,

    /// Bank account verification method.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub verification_method: Option<PaymentIntentPaymentMethodOptionsAcssDebitVerificationMethod>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntentPaymentMethodOptionsAuBecsDebit {
    /// Indicates that you intend to make future payments with this PaymentIntent's payment method.
    ///
    /// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete.
    ///
    /// If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.  When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<PaymentIntentPaymentMethodOptionsAuBecsDebitSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntentPaymentMethodOptionsCard {
    /// Installment details for this payment (Mexico only).
    ///
    /// For more information, see the [installments integration guide](https://stripe.com/docs/payments/installments).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub installments: Option<PaymentMethodOptionsCardInstallments>,

    /// Configuration options for setting up an eMandate for cards issued in India.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub mandate_options: Option<PaymentMethodOptionsCardMandateOptions>,

    /// Selected network to process this payment intent on.
    ///
    /// Depends on the available networks of the card attached to the payment intent.
    /// Can be only set confirm-time.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub network: Option<PaymentIntentPaymentMethodOptionsCardNetwork>,

    /// We strongly recommend that you rely on our SCA Engine to automatically prompt your customers for authentication based on risk level and [other requirements](https://stripe.com/docs/strong-customer-authentication).
    ///
    /// However, if you wish to request 3D Secure based on logic from your own fraud engine, provide this option.
    /// Permitted values include: `automatic` or `any`.
    /// If not provided, defaults to `automatic`.
    /// Read our guide on [manually requesting 3D Secure](https://stripe.com/docs/payments/3d-secure#manual-three-ds) for more information on how this configuration interacts with Radar and our SCA Engine.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub request_three_d_secure: Option<PaymentIntentPaymentMethodOptionsCardRequestThreeDSecure>,

    /// Indicates that you intend to make future payments with this PaymentIntent's payment method.
    ///
    /// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete.
    ///
    /// If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.  When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<PaymentIntentPaymentMethodOptionsCardSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntentPaymentMethodOptionsEps {
    /// Indicates that you intend to make future payments with this PaymentIntent's payment method.
    ///
    /// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete.
    ///
    /// If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.  When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<PaymentIntentPaymentMethodOptionsEpsSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntentPaymentMethodOptionsMandateOptionsAcssDebit {
    /// A URL for custom mandate text.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub custom_mandate_url: Option<String>,

    /// Description of the interval.
    ///
    /// Only required if the 'payment_schedule' parameter is 'interval' or 'combined'.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub interval_description: Option<String>,

    /// Payment schedule for the mandate.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub payment_schedule:
        Option<PaymentIntentPaymentMethodOptionsMandateOptionsAcssDebitPaymentSchedule>,

    /// Transaction type of the mandate.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transaction_type:
        Option<PaymentIntentPaymentMethodOptionsMandateOptionsAcssDebitTransactionType>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntentPaymentMethodOptionsSepaDebit {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub mandate_options: Option<PaymentIntentPaymentMethodOptionsMandateOptionsSepaDebit>,

    /// Indicates that you intend to make future payments with this PaymentIntent's payment method.
    ///
    /// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete.
    ///
    /// If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.  When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<PaymentIntentPaymentMethodOptionsSepaDebitSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntentPaymentMethodOptionsMandateOptionsSepaDebit {}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntentProcessing {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub card: Option<PaymentIntentCardProcessing>,

    /// Type of the payment method for which payment is in `processing` state, one of `card`.
    #[serde(rename = "type")]
    pub type_: PaymentIntentProcessingType,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntentCardProcessing {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub customer_notification: Option<PaymentIntentProcessingCustomerNotification>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntentProcessingCustomerNotification {
    /// Whether customer approval has been requested for this payment.
    ///
    /// For payments greater than INR 5000 or mandate amount, the customer must provide explicit approval of the payment with their bank.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub approval_requested: Option<bool>,

    /// If customer approval is required, they need to provide approval before this time.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub completes_at: Option<Timestamp>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentIntentTypeSpecificPaymentMethodOptionsClient {
    /// Indicates that you intend to make future payments with this PaymentIntent's payment method.
    ///
    /// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete.
    ///
    /// If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.  When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage:
        Option<PaymentIntentTypeSpecificPaymentMethodOptionsClientSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentMethodOptionsAfterpayClearpay {
    /// Order identifier shown to the customer in Afterpay’s online portal.
    ///
    /// We recommend using a value that helps you answer any questions a customer might have about the payment.
    /// The identifier is limited to 128 characters and may contain only letters, digits, underscores, backslashes and dashes.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub reference: Option<String>,

    /// Indicates that you intend to make future payments with this PaymentIntent's payment method.
    ///
    /// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete.
    ///
    /// If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.  When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<PaymentMethodOptionsAfterpayClearpaySetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentMethodOptionsAlipay {
    /// Indicates that you intend to make future payments with this PaymentIntent's payment method.
    ///
    /// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete.
    ///
    /// If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.  When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<PaymentMethodOptionsAlipaySetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentMethodOptionsBacsDebit {
    /// Indicates that you intend to make future payments with this PaymentIntent's payment method.
    ///
    /// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete.
    ///
    /// If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.  When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<PaymentMethodOptionsBacsDebitSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentMethodOptionsBancontact {
    /// Preferred language of the Bancontact authorization page that the customer is redirected to.
    pub preferred_language: PaymentMethodOptionsBancontactPreferredLanguage,

    /// Indicates that you intend to make future payments with this PaymentIntent's payment method.
    ///
    /// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete.
    ///
    /// If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.  When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<PaymentMethodOptionsBancontactSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentMethodOptionsBoleto {
    /// The number of calendar days before a Boleto voucher expires.
    ///
    /// For example, if you create a Boleto voucher on Monday and you set expires_after_days to 2, the Boleto voucher will expire on Wednesday at 23:59 America/Sao_Paulo time.
    pub expires_after_days: u32,

    /// Indicates that you intend to make future payments with this PaymentIntent's payment method.
    ///
    /// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete.
    ///
    /// If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.  When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<PaymentMethodOptionsBoletoSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentMethodOptionsCardInstallments {
    /// Installment plans that may be selected for this PaymentIntent.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub available_plans: Option<Vec<PaymentMethodDetailsCardInstallmentsPlan>>,

    /// Whether Installments are enabled for this PaymentIntent.
    pub enabled: bool,

    /// Installment plan selected for this PaymentIntent.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub plan: Option<PaymentMethodDetailsCardInstallmentsPlan>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentMethodOptionsCardMandateOptions {
    /// Amount to be charged for future payments.
    pub amount: i64,

    /// One of `fixed` or `maximum`.
    ///
    /// If `fixed`, the `amount` param refers to the exact amount to be charged in future payments.
    /// If `maximum`, the amount charged can be up to the value passed for the `amount` param.
    pub amount_type: PaymentMethodOptionsCardMandateOptionsAmountType,

    /// A description of the mandate or subscription that is meant to be displayed to the customer.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,

    /// End date of the mandate or subscription.
    ///
    /// If not provided, the mandate will be active until canceled.
    /// If provided, end date should be after start date.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub end_date: Option<Timestamp>,

    /// Specifies payment frequency.
    ///
    /// One of `day`, `week`, `month`, `year`, or `sporadic`.
    pub interval: PaymentMethodOptionsCardMandateOptionsInterval,

    /// The number of intervals between payments.
    ///
    /// For example, `interval=month` and `interval_count=3` indicates one payment every three months.
    /// Maximum of one year interval allowed (1 year, 12 months, or 52 weeks).
    /// This parameter is optional when `interval=sporadic`.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub interval_count: Option<u64>,

    /// Unique identifier for the mandate or subscription.
    pub reference: String,

    /// Start date of the mandate or subscription.
    ///
    /// Start date should not be lesser than yesterday.
    pub start_date: Timestamp,

    /// Specifies the type of mandates supported.
    ///
    /// Possible values are `india`.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub supported_types: Option<Vec<PaymentMethodOptionsCardMandateOptionsSupportedTypes>>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentMethodOptionsCardPresent {}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentMethodOptionsFpx {
    /// Indicates that you intend to make future payments with this PaymentIntent's payment method.
    ///
    /// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete.
    ///
    /// If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.  When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<PaymentMethodOptionsFpxSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentMethodOptionsGiropay {
    /// Indicates that you intend to make future payments with this PaymentIntent's payment method.
    ///
    /// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete.
    ///
    /// If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.  When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<PaymentMethodOptionsGiropaySetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentMethodOptionsGrabpay {
    /// Indicates that you intend to make future payments with this PaymentIntent's payment method.
    ///
    /// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete.
    ///
    /// If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.  When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<PaymentMethodOptionsGrabpaySetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentMethodOptionsIdeal {
    /// Indicates that you intend to make future payments with this PaymentIntent's payment method.
    ///
    /// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete.
    ///
    /// If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.  When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<PaymentMethodOptionsIdealSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentMethodOptionsInteracPresent {}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentMethodOptionsKlarna {
    /// Preferred locale of the Klarna checkout page that the customer is redirected to.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub preferred_locale: Option<String>,

    /// Indicates that you intend to make future payments with this PaymentIntent's payment method.
    ///
    /// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete.
    ///
    /// If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.  When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<PaymentMethodOptionsKlarnaSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentMethodOptionsKonbini {
    /// An optional 10 to 11 digit numeric-only string determining the confirmation code at applicable convenience stores.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub confirmation_number: Option<String>,

    /// The number of calendar days (between 1 and 60) after which Konbini payment instructions will expire.
    ///
    /// For example, if a PaymentIntent is confirmed with Konbini and `expires_after_days` set to 2 on Monday JST, the instructions will expire on Wednesday 23:59:59 JST.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expires_after_days: Option<u32>,

    /// The timestamp at which the Konbini payment instructions will expire.
    ///
    /// Only one of `expires_after_days` or `expires_at` may be set.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expires_at: Option<Timestamp>,

    /// A product descriptor of up to 22 characters, which will appear to customers at the convenience store.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub product_description: Option<String>,

    /// Indicates that you intend to make future payments with this PaymentIntent's payment method.
    ///
    /// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete.
    ///
    /// If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.  When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<PaymentMethodOptionsKonbiniSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentMethodOptionsOxxo {
    /// The number of calendar days before an OXXO invoice expires.
    ///
    /// For example, if you create an OXXO invoice on Monday and you set expires_after_days to 2, the OXXO invoice will expire on Wednesday at 23:59 America/Mexico_City time.
    pub expires_after_days: u32,

    /// Indicates that you intend to make future payments with this PaymentIntent's payment method.
    ///
    /// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete.
    ///
    /// If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.  When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<PaymentMethodOptionsOxxoSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentMethodOptionsP24 {
    /// Indicates that you intend to make future payments with this PaymentIntent's payment method.
    ///
    /// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete.
    ///
    /// If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.  When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<PaymentMethodOptionsP24SetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentMethodOptionsSofort {
    /// Preferred language of the SOFORT authorization page that the customer is redirected to.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub preferred_language: Option<PaymentMethodOptionsSofortPreferredLanguage>,

    /// Indicates that you intend to make future payments with this PaymentIntent's payment method.
    ///
    /// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete.
    ///
    /// If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.  When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<PaymentMethodOptionsSofortSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct PaymentMethodOptionsWechatPay {
    /// The app ID registered with WeChat Pay.
    ///
    /// Only required when client is ios or android.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_id: Option<String>,

    /// The client type that the end customer will pay from.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub client: Option<PaymentMethodOptionsWechatPayClient>,

    /// Indicates that you intend to make future payments with this PaymentIntent's payment method.
    ///
    /// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete.
    ///
    /// If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.  When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<PaymentMethodOptionsWechatPaySetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct TransferData {
    /// Amount intended to be collected by this PaymentIntent.
    ///
    /// A positive integer representing how much to charge in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal) (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal currency).
    /// The minimum amount is $0.50 US or [equivalent in charge currency](https://stripe.com/docs/currencies#minimum-and-maximum-charge-amounts).
    /// The amount value supports up to eight digits (e.g., a value of 99999999 for a USD charge of $999,999.99).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub amount: Option<i64>,

    /// The account (if any) the payment will be attributed to for tax
    /// reporting, and where funds from the payment will be transferred to upon
    /// payment success.
    pub destination: Expandable<Account>,
}

/// The parameters for `PaymentIntent::create`.
#[derive(Clone, Debug, Serialize)]
pub struct CreatePaymentIntent<'a> {
    /// Amount intended to be collected by this PaymentIntent.
    ///
    /// A positive integer representing how much to charge in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal) (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal currency).
    /// The minimum amount is $0.50 US or [equivalent in charge currency](https://stripe.com/docs/currencies#minimum-and-maximum-charge-amounts).
    /// The amount value supports up to eight digits (e.g., a value of 99999999 for a USD charge of $999,999.99).
    pub amount: i64,

    /// The amount of the application fee (if any) that will be requested to be applied to the payment and transferred to the application owner's Stripe account.
    ///
    /// The amount of the application fee collected will be capped at the total payment amount.
    /// For more information, see the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub application_fee_amount: Option<i64>,

    /// When enabled, this PaymentIntent will accept payment methods that you have enabled in the Dashboard and are compatible with this PaymentIntent's other parameters.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub automatic_payment_methods: Option<CreatePaymentIntentAutomaticPaymentMethods>,

    /// Controls when the funds will be captured from the customer's account.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub capture_method: Option<PaymentIntentCaptureMethod>,

    /// Set to `true` to attempt to [confirm](https://stripe.com/docs/api/payment_intents/confirm) this PaymentIntent immediately.
    ///
    /// This parameter defaults to `false`.
    /// When creating and confirming a PaymentIntent at the same time, parameters available in the [confirm](https://stripe.com/docs/api/payment_intents/confirm) API may also be provided.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub confirm: Option<bool>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub confirmation_method: Option<PaymentIntentConfirmationMethod>,

    /// Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase.
    ///
    /// Must be a [supported currency](https://stripe.com/docs/currencies).
    pub currency: Currency,

    /// ID of the Customer this PaymentIntent belongs to, if one exists.
    ///
    /// Payment methods attached to other Customers cannot be used with this PaymentIntent.
    ///
    /// If present in combination with [setup_future_usage](https://stripe.com/docs/api#payment_intent_object-setup_future_usage), this PaymentIntent's payment method will be attached to the Customer after the PaymentIntent has been confirmed and any required actions from the user are complete.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub customer: Option<CustomerId>,

    /// An arbitrary string attached to the object.
    ///
    /// Often useful for displaying to users.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<&'a str>,

    /// Set to `true` to fail the payment attempt if the PaymentIntent transitions into `requires_action`.
    ///
    /// This parameter is intended for simpler integrations that do not handle customer actions, like [saving cards without authentication](https://stripe.com/docs/payments/save-card-without-authentication).
    /// This parameter can only be used with [`confirm=true`](https://stripe.com/docs/api/payment_intents/create#create_payment_intent-confirm).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub error_on_requires_action: Option<bool>,

    /// Specifies which fields in the response should be expanded.
    #[serde(skip_serializing_if = "Expand::is_empty")]
    pub expand: &'a [&'a str],

    /// ID of the mandate to be used for this payment.
    ///
    /// This parameter can only be used with [`confirm=true`](https://stripe.com/docs/api/payment_intents/create#create_payment_intent-confirm).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub mandate: Option<MandateId>,

    /// This hash contains details about the Mandate to create.
    ///
    /// This parameter can only be used with [`confirm=true`](https://stripe.com/docs/api/payment_intents/create#create_payment_intent-confirm).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub mandate_data: Option<CreatePaymentIntentMandateData>,

    /// Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object.
    ///
    /// This can be useful for storing additional information about the object in a structured format.
    /// Individual keys can be unset by posting an empty value to them.
    /// All keys can be unset by posting an empty value to `metadata`.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata: Option<Metadata>,

    /// Set to `true` to indicate that the customer is not in your checkout flow during this payment attempt, and therefore is unable to authenticate.
    ///
    /// This parameter is intended for scenarios where you collect card details and [charge them later](https://stripe.com/docs/payments/cards/charging-saved-cards).
    /// This parameter can only be used with [`confirm=true`](https://stripe.com/docs/api/payment_intents/create#create_payment_intent-confirm).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub off_session: Option<PaymentIntentOffSession>,

    /// The Stripe account ID for which these funds are intended.
    ///
    /// For details, see the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub on_behalf_of: Option<&'a str>,

    /// ID of the payment method (a PaymentMethod, Card, or [compatible Source](https://stripe.com/docs/payments/payment-methods/transitioning#compatibility) object) to attach to this PaymentIntent.
    ///
    /// If this parameter is omitted with `confirm=true`, `customer.default_source` will be attached as this PaymentIntent's payment instrument to improve the migration experience for users of the Charges API.
    ///
    /// We recommend that you explicitly provide the `payment_method` going forward.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub payment_method: Option<PaymentMethodId>,

    /// If provided, this hash will be used to create a PaymentMethod.
    ///
    /// The new PaymentMethod will appear in the [payment_method](https://stripe.com/docs/api/payment_intents/object#payment_intent_object-payment_method) property on the PaymentIntent.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub payment_method_data: Option<CreatePaymentIntentPaymentMethodData>,

    /// Payment-method-specific configuration for this PaymentIntent.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub payment_method_options: Option<CreatePaymentIntentPaymentMethodOptions>,

    /// The list of payment method types (e.g.
    ///
    /// card) that this PaymentIntent is allowed to use.
    /// If this is not provided, defaults to ["card"].
    #[serde(skip_serializing_if = "Option::is_none")]
    pub payment_method_types: Option<Vec<String>>,

    /// Email address that the receipt for the resulting payment will be sent to.
    ///
    /// If `receipt_email` is specified for a payment in live mode, a receipt will be sent regardless of your [email settings](https://dashboard.stripe.com/account/emails).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub receipt_email: Option<&'a str>,

    /// The URL to redirect your customer back to after they authenticate or cancel their payment on the payment method's app or site.
    ///
    /// If you'd prefer to redirect to a mobile application, you can alternatively supply an application URI scheme.
    /// This parameter can only be used with [`confirm=true`](https://stripe.com/docs/api/payment_intents/create#create_payment_intent-confirm).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub return_url: Option<&'a str>,

    /// Indicates that you intend to make future payments with this PaymentIntent's payment method.
    ///
    /// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete.
    ///
    /// If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.  When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<PaymentIntentSetupFutureUsage>,

    /// Shipping information for this PaymentIntent.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub shipping: Option<CreatePaymentIntentShipping>,

    /// For non-card charges, you can use this value as the complete description that appears on your customers’ statements.
    ///
    /// Must contain at least one letter, maximum 22 characters.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub statement_descriptor: Option<&'a str>,

    /// Provides information about a card payment that customers see on their statements.
    ///
    /// Concatenated with the prefix (shortened descriptor) or statement descriptor that’s set on the account to form the complete statement descriptor.
    /// Maximum 22 characters for the concatenated descriptor.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub statement_descriptor_suffix: Option<&'a str>,

    /// The parameters used to automatically create a Transfer when the payment succeeds.
    /// For more information, see the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transfer_data: Option<CreatePaymentIntentTransferData>,

    /// A string that identifies the resulting payment as part of a group.
    ///
    /// See the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts) for details.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transfer_group: Option<&'a str>,

    /// Set to `true` only when using manual confirmation and the iOS or Android SDKs to handle additional authentication steps.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub use_stripe_sdk: Option<bool>,
}

impl<'a> CreatePaymentIntent<'a> {
    pub fn new(amount: i64, currency: Currency) -> Self {
        CreatePaymentIntent {
            amount,
            application_fee_amount: Default::default(),
            automatic_payment_methods: Default::default(),
            capture_method: Default::default(),
            confirm: Default::default(),
            confirmation_method: Default::default(),
            currency,
            customer: Default::default(),
            description: Default::default(),
            error_on_requires_action: Default::default(),
            expand: Default::default(),
            mandate: Default::default(),
            mandate_data: Default::default(),
            metadata: Default::default(),
            off_session: Default::default(),
            on_behalf_of: Default::default(),
            payment_method: Default::default(),
            payment_method_data: Default::default(),
            payment_method_options: Default::default(),
            payment_method_types: Default::default(),
            receipt_email: Default::default(),
            return_url: Default::default(),
            setup_future_usage: Default::default(),
            shipping: Default::default(),
            statement_descriptor: Default::default(),
            statement_descriptor_suffix: Default::default(),
            transfer_data: Default::default(),
            transfer_group: Default::default(),
            use_stripe_sdk: Default::default(),
        }
    }
}

/// The parameters for `PaymentIntent::list`.
#[derive(Clone, Debug, Serialize, Default)]
pub struct ListPaymentIntents<'a> {
    /// A filter on the list, based on the object `created` field.
    ///
    /// The value can be a string with an integer Unix timestamp, or it can be a dictionary with a number of different query options.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created: Option<RangeQuery<Timestamp>>,

    /// Only return PaymentIntents for the customer specified by this customer ID.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub customer: Option<CustomerId>,

    /// A cursor for use in pagination.
    ///
    /// `ending_before` is an object ID that defines your place in the list.
    /// For instance, if you make a list request and receive 100 objects, starting with `obj_bar`, your subsequent call can include `ending_before=obj_bar` in order to fetch the previous page of the list.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ending_before: Option<PaymentIntentId>,

    /// Specifies which fields in the response should be expanded.
    #[serde(skip_serializing_if = "Expand::is_empty")]
    pub expand: &'a [&'a str],

    /// A limit on the number of objects to be returned.
    ///
    /// Limit can range between 1 and 100, and the default is 10.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub limit: Option<u64>,

    /// A cursor for use in pagination.
    ///
    /// `starting_after` is an object ID that defines your place in the list.
    /// For instance, if you make a list request and receive 100 objects, ending with `obj_foo`, your subsequent call can include `starting_after=obj_foo` in order to fetch the next page of the list.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub starting_after: Option<PaymentIntentId>,
}

impl<'a> ListPaymentIntents<'a> {
    pub fn new() -> Self {
        ListPaymentIntents {
            created: Default::default(),
            customer: Default::default(),
            ending_before: Default::default(),
            expand: Default::default(),
            limit: Default::default(),
            starting_after: Default::default(),
        }
    }
}

/// The parameters for `PaymentIntent::update`.
#[derive(Clone, Debug, Serialize, Default)]
pub struct UpdatePaymentIntent<'a> {
    /// Amount intended to be collected by this PaymentIntent.
    ///
    /// A positive integer representing how much to charge in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal) (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal currency).
    /// The minimum amount is $0.50 US or [equivalent in charge currency](https://stripe.com/docs/currencies#minimum-and-maximum-charge-amounts).
    /// The amount value supports up to eight digits (e.g., a value of 99999999 for a USD charge of $999,999.99).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub amount: Option<i64>,

    /// The amount of the application fee (if any) that will be requested to be applied to the payment and transferred to the application owner's Stripe account.
    ///
    /// The amount of the application fee collected will be capped at the total payment amount.
    /// For more information, see the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub application_fee_amount: Option<i64>,

    /// Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase.
    ///
    /// Must be a [supported currency](https://stripe.com/docs/currencies).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub currency: Option<Currency>,

    /// ID of the Customer this PaymentIntent belongs to, if one exists.
    ///
    /// Payment methods attached to other Customers cannot be used with this PaymentIntent.
    ///
    /// If present in combination with [setup_future_usage](https://stripe.com/docs/api#payment_intent_object-setup_future_usage), this PaymentIntent's payment method will be attached to the Customer after the PaymentIntent has been confirmed and any required actions from the user are complete.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub customer: Option<CustomerId>,

    /// An arbitrary string attached to the object.
    ///
    /// Often useful for displaying to users.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<&'a str>,

    /// Specifies which fields in the response should be expanded.
    #[serde(skip_serializing_if = "Expand::is_empty")]
    pub expand: &'a [&'a str],

    /// Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object.
    ///
    /// This can be useful for storing additional information about the object in a structured format.
    /// Individual keys can be unset by posting an empty value to them.
    /// All keys can be unset by posting an empty value to `metadata`.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata: Option<Metadata>,

    /// ID of the payment method (a PaymentMethod, Card, or [compatible Source](https://stripe.com/docs/payments/payment-methods/transitioning#compatibility) object) to attach to this PaymentIntent.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub payment_method: Option<PaymentMethodId>,

    /// If provided, this hash will be used to create a PaymentMethod.
    ///
    /// The new PaymentMethod will appear in the [payment_method](https://stripe.com/docs/api/payment_intents/object#payment_intent_object-payment_method) property on the PaymentIntent.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub payment_method_data: Option<UpdatePaymentIntentPaymentMethodData>,

    /// Payment-method-specific configuration for this PaymentIntent.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub payment_method_options: Option<UpdatePaymentIntentPaymentMethodOptions>,

    /// The list of payment method types (e.g.
    ///
    /// card) that this PaymentIntent is allowed to use.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub payment_method_types: Option<Vec<String>>,

    /// Email address that the receipt for the resulting payment will be sent to.
    ///
    /// If `receipt_email` is specified for a payment in live mode, a receipt will be sent regardless of your [email settings](https://dashboard.stripe.com/account/emails).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub receipt_email: Option<String>,

    /// Indicates that you intend to make future payments with this PaymentIntent's payment method.
    ///
    /// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete.
    ///
    /// If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.  When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).  If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<PaymentIntentSetupFutureUsageFilter>,

    /// Shipping information for this PaymentIntent.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub shipping: Option<UpdatePaymentIntentShipping>,

    /// For non-card charges, you can use this value as the complete description that appears on your customers’ statements.
    ///
    /// Must contain at least one letter, maximum 22 characters.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub statement_descriptor: Option<&'a str>,

    /// Provides information about a card payment that customers see on their statements.
    ///
    /// Concatenated with the prefix (shortened descriptor) or statement descriptor that’s set on the account to form the complete statement descriptor.
    /// Maximum 22 characters for the concatenated descriptor.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub statement_descriptor_suffix: Option<&'a str>,

    /// The parameters used to automatically create a Transfer when the payment succeeds.
    ///
    /// For more information, see the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts).
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transfer_data: Option<UpdatePaymentIntentTransferData>,

    /// A string that identifies the resulting payment as part of a group.
    ///
    /// `transfer_group` may only be provided if it has not been set.
    /// See the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts) for details.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transfer_group: Option<&'a str>,
}

impl<'a> UpdatePaymentIntent<'a> {
    pub fn new() -> Self {
        UpdatePaymentIntent {
            amount: Default::default(),
            application_fee_amount: Default::default(),
            currency: Default::default(),
            customer: Default::default(),
            description: Default::default(),
            expand: Default::default(),
            metadata: Default::default(),
            payment_method: Default::default(),
            payment_method_data: Default::default(),
            payment_method_options: Default::default(),
            payment_method_types: Default::default(),
            receipt_email: Default::default(),
            setup_future_usage: Default::default(),
            shipping: Default::default(),
            statement_descriptor: Default::default(),
            statement_descriptor_suffix: Default::default(),
            transfer_data: Default::default(),
            transfer_group: Default::default(),
        }
    }
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentAutomaticPaymentMethods {
    pub enabled: bool,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentMandateData {
    pub customer_acceptance: CreatePaymentIntentMandateDataCustomerAcceptance,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodData {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub acss_debit: Option<CreatePaymentIntentPaymentMethodDataAcssDebit>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub afterpay_clearpay: Option<CreatePaymentIntentPaymentMethodDataAfterpayClearpay>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub alipay: Option<CreatePaymentIntentPaymentMethodDataAlipay>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub au_becs_debit: Option<CreatePaymentIntentPaymentMethodDataAuBecsDebit>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub bacs_debit: Option<CreatePaymentIntentPaymentMethodDataBacsDebit>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub bancontact: Option<CreatePaymentIntentPaymentMethodDataBancontact>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub billing_details: Option<CreatePaymentIntentPaymentMethodDataBillingDetails>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub boleto: Option<CreatePaymentIntentPaymentMethodDataBoleto>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub eps: Option<CreatePaymentIntentPaymentMethodDataEps>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub fpx: Option<CreatePaymentIntentPaymentMethodDataFpx>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub giropay: Option<CreatePaymentIntentPaymentMethodDataGiropay>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub grabpay: Option<CreatePaymentIntentPaymentMethodDataGrabpay>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub ideal: Option<CreatePaymentIntentPaymentMethodDataIdeal>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub interac_present: Option<CreatePaymentIntentPaymentMethodDataInteracPresent>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub klarna: Option<CreatePaymentIntentPaymentMethodDataKlarna>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub konbini: Option<CreatePaymentIntentPaymentMethodDataKonbini>,

    #[serde(default)]
    pub metadata: Metadata,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub oxxo: Option<CreatePaymentIntentPaymentMethodDataOxxo>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub p24: Option<CreatePaymentIntentPaymentMethodDataP24>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub sepa_debit: Option<CreatePaymentIntentPaymentMethodDataSepaDebit>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub sofort: Option<CreatePaymentIntentPaymentMethodDataSofort>,

    #[serde(rename = "type")]
    pub type_: CreatePaymentIntentPaymentMethodDataType,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub wechat_pay: Option<CreatePaymentIntentPaymentMethodDataWechatPay>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodOptions {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub acss_debit: Option<CreatePaymentIntentPaymentMethodOptionsAcssDebit>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub afterpay_clearpay: Option<CreatePaymentIntentPaymentMethodOptionsAfterpayClearpay>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub alipay: Option<CreatePaymentIntentPaymentMethodOptionsAlipay>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub au_becs_debit: Option<CreatePaymentIntentPaymentMethodOptionsAuBecsDebit>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub bacs_debit: Option<CreatePaymentIntentPaymentMethodOptionsBacsDebit>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub bancontact: Option<CreatePaymentIntentPaymentMethodOptionsBancontact>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub boleto: Option<CreatePaymentIntentPaymentMethodOptionsBoleto>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub card: Option<CreatePaymentIntentPaymentMethodOptionsCard>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub card_present: Option<CreatePaymentIntentPaymentMethodOptionsCardPresent>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub eps: Option<CreatePaymentIntentPaymentMethodOptionsEps>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub fpx: Option<CreatePaymentIntentPaymentMethodOptionsFpx>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub giropay: Option<CreatePaymentIntentPaymentMethodOptionsGiropay>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub grabpay: Option<CreatePaymentIntentPaymentMethodOptionsGrabpay>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub ideal: Option<CreatePaymentIntentPaymentMethodOptionsIdeal>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub interac_present: Option<CreatePaymentIntentPaymentMethodOptionsInteracPresent>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub klarna: Option<CreatePaymentIntentPaymentMethodOptionsKlarna>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub konbini: Option<CreatePaymentIntentPaymentMethodOptionsKonbini>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub oxxo: Option<CreatePaymentIntentPaymentMethodOptionsOxxo>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub p24: Option<CreatePaymentIntentPaymentMethodOptionsP24>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub sepa_debit: Option<CreatePaymentIntentPaymentMethodOptionsSepaDebit>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub sofort: Option<CreatePaymentIntentPaymentMethodOptionsSofort>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub wechat_pay: Option<CreatePaymentIntentPaymentMethodOptionsWechatPay>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentShipping {
    pub address: CreatePaymentIntentShippingAddress,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub carrier: Option<String>,

    pub name: String,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub phone: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub tracking_number: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentTransferData {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub amount: Option<i64>,

    pub destination: String,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodData {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub acss_debit: Option<UpdatePaymentIntentPaymentMethodDataAcssDebit>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub afterpay_clearpay: Option<UpdatePaymentIntentPaymentMethodDataAfterpayClearpay>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub alipay: Option<UpdatePaymentIntentPaymentMethodDataAlipay>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub au_becs_debit: Option<UpdatePaymentIntentPaymentMethodDataAuBecsDebit>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub bacs_debit: Option<UpdatePaymentIntentPaymentMethodDataBacsDebit>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub bancontact: Option<UpdatePaymentIntentPaymentMethodDataBancontact>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub billing_details: Option<UpdatePaymentIntentPaymentMethodDataBillingDetails>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub boleto: Option<UpdatePaymentIntentPaymentMethodDataBoleto>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub eps: Option<UpdatePaymentIntentPaymentMethodDataEps>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub fpx: Option<UpdatePaymentIntentPaymentMethodDataFpx>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub giropay: Option<UpdatePaymentIntentPaymentMethodDataGiropay>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub grabpay: Option<UpdatePaymentIntentPaymentMethodDataGrabpay>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub ideal: Option<UpdatePaymentIntentPaymentMethodDataIdeal>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub interac_present: Option<UpdatePaymentIntentPaymentMethodDataInteracPresent>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub klarna: Option<UpdatePaymentIntentPaymentMethodDataKlarna>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub konbini: Option<UpdatePaymentIntentPaymentMethodDataKonbini>,

    #[serde(default)]
    pub metadata: Metadata,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub oxxo: Option<UpdatePaymentIntentPaymentMethodDataOxxo>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub p24: Option<UpdatePaymentIntentPaymentMethodDataP24>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub sepa_debit: Option<UpdatePaymentIntentPaymentMethodDataSepaDebit>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub sofort: Option<UpdatePaymentIntentPaymentMethodDataSofort>,

    #[serde(rename = "type")]
    pub type_: UpdatePaymentIntentPaymentMethodDataType,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub wechat_pay: Option<UpdatePaymentIntentPaymentMethodDataWechatPay>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodOptions {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub acss_debit: Option<UpdatePaymentIntentPaymentMethodOptionsAcssDebit>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub afterpay_clearpay: Option<UpdatePaymentIntentPaymentMethodOptionsAfterpayClearpay>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub alipay: Option<UpdatePaymentIntentPaymentMethodOptionsAlipay>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub au_becs_debit: Option<UpdatePaymentIntentPaymentMethodOptionsAuBecsDebit>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub bacs_debit: Option<UpdatePaymentIntentPaymentMethodOptionsBacsDebit>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub bancontact: Option<UpdatePaymentIntentPaymentMethodOptionsBancontact>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub boleto: Option<UpdatePaymentIntentPaymentMethodOptionsBoleto>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub card: Option<UpdatePaymentIntentPaymentMethodOptionsCard>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub card_present: Option<UpdatePaymentIntentPaymentMethodOptionsCardPresent>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub eps: Option<UpdatePaymentIntentPaymentMethodOptionsEps>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub fpx: Option<UpdatePaymentIntentPaymentMethodOptionsFpx>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub giropay: Option<UpdatePaymentIntentPaymentMethodOptionsGiropay>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub grabpay: Option<UpdatePaymentIntentPaymentMethodOptionsGrabpay>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub ideal: Option<UpdatePaymentIntentPaymentMethodOptionsIdeal>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub interac_present: Option<UpdatePaymentIntentPaymentMethodOptionsInteracPresent>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub klarna: Option<UpdatePaymentIntentPaymentMethodOptionsKlarna>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub konbini: Option<UpdatePaymentIntentPaymentMethodOptionsKonbini>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub oxxo: Option<UpdatePaymentIntentPaymentMethodOptionsOxxo>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub p24: Option<UpdatePaymentIntentPaymentMethodOptionsP24>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub sepa_debit: Option<UpdatePaymentIntentPaymentMethodOptionsSepaDebit>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub sofort: Option<UpdatePaymentIntentPaymentMethodOptionsSofort>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub wechat_pay: Option<UpdatePaymentIntentPaymentMethodOptionsWechatPay>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentShipping {
    pub address: UpdatePaymentIntentShippingAddress,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub carrier: Option<String>,

    pub name: String,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub phone: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub tracking_number: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentTransferData {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub amount: Option<i64>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentMandateDataCustomerAcceptance {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub accepted_at: Option<Timestamp>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub offline: Option<CreatePaymentIntentMandateDataCustomerAcceptanceOffline>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub online: Option<CreatePaymentIntentMandateDataCustomerAcceptanceOnline>,

    #[serde(rename = "type")]
    pub type_: CreatePaymentIntentMandateDataCustomerAcceptanceType,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodDataAcssDebit {
    pub account_number: String,

    pub institution_number: String,

    pub transit_number: String,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodDataAfterpayClearpay {}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodDataAlipay {}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodDataAuBecsDebit {
    pub account_number: String,

    pub bsb_number: String,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodDataBacsDebit {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub account_number: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_code: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodDataBancontact {}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodDataBillingDetails {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub address: Option<CreatePaymentIntentPaymentMethodDataBillingDetailsAddress>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub phone: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodDataBoleto {
    pub tax_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodDataEps {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub bank: Option<CreatePaymentIntentPaymentMethodDataEpsBank>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodDataFpx {
    pub bank: CreatePaymentIntentPaymentMethodDataFpxBank,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodDataGiropay {}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodDataGrabpay {}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodDataIdeal {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub bank: Option<CreatePaymentIntentPaymentMethodDataIdealBank>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodDataInteracPresent {}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodDataKlarna {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub dob: Option<CreatePaymentIntentPaymentMethodDataKlarnaDob>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodDataKonbini {}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodDataOxxo {}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodDataP24 {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub bank: Option<CreatePaymentIntentPaymentMethodDataP24Bank>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodDataSepaDebit {
    pub iban: String,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodDataSofort {
    pub country: CreatePaymentIntentPaymentMethodDataSofortCountry,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodDataWechatPay {}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodOptionsAcssDebit {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub mandate_options: Option<CreatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptions>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage:
        Option<CreatePaymentIntentPaymentMethodOptionsAcssDebitSetupFutureUsage>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub verification_method:
        Option<CreatePaymentIntentPaymentMethodOptionsAcssDebitVerificationMethod>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodOptionsAfterpayClearpay {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub reference: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage:
        Option<CreatePaymentIntentPaymentMethodOptionsAfterpayClearpaySetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodOptionsAlipay {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<CreatePaymentIntentPaymentMethodOptionsAlipaySetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodOptionsAuBecsDebit {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage:
        Option<CreatePaymentIntentPaymentMethodOptionsAuBecsDebitSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodOptionsBacsDebit {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage:
        Option<CreatePaymentIntentPaymentMethodOptionsBacsDebitSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodOptionsBancontact {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub preferred_language:
        Option<CreatePaymentIntentPaymentMethodOptionsBancontactPreferredLanguage>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage:
        Option<CreatePaymentIntentPaymentMethodOptionsBancontactSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodOptionsBoleto {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expires_after_days: Option<u32>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<CreatePaymentIntentPaymentMethodOptionsBoletoSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodOptionsCard {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub cvc_token: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub installments: Option<CreatePaymentIntentPaymentMethodOptionsCardInstallments>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub mandate_options: Option<CreatePaymentIntentPaymentMethodOptionsCardMandateOptions>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub network: Option<CreatePaymentIntentPaymentMethodOptionsCardNetwork>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub request_three_d_secure:
        Option<CreatePaymentIntentPaymentMethodOptionsCardRequestThreeDSecure>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<CreatePaymentIntentPaymentMethodOptionsCardSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodOptionsCardPresent {}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodOptionsEps {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<CreatePaymentIntentPaymentMethodOptionsEpsSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodOptionsFpx {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<CreatePaymentIntentPaymentMethodOptionsFpxSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodOptionsGiropay {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<CreatePaymentIntentPaymentMethodOptionsGiropaySetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodOptionsGrabpay {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<CreatePaymentIntentPaymentMethodOptionsGrabpaySetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodOptionsIdeal {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<CreatePaymentIntentPaymentMethodOptionsIdealSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodOptionsInteracPresent {}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodOptionsKlarna {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub preferred_locale: Option<CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<CreatePaymentIntentPaymentMethodOptionsKlarnaSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodOptionsKonbini {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub confirmation_number: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub expires_after_days: Option<u32>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub expires_at: Option<Timestamp>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub product_description: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<CreatePaymentIntentPaymentMethodOptionsKonbiniSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodOptionsOxxo {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expires_after_days: Option<u32>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<CreatePaymentIntentPaymentMethodOptionsOxxoSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodOptionsP24 {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<CreatePaymentIntentPaymentMethodOptionsP24SetupFutureUsage>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub tos_shown_and_accepted: Option<bool>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodOptionsSepaDebit {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub mandate_options: Option<CreatePaymentIntentPaymentMethodOptionsSepaDebitMandateOptions>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage:
        Option<CreatePaymentIntentPaymentMethodOptionsSepaDebitSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodOptionsSofort {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub preferred_language: Option<CreatePaymentIntentPaymentMethodOptionsSofortPreferredLanguage>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<CreatePaymentIntentPaymentMethodOptionsSofortSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodOptionsWechatPay {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_id: Option<String>,

    pub client: CreatePaymentIntentPaymentMethodOptionsWechatPayClient,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage:
        Option<CreatePaymentIntentPaymentMethodOptionsWechatPaySetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentShippingAddress {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub city: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub country: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub line1: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub line2: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub postal_code: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodDataAcssDebit {
    pub account_number: String,

    pub institution_number: String,

    pub transit_number: String,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodDataAfterpayClearpay {}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodDataAlipay {}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodDataAuBecsDebit {
    pub account_number: String,

    pub bsb_number: String,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodDataBacsDebit {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub account_number: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_code: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodDataBancontact {}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodDataBillingDetails {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub address: Option<UpdatePaymentIntentPaymentMethodDataBillingDetailsAddress>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub phone: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodDataBoleto {
    pub tax_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodDataEps {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub bank: Option<UpdatePaymentIntentPaymentMethodDataEpsBank>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodDataFpx {
    pub bank: UpdatePaymentIntentPaymentMethodDataFpxBank,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodDataGiropay {}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodDataGrabpay {}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodDataIdeal {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub bank: Option<UpdatePaymentIntentPaymentMethodDataIdealBank>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodDataInteracPresent {}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodDataKlarna {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub dob: Option<UpdatePaymentIntentPaymentMethodDataKlarnaDob>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodDataKonbini {}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodDataOxxo {}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodDataP24 {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub bank: Option<UpdatePaymentIntentPaymentMethodDataP24Bank>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodDataSepaDebit {
    pub iban: String,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodDataSofort {
    pub country: UpdatePaymentIntentPaymentMethodDataSofortCountry,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodDataWechatPay {}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodOptionsAcssDebit {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub mandate_options: Option<UpdatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptions>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage:
        Option<UpdatePaymentIntentPaymentMethodOptionsAcssDebitSetupFutureUsage>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub verification_method:
        Option<UpdatePaymentIntentPaymentMethodOptionsAcssDebitVerificationMethod>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodOptionsAfterpayClearpay {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub reference: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage:
        Option<UpdatePaymentIntentPaymentMethodOptionsAfterpayClearpaySetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodOptionsAlipay {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<UpdatePaymentIntentPaymentMethodOptionsAlipaySetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodOptionsAuBecsDebit {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage:
        Option<UpdatePaymentIntentPaymentMethodOptionsAuBecsDebitSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodOptionsBacsDebit {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage:
        Option<UpdatePaymentIntentPaymentMethodOptionsBacsDebitSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodOptionsBancontact {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub preferred_language:
        Option<UpdatePaymentIntentPaymentMethodOptionsBancontactPreferredLanguage>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage:
        Option<UpdatePaymentIntentPaymentMethodOptionsBancontactSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodOptionsBoleto {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expires_after_days: Option<u32>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<UpdatePaymentIntentPaymentMethodOptionsBoletoSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodOptionsCard {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub cvc_token: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub installments: Option<UpdatePaymentIntentPaymentMethodOptionsCardInstallments>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub mandate_options: Option<UpdatePaymentIntentPaymentMethodOptionsCardMandateOptions>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub network: Option<UpdatePaymentIntentPaymentMethodOptionsCardNetwork>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub request_three_d_secure:
        Option<UpdatePaymentIntentPaymentMethodOptionsCardRequestThreeDSecure>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<UpdatePaymentIntentPaymentMethodOptionsCardSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodOptionsCardPresent {}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodOptionsEps {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<UpdatePaymentIntentPaymentMethodOptionsEpsSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodOptionsFpx {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<UpdatePaymentIntentPaymentMethodOptionsFpxSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodOptionsGiropay {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<UpdatePaymentIntentPaymentMethodOptionsGiropaySetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodOptionsGrabpay {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<UpdatePaymentIntentPaymentMethodOptionsGrabpaySetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodOptionsIdeal {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<UpdatePaymentIntentPaymentMethodOptionsIdealSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodOptionsInteracPresent {}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodOptionsKlarna {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub preferred_locale: Option<UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<UpdatePaymentIntentPaymentMethodOptionsKlarnaSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodOptionsKonbini {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub confirmation_number: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub expires_after_days: Option<u32>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub expires_at: Option<Timestamp>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub product_description: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<UpdatePaymentIntentPaymentMethodOptionsKonbiniSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodOptionsOxxo {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expires_after_days: Option<u32>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<UpdatePaymentIntentPaymentMethodOptionsOxxoSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodOptionsP24 {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<UpdatePaymentIntentPaymentMethodOptionsP24SetupFutureUsage>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub tos_shown_and_accepted: Option<bool>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodOptionsSepaDebit {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub mandate_options: Option<UpdatePaymentIntentPaymentMethodOptionsSepaDebitMandateOptions>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage:
        Option<UpdatePaymentIntentPaymentMethodOptionsSepaDebitSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodOptionsSofort {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub preferred_language: Option<UpdatePaymentIntentPaymentMethodOptionsSofortPreferredLanguage>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage: Option<UpdatePaymentIntentPaymentMethodOptionsSofortSetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodOptionsWechatPay {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_id: Option<String>,

    pub client: UpdatePaymentIntentPaymentMethodOptionsWechatPayClient,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub setup_future_usage:
        Option<UpdatePaymentIntentPaymentMethodOptionsWechatPaySetupFutureUsage>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentShippingAddress {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub city: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub country: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub line1: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub line2: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub postal_code: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentMandateDataCustomerAcceptanceOffline {}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentMandateDataCustomerAcceptanceOnline {
    pub ip_address: String,

    pub user_agent: String,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodDataBillingDetailsAddress {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub city: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub country: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub line1: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub line2: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub postal_code: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodDataKlarnaDob {
    pub day: i64,

    pub month: i64,

    pub year: i64,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptions {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub custom_mandate_url: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub interval_description: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub payment_schedule:
        Option<CreatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsPaymentSchedule>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub transaction_type:
        Option<CreatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsTransactionType>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodOptionsCardInstallments {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub plan: Option<CreatePaymentIntentPaymentMethodOptionsCardInstallmentsPlan>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodOptionsCardMandateOptions {
    pub amount: i64,

    pub amount_type: CreatePaymentIntentPaymentMethodOptionsCardMandateOptionsAmountType,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub end_date: Option<Timestamp>,

    pub interval: CreatePaymentIntentPaymentMethodOptionsCardMandateOptionsInterval,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub interval_count: Option<u64>,

    pub reference: String,

    pub start_date: Timestamp,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub supported_types:
        Option<Vec<CreatePaymentIntentPaymentMethodOptionsCardMandateOptionsSupportedTypes>>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodOptionsSepaDebitMandateOptions {}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodDataBillingDetailsAddress {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub city: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub country: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub line1: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub line2: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub postal_code: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodDataKlarnaDob {
    pub day: i64,

    pub month: i64,

    pub year: i64,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptions {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub custom_mandate_url: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub interval_description: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub payment_schedule:
        Option<UpdatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsPaymentSchedule>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub transaction_type:
        Option<UpdatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsTransactionType>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodOptionsCardInstallments {
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub plan: Option<UpdatePaymentIntentPaymentMethodOptionsCardInstallmentsPlan>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodOptionsCardMandateOptions {
    pub amount: i64,

    pub amount_type: UpdatePaymentIntentPaymentMethodOptionsCardMandateOptionsAmountType,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub end_date: Option<Timestamp>,

    pub interval: UpdatePaymentIntentPaymentMethodOptionsCardMandateOptionsInterval,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub interval_count: Option<u64>,

    pub reference: String,

    pub start_date: Timestamp,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub supported_types:
        Option<Vec<UpdatePaymentIntentPaymentMethodOptionsCardMandateOptionsSupportedTypes>>,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodOptionsSepaDebitMandateOptions {}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct CreatePaymentIntentPaymentMethodOptionsCardInstallmentsPlan {
    pub count: u64,

    pub interval: CreatePaymentIntentPaymentMethodOptionsCardInstallmentsPlanInterval,

    #[serde(rename = "type")]
    pub type_: CreatePaymentIntentPaymentMethodOptionsCardInstallmentsPlanType,
}

#[derive(Clone, Debug, Default, Deserialize, Serialize)]
pub struct UpdatePaymentIntentPaymentMethodOptionsCardInstallmentsPlan {
    pub count: u64,

    pub interval: UpdatePaymentIntentPaymentMethodOptionsCardInstallmentsPlanInterval,

    #[serde(rename = "type")]
    pub type_: UpdatePaymentIntentPaymentMethodOptionsCardInstallmentsPlanType,
}

#[derive(Clone, Debug, Deserialize, Serialize)]
#[serde(untagged, rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsAcssDebitUnion {
    PaymentIntentPaymentMethodOptionsAcssDebit(PaymentIntentPaymentMethodOptionsAcssDebit),
    #[serde(rename = "PaymentIntentTypeSpecificPaymentMethodOptionsClient")]
    PaymentIntentTypeSpecificPaymentMethodOptionsClient(
        PaymentIntentTypeSpecificPaymentMethodOptionsClient,
    ),
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsAcssDebitUnion {
    fn default() -> Self {
        Self::PaymentIntentPaymentMethodOptionsAcssDebit(Default::default())
    }
}

#[derive(Clone, Debug, Deserialize, Serialize)]
#[serde(untagged, rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsAfterpayClearpayUnion {
    PaymentMethodOptionsAfterpayClearpay(PaymentMethodOptionsAfterpayClearpay),
    #[serde(rename = "PaymentIntentTypeSpecificPaymentMethodOptionsClient")]
    PaymentIntentTypeSpecificPaymentMethodOptionsClient(
        PaymentIntentTypeSpecificPaymentMethodOptionsClient,
    ),
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsAfterpayClearpayUnion {
    fn default() -> Self {
        Self::PaymentMethodOptionsAfterpayClearpay(Default::default())
    }
}

#[derive(Clone, Debug, Deserialize, Serialize)]
#[serde(untagged, rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsAlipayUnion {
    PaymentMethodOptionsAlipay(PaymentMethodOptionsAlipay),
    #[serde(rename = "PaymentIntentTypeSpecificPaymentMethodOptionsClient")]
    PaymentIntentTypeSpecificPaymentMethodOptionsClient(
        PaymentIntentTypeSpecificPaymentMethodOptionsClient,
    ),
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsAlipayUnion {
    fn default() -> Self {
        Self::PaymentMethodOptionsAlipay(Default::default())
    }
}

#[derive(Clone, Debug, Deserialize, Serialize)]
#[serde(untagged, rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsAuBecsDebitUnion {
    PaymentIntentPaymentMethodOptionsAuBecsDebit(PaymentIntentPaymentMethodOptionsAuBecsDebit),
    #[serde(rename = "PaymentIntentTypeSpecificPaymentMethodOptionsClient")]
    PaymentIntentTypeSpecificPaymentMethodOptionsClient(
        PaymentIntentTypeSpecificPaymentMethodOptionsClient,
    ),
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsAuBecsDebitUnion {
    fn default() -> Self {
        Self::PaymentIntentPaymentMethodOptionsAuBecsDebit(Default::default())
    }
}

#[derive(Clone, Debug, Deserialize, Serialize)]
#[serde(untagged, rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsBacsDebitUnion {
    PaymentMethodOptionsBacsDebit(PaymentMethodOptionsBacsDebit),
    #[serde(rename = "PaymentIntentTypeSpecificPaymentMethodOptionsClient")]
    PaymentIntentTypeSpecificPaymentMethodOptionsClient(
        PaymentIntentTypeSpecificPaymentMethodOptionsClient,
    ),
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsBacsDebitUnion {
    fn default() -> Self {
        Self::PaymentMethodOptionsBacsDebit(Default::default())
    }
}

#[derive(Clone, Debug, Deserialize, Serialize)]
#[serde(untagged, rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsBancontactUnion {
    PaymentMethodOptionsBancontact(PaymentMethodOptionsBancontact),
    #[serde(rename = "PaymentIntentTypeSpecificPaymentMethodOptionsClient")]
    PaymentIntentTypeSpecificPaymentMethodOptionsClient(
        PaymentIntentTypeSpecificPaymentMethodOptionsClient,
    ),
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsBancontactUnion {
    fn default() -> Self {
        Self::PaymentMethodOptionsBancontact(Default::default())
    }
}

#[derive(Clone, Debug, Deserialize, Serialize)]
#[serde(untagged, rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsBoletoUnion {
    PaymentMethodOptionsBoleto(PaymentMethodOptionsBoleto),
    #[serde(rename = "PaymentIntentTypeSpecificPaymentMethodOptionsClient")]
    PaymentIntentTypeSpecificPaymentMethodOptionsClient(
        PaymentIntentTypeSpecificPaymentMethodOptionsClient,
    ),
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsBoletoUnion {
    fn default() -> Self {
        Self::PaymentMethodOptionsBoleto(Default::default())
    }
}

#[derive(Clone, Debug, Deserialize, Serialize)]
#[serde(untagged, rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsCardPresentUnion {
    PaymentMethodOptionsCardPresent(PaymentMethodOptionsCardPresent),
    #[serde(rename = "PaymentIntentTypeSpecificPaymentMethodOptionsClient")]
    PaymentIntentTypeSpecificPaymentMethodOptionsClient(
        PaymentIntentTypeSpecificPaymentMethodOptionsClient,
    ),
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsCardPresentUnion {
    fn default() -> Self {
        Self::PaymentMethodOptionsCardPresent(Default::default())
    }
}

#[derive(Clone, Debug, Deserialize, Serialize)]
#[serde(untagged, rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsCardUnion {
    PaymentIntentPaymentMethodOptionsCard(PaymentIntentPaymentMethodOptionsCard),
    #[serde(rename = "PaymentIntentTypeSpecificPaymentMethodOptionsClient")]
    PaymentIntentTypeSpecificPaymentMethodOptionsClient(
        PaymentIntentTypeSpecificPaymentMethodOptionsClient,
    ),
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsCardUnion {
    fn default() -> Self {
        Self::PaymentIntentPaymentMethodOptionsCard(Default::default())
    }
}

#[derive(Clone, Debug, Deserialize, Serialize)]
#[serde(untagged, rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsEpsUnion {
    PaymentIntentPaymentMethodOptionsEps(PaymentIntentPaymentMethodOptionsEps),
    #[serde(rename = "PaymentIntentTypeSpecificPaymentMethodOptionsClient")]
    PaymentIntentTypeSpecificPaymentMethodOptionsClient(
        PaymentIntentTypeSpecificPaymentMethodOptionsClient,
    ),
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsEpsUnion {
    fn default() -> Self {
        Self::PaymentIntentPaymentMethodOptionsEps(Default::default())
    }
}

#[derive(Clone, Debug, Deserialize, Serialize)]
#[serde(untagged, rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsFpxUnion {
    PaymentMethodOptionsFpx(PaymentMethodOptionsFpx),
    #[serde(rename = "PaymentIntentTypeSpecificPaymentMethodOptionsClient")]
    PaymentIntentTypeSpecificPaymentMethodOptionsClient(
        PaymentIntentTypeSpecificPaymentMethodOptionsClient,
    ),
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsFpxUnion {
    fn default() -> Self {
        Self::PaymentMethodOptionsFpx(Default::default())
    }
}

#[derive(Clone, Debug, Deserialize, Serialize)]
#[serde(untagged, rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsGiropayUnion {
    PaymentMethodOptionsGiropay(PaymentMethodOptionsGiropay),
    #[serde(rename = "PaymentIntentTypeSpecificPaymentMethodOptionsClient")]
    PaymentIntentTypeSpecificPaymentMethodOptionsClient(
        PaymentIntentTypeSpecificPaymentMethodOptionsClient,
    ),
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsGiropayUnion {
    fn default() -> Self {
        Self::PaymentMethodOptionsGiropay(Default::default())
    }
}

#[derive(Clone, Debug, Deserialize, Serialize)]
#[serde(untagged, rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsGrabpayUnion {
    PaymentMethodOptionsGrabpay(PaymentMethodOptionsGrabpay),
    #[serde(rename = "PaymentIntentTypeSpecificPaymentMethodOptionsClient")]
    PaymentIntentTypeSpecificPaymentMethodOptionsClient(
        PaymentIntentTypeSpecificPaymentMethodOptionsClient,
    ),
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsGrabpayUnion {
    fn default() -> Self {
        Self::PaymentMethodOptionsGrabpay(Default::default())
    }
}

#[derive(Clone, Debug, Deserialize, Serialize)]
#[serde(untagged, rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsIdealUnion {
    PaymentMethodOptionsIdeal(PaymentMethodOptionsIdeal),
    #[serde(rename = "PaymentIntentTypeSpecificPaymentMethodOptionsClient")]
    PaymentIntentTypeSpecificPaymentMethodOptionsClient(
        PaymentIntentTypeSpecificPaymentMethodOptionsClient,
    ),
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsIdealUnion {
    fn default() -> Self {
        Self::PaymentMethodOptionsIdeal(Default::default())
    }
}

#[derive(Clone, Debug, Deserialize, Serialize)]
#[serde(untagged, rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsInteracPresentUnion {
    PaymentMethodOptionsInteracPresent(PaymentMethodOptionsInteracPresent),
    #[serde(rename = "PaymentIntentTypeSpecificPaymentMethodOptionsClient")]
    PaymentIntentTypeSpecificPaymentMethodOptionsClient(
        PaymentIntentTypeSpecificPaymentMethodOptionsClient,
    ),
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsInteracPresentUnion {
    fn default() -> Self {
        Self::PaymentMethodOptionsInteracPresent(Default::default())
    }
}

#[derive(Clone, Debug, Deserialize, Serialize)]
#[serde(untagged, rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsKlarnaUnion {
    PaymentMethodOptionsKlarna(PaymentMethodOptionsKlarna),
    #[serde(rename = "PaymentIntentTypeSpecificPaymentMethodOptionsClient")]
    PaymentIntentTypeSpecificPaymentMethodOptionsClient(
        PaymentIntentTypeSpecificPaymentMethodOptionsClient,
    ),
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsKlarnaUnion {
    fn default() -> Self {
        Self::PaymentMethodOptionsKlarna(Default::default())
    }
}

#[derive(Clone, Debug, Deserialize, Serialize)]
#[serde(untagged, rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsKonbiniUnion {
    PaymentMethodOptionsKonbini(PaymentMethodOptionsKonbini),
    #[serde(rename = "PaymentIntentTypeSpecificPaymentMethodOptionsClient")]
    PaymentIntentTypeSpecificPaymentMethodOptionsClient(
        PaymentIntentTypeSpecificPaymentMethodOptionsClient,
    ),
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsKonbiniUnion {
    fn default() -> Self {
        Self::PaymentMethodOptionsKonbini(Default::default())
    }
}

#[derive(Clone, Debug, Deserialize, Serialize)]
#[serde(untagged, rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsOxxoUnion {
    PaymentMethodOptionsOxxo(PaymentMethodOptionsOxxo),
    #[serde(rename = "PaymentIntentTypeSpecificPaymentMethodOptionsClient")]
    PaymentIntentTypeSpecificPaymentMethodOptionsClient(
        PaymentIntentTypeSpecificPaymentMethodOptionsClient,
    ),
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsOxxoUnion {
    fn default() -> Self {
        Self::PaymentMethodOptionsOxxo(Default::default())
    }
}

#[derive(Clone, Debug, Deserialize, Serialize)]
#[serde(untagged, rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsP24Union {
    PaymentMethodOptionsP24(PaymentMethodOptionsP24),
    #[serde(rename = "PaymentIntentTypeSpecificPaymentMethodOptionsClient")]
    PaymentIntentTypeSpecificPaymentMethodOptionsClient(
        PaymentIntentTypeSpecificPaymentMethodOptionsClient,
    ),
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsP24Union {
    fn default() -> Self {
        Self::PaymentMethodOptionsP24(Default::default())
    }
}

#[derive(Clone, Debug, Deserialize, Serialize)]
#[serde(untagged, rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsSepaDebitUnion {
    PaymentIntentPaymentMethodOptionsSepaDebit(PaymentIntentPaymentMethodOptionsSepaDebit),
    #[serde(rename = "PaymentIntentTypeSpecificPaymentMethodOptionsClient")]
    PaymentIntentTypeSpecificPaymentMethodOptionsClient(
        PaymentIntentTypeSpecificPaymentMethodOptionsClient,
    ),
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsSepaDebitUnion {
    fn default() -> Self {
        Self::PaymentIntentPaymentMethodOptionsSepaDebit(Default::default())
    }
}

#[derive(Clone, Debug, Deserialize, Serialize)]
#[serde(untagged, rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsSofortUnion {
    PaymentMethodOptionsSofort(PaymentMethodOptionsSofort),
    #[serde(rename = "PaymentIntentTypeSpecificPaymentMethodOptionsClient")]
    PaymentIntentTypeSpecificPaymentMethodOptionsClient(
        PaymentIntentTypeSpecificPaymentMethodOptionsClient,
    ),
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsSofortUnion {
    fn default() -> Self {
        Self::PaymentMethodOptionsSofort(Default::default())
    }
}

#[derive(Clone, Debug, Deserialize, Serialize)]
#[serde(untagged, rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsWechatPayUnion {
    PaymentMethodOptionsWechatPay(PaymentMethodOptionsWechatPay),
    #[serde(rename = "PaymentIntentTypeSpecificPaymentMethodOptionsClient")]
    PaymentIntentTypeSpecificPaymentMethodOptionsClient(
        PaymentIntentTypeSpecificPaymentMethodOptionsClient,
    ),
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsWechatPayUnion {
    fn default() -> Self {
        Self::PaymentMethodOptionsWechatPay(Default::default())
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentMandateDataCustomerAcceptance`'s `type` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentMandateDataCustomerAcceptanceType {
    Offline,
    Online,
}

impl CreatePaymentIntentMandateDataCustomerAcceptanceType {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentMandateDataCustomerAcceptanceType::Offline => "offline",
            CreatePaymentIntentMandateDataCustomerAcceptanceType::Online => "online",
        }
    }
}

impl AsRef<str> for CreatePaymentIntentMandateDataCustomerAcceptanceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentMandateDataCustomerAcceptanceType {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentMandateDataCustomerAcceptanceType {
    fn default() -> Self {
        Self::Offline
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodDataEps`'s `bank` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodDataEpsBank {
    ArzteUndApothekerBank,
    AustrianAnadiBankAg,
    BankAustria,
    BankhausCarlSpangler,
    BankhausSchelhammerUndSchatteraAg,
    BawagPskAg,
    BksBankAg,
    BrullKallmusBankAg,
    BtvVierLanderBank,
    CapitalBankGraweGruppeAg,
    Dolomitenbank,
    EasybankAg,
    ErsteBankUndSparkassen,
    HypoAlpeadriabankInternationalAg,
    HypoBankBurgenlandAktiengesellschaft,
    HypoNoeLbFurNiederosterreichUWien,
    HypoOberosterreichSalzburgSteiermark,
    HypoTirolBankAg,
    HypoVorarlbergBankAg,
    MarchfelderBank,
    OberbankAg,
    RaiffeisenBankengruppeOsterreich,
    SchoellerbankAg,
    SpardaBankWien,
    VolksbankGruppe,
    VolkskreditbankAg,
    VrBankBraunau,
}

impl CreatePaymentIntentPaymentMethodDataEpsBank {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodDataEpsBank::ArzteUndApothekerBank => {
                "arzte_und_apotheker_bank"
            }
            CreatePaymentIntentPaymentMethodDataEpsBank::AustrianAnadiBankAg => {
                "austrian_anadi_bank_ag"
            }
            CreatePaymentIntentPaymentMethodDataEpsBank::BankAustria => "bank_austria",
            CreatePaymentIntentPaymentMethodDataEpsBank::BankhausCarlSpangler => {
                "bankhaus_carl_spangler"
            }
            CreatePaymentIntentPaymentMethodDataEpsBank::BankhausSchelhammerUndSchatteraAg => {
                "bankhaus_schelhammer_und_schattera_ag"
            }
            CreatePaymentIntentPaymentMethodDataEpsBank::BawagPskAg => "bawag_psk_ag",
            CreatePaymentIntentPaymentMethodDataEpsBank::BksBankAg => "bks_bank_ag",
            CreatePaymentIntentPaymentMethodDataEpsBank::BrullKallmusBankAg => {
                "brull_kallmus_bank_ag"
            }
            CreatePaymentIntentPaymentMethodDataEpsBank::BtvVierLanderBank => {
                "btv_vier_lander_bank"
            }
            CreatePaymentIntentPaymentMethodDataEpsBank::CapitalBankGraweGruppeAg => {
                "capital_bank_grawe_gruppe_ag"
            }
            CreatePaymentIntentPaymentMethodDataEpsBank::Dolomitenbank => "dolomitenbank",
            CreatePaymentIntentPaymentMethodDataEpsBank::EasybankAg => "easybank_ag",
            CreatePaymentIntentPaymentMethodDataEpsBank::ErsteBankUndSparkassen => {
                "erste_bank_und_sparkassen"
            }
            CreatePaymentIntentPaymentMethodDataEpsBank::HypoAlpeadriabankInternationalAg => {
                "hypo_alpeadriabank_international_ag"
            }
            CreatePaymentIntentPaymentMethodDataEpsBank::HypoBankBurgenlandAktiengesellschaft => {
                "hypo_bank_burgenland_aktiengesellschaft"
            }
            CreatePaymentIntentPaymentMethodDataEpsBank::HypoNoeLbFurNiederosterreichUWien => {
                "hypo_noe_lb_fur_niederosterreich_u_wien"
            }
            CreatePaymentIntentPaymentMethodDataEpsBank::HypoOberosterreichSalzburgSteiermark => {
                "hypo_oberosterreich_salzburg_steiermark"
            }
            CreatePaymentIntentPaymentMethodDataEpsBank::HypoTirolBankAg => "hypo_tirol_bank_ag",
            CreatePaymentIntentPaymentMethodDataEpsBank::HypoVorarlbergBankAg => {
                "hypo_vorarlberg_bank_ag"
            }
            CreatePaymentIntentPaymentMethodDataEpsBank::MarchfelderBank => "marchfelder_bank",
            CreatePaymentIntentPaymentMethodDataEpsBank::OberbankAg => "oberbank_ag",
            CreatePaymentIntentPaymentMethodDataEpsBank::RaiffeisenBankengruppeOsterreich => {
                "raiffeisen_bankengruppe_osterreich"
            }
            CreatePaymentIntentPaymentMethodDataEpsBank::SchoellerbankAg => "schoellerbank_ag",
            CreatePaymentIntentPaymentMethodDataEpsBank::SpardaBankWien => "sparda_bank_wien",
            CreatePaymentIntentPaymentMethodDataEpsBank::VolksbankGruppe => "volksbank_gruppe",
            CreatePaymentIntentPaymentMethodDataEpsBank::VolkskreditbankAg => "volkskreditbank_ag",
            CreatePaymentIntentPaymentMethodDataEpsBank::VrBankBraunau => "vr_bank_braunau",
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodDataEpsBank {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodDataEpsBank {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodDataEpsBank {
    fn default() -> Self {
        Self::ArzteUndApothekerBank
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodDataFpx`'s `bank` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodDataFpxBank {
    AffinBank,
    Agrobank,
    AllianceBank,
    Ambank,
    BankIslam,
    BankMuamalat,
    BankRakyat,
    Bsn,
    Cimb,
    DeutscheBank,
    HongLeongBank,
    Hsbc,
    Kfh,
    Maybank2e,
    Maybank2u,
    Ocbc,
    PbEnterprise,
    PublicBank,
    Rhb,
    StandardChartered,
    Uob,
}

impl CreatePaymentIntentPaymentMethodDataFpxBank {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodDataFpxBank::AffinBank => "affin_bank",
            CreatePaymentIntentPaymentMethodDataFpxBank::Agrobank => "agrobank",
            CreatePaymentIntentPaymentMethodDataFpxBank::AllianceBank => "alliance_bank",
            CreatePaymentIntentPaymentMethodDataFpxBank::Ambank => "ambank",
            CreatePaymentIntentPaymentMethodDataFpxBank::BankIslam => "bank_islam",
            CreatePaymentIntentPaymentMethodDataFpxBank::BankMuamalat => "bank_muamalat",
            CreatePaymentIntentPaymentMethodDataFpxBank::BankRakyat => "bank_rakyat",
            CreatePaymentIntentPaymentMethodDataFpxBank::Bsn => "bsn",
            CreatePaymentIntentPaymentMethodDataFpxBank::Cimb => "cimb",
            CreatePaymentIntentPaymentMethodDataFpxBank::DeutscheBank => "deutsche_bank",
            CreatePaymentIntentPaymentMethodDataFpxBank::HongLeongBank => "hong_leong_bank",
            CreatePaymentIntentPaymentMethodDataFpxBank::Hsbc => "hsbc",
            CreatePaymentIntentPaymentMethodDataFpxBank::Kfh => "kfh",
            CreatePaymentIntentPaymentMethodDataFpxBank::Maybank2e => "maybank2e",
            CreatePaymentIntentPaymentMethodDataFpxBank::Maybank2u => "maybank2u",
            CreatePaymentIntentPaymentMethodDataFpxBank::Ocbc => "ocbc",
            CreatePaymentIntentPaymentMethodDataFpxBank::PbEnterprise => "pb_enterprise",
            CreatePaymentIntentPaymentMethodDataFpxBank::PublicBank => "public_bank",
            CreatePaymentIntentPaymentMethodDataFpxBank::Rhb => "rhb",
            CreatePaymentIntentPaymentMethodDataFpxBank::StandardChartered => "standard_chartered",
            CreatePaymentIntentPaymentMethodDataFpxBank::Uob => "uob",
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodDataFpxBank {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodDataFpxBank {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodDataFpxBank {
    fn default() -> Self {
        Self::AffinBank
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodDataIdeal`'s `bank` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodDataIdealBank {
    AbnAmro,
    AsnBank,
    Bunq,
    Handelsbanken,
    Ing,
    Knab,
    Moneyou,
    Rabobank,
    Regiobank,
    Revolut,
    SnsBank,
    TriodosBank,
    VanLanschot,
}

impl CreatePaymentIntentPaymentMethodDataIdealBank {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodDataIdealBank::AbnAmro => "abn_amro",
            CreatePaymentIntentPaymentMethodDataIdealBank::AsnBank => "asn_bank",
            CreatePaymentIntentPaymentMethodDataIdealBank::Bunq => "bunq",
            CreatePaymentIntentPaymentMethodDataIdealBank::Handelsbanken => "handelsbanken",
            CreatePaymentIntentPaymentMethodDataIdealBank::Ing => "ing",
            CreatePaymentIntentPaymentMethodDataIdealBank::Knab => "knab",
            CreatePaymentIntentPaymentMethodDataIdealBank::Moneyou => "moneyou",
            CreatePaymentIntentPaymentMethodDataIdealBank::Rabobank => "rabobank",
            CreatePaymentIntentPaymentMethodDataIdealBank::Regiobank => "regiobank",
            CreatePaymentIntentPaymentMethodDataIdealBank::Revolut => "revolut",
            CreatePaymentIntentPaymentMethodDataIdealBank::SnsBank => "sns_bank",
            CreatePaymentIntentPaymentMethodDataIdealBank::TriodosBank => "triodos_bank",
            CreatePaymentIntentPaymentMethodDataIdealBank::VanLanschot => "van_lanschot",
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodDataIdealBank {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodDataIdealBank {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodDataIdealBank {
    fn default() -> Self {
        Self::AbnAmro
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodDataP24`'s `bank` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodDataP24Bank {
    AliorBank,
    BankMillennium,
    BankNowyBfgSa,
    BankPekaoSa,
    BankiSpbdzielcze,
    Blik,
    BnpParibas,
    Boz,
    CitiHandlowy,
    CreditAgricole,
    Envelobank,
    EtransferPocztowy24,
    GetinBank,
    Ideabank,
    Ing,
    Inteligo,
    MbankMtransfer,
    NestPrzelew,
    NoblePay,
    PbacZIpko,
    PlusBank,
    SantanderPrzelew24,
    TmobileUsbugiBankowe,
    ToyotaBank,
    VolkswagenBank,
}

impl CreatePaymentIntentPaymentMethodDataP24Bank {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodDataP24Bank::AliorBank => "alior_bank",
            CreatePaymentIntentPaymentMethodDataP24Bank::BankMillennium => "bank_millennium",
            CreatePaymentIntentPaymentMethodDataP24Bank::BankNowyBfgSa => "bank_nowy_bfg_sa",
            CreatePaymentIntentPaymentMethodDataP24Bank::BankPekaoSa => "bank_pekao_sa",
            CreatePaymentIntentPaymentMethodDataP24Bank::BankiSpbdzielcze => "banki_spbdzielcze",
            CreatePaymentIntentPaymentMethodDataP24Bank::Blik => "blik",
            CreatePaymentIntentPaymentMethodDataP24Bank::BnpParibas => "bnp_paribas",
            CreatePaymentIntentPaymentMethodDataP24Bank::Boz => "boz",
            CreatePaymentIntentPaymentMethodDataP24Bank::CitiHandlowy => "citi_handlowy",
            CreatePaymentIntentPaymentMethodDataP24Bank::CreditAgricole => "credit_agricole",
            CreatePaymentIntentPaymentMethodDataP24Bank::Envelobank => "envelobank",
            CreatePaymentIntentPaymentMethodDataP24Bank::EtransferPocztowy24 => {
                "etransfer_pocztowy24"
            }
            CreatePaymentIntentPaymentMethodDataP24Bank::GetinBank => "getin_bank",
            CreatePaymentIntentPaymentMethodDataP24Bank::Ideabank => "ideabank",
            CreatePaymentIntentPaymentMethodDataP24Bank::Ing => "ing",
            CreatePaymentIntentPaymentMethodDataP24Bank::Inteligo => "inteligo",
            CreatePaymentIntentPaymentMethodDataP24Bank::MbankMtransfer => "mbank_mtransfer",
            CreatePaymentIntentPaymentMethodDataP24Bank::NestPrzelew => "nest_przelew",
            CreatePaymentIntentPaymentMethodDataP24Bank::NoblePay => "noble_pay",
            CreatePaymentIntentPaymentMethodDataP24Bank::PbacZIpko => "pbac_z_ipko",
            CreatePaymentIntentPaymentMethodDataP24Bank::PlusBank => "plus_bank",
            CreatePaymentIntentPaymentMethodDataP24Bank::SantanderPrzelew24 => {
                "santander_przelew24"
            }
            CreatePaymentIntentPaymentMethodDataP24Bank::TmobileUsbugiBankowe => {
                "tmobile_usbugi_bankowe"
            }
            CreatePaymentIntentPaymentMethodDataP24Bank::ToyotaBank => "toyota_bank",
            CreatePaymentIntentPaymentMethodDataP24Bank::VolkswagenBank => "volkswagen_bank",
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodDataP24Bank {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodDataP24Bank {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodDataP24Bank {
    fn default() -> Self {
        Self::AliorBank
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodDataSofort`'s `country` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodDataSofortCountry {
    #[serde(rename = "AT")]
    At,
    #[serde(rename = "BE")]
    Be,
    #[serde(rename = "DE")]
    De,
    #[serde(rename = "ES")]
    Es,
    #[serde(rename = "IT")]
    It,
    #[serde(rename = "NL")]
    Nl,
}

impl CreatePaymentIntentPaymentMethodDataSofortCountry {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodDataSofortCountry::At => "AT",
            CreatePaymentIntentPaymentMethodDataSofortCountry::Be => "BE",
            CreatePaymentIntentPaymentMethodDataSofortCountry::De => "DE",
            CreatePaymentIntentPaymentMethodDataSofortCountry::Es => "ES",
            CreatePaymentIntentPaymentMethodDataSofortCountry::It => "IT",
            CreatePaymentIntentPaymentMethodDataSofortCountry::Nl => "NL",
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodDataSofortCountry {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodDataSofortCountry {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodDataSofortCountry {
    fn default() -> Self {
        Self::At
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodData`'s `type` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodDataType {
    AcssDebit,
    AfterpayClearpay,
    Alipay,
    AuBecsDebit,
    BacsDebit,
    Bancontact,
    Boleto,
    Eps,
    Fpx,
    Giropay,
    Grabpay,
    Ideal,
    Klarna,
    Konbini,
    Oxxo,
    P24,
    SepaDebit,
    Sofort,
    WechatPay,
}

impl CreatePaymentIntentPaymentMethodDataType {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodDataType::AcssDebit => "acss_debit",
            CreatePaymentIntentPaymentMethodDataType::AfterpayClearpay => "afterpay_clearpay",
            CreatePaymentIntentPaymentMethodDataType::Alipay => "alipay",
            CreatePaymentIntentPaymentMethodDataType::AuBecsDebit => "au_becs_debit",
            CreatePaymentIntentPaymentMethodDataType::BacsDebit => "bacs_debit",
            CreatePaymentIntentPaymentMethodDataType::Bancontact => "bancontact",
            CreatePaymentIntentPaymentMethodDataType::Boleto => "boleto",
            CreatePaymentIntentPaymentMethodDataType::Eps => "eps",
            CreatePaymentIntentPaymentMethodDataType::Fpx => "fpx",
            CreatePaymentIntentPaymentMethodDataType::Giropay => "giropay",
            CreatePaymentIntentPaymentMethodDataType::Grabpay => "grabpay",
            CreatePaymentIntentPaymentMethodDataType::Ideal => "ideal",
            CreatePaymentIntentPaymentMethodDataType::Klarna => "klarna",
            CreatePaymentIntentPaymentMethodDataType::Konbini => "konbini",
            CreatePaymentIntentPaymentMethodDataType::Oxxo => "oxxo",
            CreatePaymentIntentPaymentMethodDataType::P24 => "p24",
            CreatePaymentIntentPaymentMethodDataType::SepaDebit => "sepa_debit",
            CreatePaymentIntentPaymentMethodDataType::Sofort => "sofort",
            CreatePaymentIntentPaymentMethodDataType::WechatPay => "wechat_pay",
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodDataType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodDataType {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodDataType {
    fn default() -> Self {
        Self::AcssDebit
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptions`'s `payment_schedule` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsPaymentSchedule {
    Combined,
    Interval,
    Sporadic,
}

impl CreatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsPaymentSchedule {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsPaymentSchedule::Combined => "combined",
            CreatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsPaymentSchedule::Interval => "interval",
            CreatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsPaymentSchedule::Sporadic => "sporadic",
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsPaymentSchedule {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display
    for CreatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsPaymentSchedule
{
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default
    for CreatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsPaymentSchedule
{
    fn default() -> Self {
        Self::Combined
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptions`'s `transaction_type` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsTransactionType {
    Business,
    Personal,
}

impl CreatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsTransactionType {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsTransactionType::Business => "business",
            CreatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsTransactionType::Personal => "personal",
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsTransactionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display
    for CreatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsTransactionType
{
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default
    for CreatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsTransactionType
{
    fn default() -> Self {
        Self::Business
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsAcssDebit`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsAcssDebitSetupFutureUsage {
    None,
    OffSession,
    OnSession,
}

impl CreatePaymentIntentPaymentMethodOptionsAcssDebitSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsAcssDebitSetupFutureUsage::None => "none",
            CreatePaymentIntentPaymentMethodOptionsAcssDebitSetupFutureUsage::OffSession => {
                "off_session"
            }
            CreatePaymentIntentPaymentMethodOptionsAcssDebitSetupFutureUsage::OnSession => {
                "on_session"
            }
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsAcssDebitSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsAcssDebitSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsAcssDebitSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsAcssDebit`'s `verification_method` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsAcssDebitVerificationMethod {
    Automatic,
    Instant,
    Microdeposits,
}

impl CreatePaymentIntentPaymentMethodOptionsAcssDebitVerificationMethod {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsAcssDebitVerificationMethod::Automatic => {
                "automatic"
            }
            CreatePaymentIntentPaymentMethodOptionsAcssDebitVerificationMethod::Instant => {
                "instant"
            }
            CreatePaymentIntentPaymentMethodOptionsAcssDebitVerificationMethod::Microdeposits => {
                "microdeposits"
            }
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsAcssDebitVerificationMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsAcssDebitVerificationMethod {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsAcssDebitVerificationMethod {
    fn default() -> Self {
        Self::Automatic
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsAfterpayClearpay`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsAfterpayClearpaySetupFutureUsage {
    None,
}

impl CreatePaymentIntentPaymentMethodOptionsAfterpayClearpaySetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsAfterpayClearpaySetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsAfterpayClearpaySetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsAfterpayClearpaySetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default
    for CreatePaymentIntentPaymentMethodOptionsAfterpayClearpaySetupFutureUsage
{
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsAlipay`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsAlipaySetupFutureUsage {
    None,
    OffSession,
}

impl CreatePaymentIntentPaymentMethodOptionsAlipaySetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsAlipaySetupFutureUsage::None => "none",
            CreatePaymentIntentPaymentMethodOptionsAlipaySetupFutureUsage::OffSession => {
                "off_session"
            }
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsAlipaySetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsAlipaySetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsAlipaySetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsAuBecsDebit`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsAuBecsDebitSetupFutureUsage {
    None,
    OffSession,
    OnSession,
}

impl CreatePaymentIntentPaymentMethodOptionsAuBecsDebitSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsAuBecsDebitSetupFutureUsage::None => "none",
            CreatePaymentIntentPaymentMethodOptionsAuBecsDebitSetupFutureUsage::OffSession => {
                "off_session"
            }
            CreatePaymentIntentPaymentMethodOptionsAuBecsDebitSetupFutureUsage::OnSession => {
                "on_session"
            }
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsAuBecsDebitSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsAuBecsDebitSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsAuBecsDebitSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsBacsDebit`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsBacsDebitSetupFutureUsage {
    None,
    OffSession,
    OnSession,
}

impl CreatePaymentIntentPaymentMethodOptionsBacsDebitSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsBacsDebitSetupFutureUsage::None => "none",
            CreatePaymentIntentPaymentMethodOptionsBacsDebitSetupFutureUsage::OffSession => {
                "off_session"
            }
            CreatePaymentIntentPaymentMethodOptionsBacsDebitSetupFutureUsage::OnSession => {
                "on_session"
            }
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsBacsDebitSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsBacsDebitSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsBacsDebitSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsBancontact`'s `preferred_language` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsBancontactPreferredLanguage {
    De,
    En,
    Fr,
    Nl,
}

impl CreatePaymentIntentPaymentMethodOptionsBancontactPreferredLanguage {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsBancontactPreferredLanguage::De => "de",
            CreatePaymentIntentPaymentMethodOptionsBancontactPreferredLanguage::En => "en",
            CreatePaymentIntentPaymentMethodOptionsBancontactPreferredLanguage::Fr => "fr",
            CreatePaymentIntentPaymentMethodOptionsBancontactPreferredLanguage::Nl => "nl",
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsBancontactPreferredLanguage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsBancontactPreferredLanguage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsBancontactPreferredLanguage {
    fn default() -> Self {
        Self::De
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsBancontact`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsBancontactSetupFutureUsage {
    None,
    OffSession,
}

impl CreatePaymentIntentPaymentMethodOptionsBancontactSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsBancontactSetupFutureUsage::None => "none",
            CreatePaymentIntentPaymentMethodOptionsBancontactSetupFutureUsage::OffSession => {
                "off_session"
            }
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsBancontactSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsBancontactSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsBancontactSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsBoleto`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsBoletoSetupFutureUsage {
    None,
    OffSession,
    OnSession,
}

impl CreatePaymentIntentPaymentMethodOptionsBoletoSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsBoletoSetupFutureUsage::None => "none",
            CreatePaymentIntentPaymentMethodOptionsBoletoSetupFutureUsage::OffSession => {
                "off_session"
            }
            CreatePaymentIntentPaymentMethodOptionsBoletoSetupFutureUsage::OnSession => {
                "on_session"
            }
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsBoletoSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsBoletoSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsBoletoSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsCardInstallmentsPlan`'s `interval` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsCardInstallmentsPlanInterval {
    Month,
}

impl CreatePaymentIntentPaymentMethodOptionsCardInstallmentsPlanInterval {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsCardInstallmentsPlanInterval::Month => "month",
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsCardInstallmentsPlanInterval {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsCardInstallmentsPlanInterval {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsCardInstallmentsPlanInterval {
    fn default() -> Self {
        Self::Month
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsCardInstallmentsPlan`'s `type` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsCardInstallmentsPlanType {
    FixedCount,
}

impl CreatePaymentIntentPaymentMethodOptionsCardInstallmentsPlanType {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsCardInstallmentsPlanType::FixedCount => {
                "fixed_count"
            }
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsCardInstallmentsPlanType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsCardInstallmentsPlanType {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsCardInstallmentsPlanType {
    fn default() -> Self {
        Self::FixedCount
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsCardMandateOptions`'s `amount_type` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsCardMandateOptionsAmountType {
    Fixed,
    Maximum,
}

impl CreatePaymentIntentPaymentMethodOptionsCardMandateOptionsAmountType {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsCardMandateOptionsAmountType::Fixed => "fixed",
            CreatePaymentIntentPaymentMethodOptionsCardMandateOptionsAmountType::Maximum => {
                "maximum"
            }
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsCardMandateOptionsAmountType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsCardMandateOptionsAmountType {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsCardMandateOptionsAmountType {
    fn default() -> Self {
        Self::Fixed
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsCardMandateOptions`'s `interval` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsCardMandateOptionsInterval {
    Day,
    Month,
    Sporadic,
    Week,
    Year,
}

impl CreatePaymentIntentPaymentMethodOptionsCardMandateOptionsInterval {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsCardMandateOptionsInterval::Day => "day",
            CreatePaymentIntentPaymentMethodOptionsCardMandateOptionsInterval::Month => "month",
            CreatePaymentIntentPaymentMethodOptionsCardMandateOptionsInterval::Sporadic => {
                "sporadic"
            }
            CreatePaymentIntentPaymentMethodOptionsCardMandateOptionsInterval::Week => "week",
            CreatePaymentIntentPaymentMethodOptionsCardMandateOptionsInterval::Year => "year",
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsCardMandateOptionsInterval {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsCardMandateOptionsInterval {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsCardMandateOptionsInterval {
    fn default() -> Self {
        Self::Day
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsCardMandateOptions`'s `supported_types` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsCardMandateOptionsSupportedTypes {
    India,
}

impl CreatePaymentIntentPaymentMethodOptionsCardMandateOptionsSupportedTypes {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsCardMandateOptionsSupportedTypes::India => {
                "india"
            }
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsCardMandateOptionsSupportedTypes {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsCardMandateOptionsSupportedTypes {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default
    for CreatePaymentIntentPaymentMethodOptionsCardMandateOptionsSupportedTypes
{
    fn default() -> Self {
        Self::India
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsCard`'s `network` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsCardNetwork {
    Amex,
    CartesBancaires,
    Diners,
    Discover,
    Interac,
    Jcb,
    Mastercard,
    Unionpay,
    Unknown,
    Visa,
}

impl CreatePaymentIntentPaymentMethodOptionsCardNetwork {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsCardNetwork::Amex => "amex",
            CreatePaymentIntentPaymentMethodOptionsCardNetwork::CartesBancaires => {
                "cartes_bancaires"
            }
            CreatePaymentIntentPaymentMethodOptionsCardNetwork::Diners => "diners",
            CreatePaymentIntentPaymentMethodOptionsCardNetwork::Discover => "discover",
            CreatePaymentIntentPaymentMethodOptionsCardNetwork::Interac => "interac",
            CreatePaymentIntentPaymentMethodOptionsCardNetwork::Jcb => "jcb",
            CreatePaymentIntentPaymentMethodOptionsCardNetwork::Mastercard => "mastercard",
            CreatePaymentIntentPaymentMethodOptionsCardNetwork::Unionpay => "unionpay",
            CreatePaymentIntentPaymentMethodOptionsCardNetwork::Unknown => "unknown",
            CreatePaymentIntentPaymentMethodOptionsCardNetwork::Visa => "visa",
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsCardNetwork {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsCardNetwork {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsCardNetwork {
    fn default() -> Self {
        Self::Amex
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsCard`'s `request_three_d_secure` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsCardRequestThreeDSecure {
    Any,
    Automatic,
}

impl CreatePaymentIntentPaymentMethodOptionsCardRequestThreeDSecure {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsCardRequestThreeDSecure::Any => "any",
            CreatePaymentIntentPaymentMethodOptionsCardRequestThreeDSecure::Automatic => {
                "automatic"
            }
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsCardRequestThreeDSecure {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsCardRequestThreeDSecure {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsCardRequestThreeDSecure {
    fn default() -> Self {
        Self::Any
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsCard`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsCardSetupFutureUsage {
    None,
    OffSession,
    OnSession,
}

impl CreatePaymentIntentPaymentMethodOptionsCardSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsCardSetupFutureUsage::None => "none",
            CreatePaymentIntentPaymentMethodOptionsCardSetupFutureUsage::OffSession => {
                "off_session"
            }
            CreatePaymentIntentPaymentMethodOptionsCardSetupFutureUsage::OnSession => "on_session",
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsCardSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsCardSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsCardSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsEps`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsEpsSetupFutureUsage {
    None,
}

impl CreatePaymentIntentPaymentMethodOptionsEpsSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsEpsSetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsEpsSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsEpsSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsEpsSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsFpx`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsFpxSetupFutureUsage {
    None,
}

impl CreatePaymentIntentPaymentMethodOptionsFpxSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsFpxSetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsFpxSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsFpxSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsFpxSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsGiropay`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsGiropaySetupFutureUsage {
    None,
}

impl CreatePaymentIntentPaymentMethodOptionsGiropaySetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsGiropaySetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsGiropaySetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsGiropaySetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsGiropaySetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsGrabpay`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsGrabpaySetupFutureUsage {
    None,
}

impl CreatePaymentIntentPaymentMethodOptionsGrabpaySetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsGrabpaySetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsGrabpaySetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsGrabpaySetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsGrabpaySetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsIdeal`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsIdealSetupFutureUsage {
    None,
    OffSession,
}

impl CreatePaymentIntentPaymentMethodOptionsIdealSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsIdealSetupFutureUsage::None => "none",
            CreatePaymentIntentPaymentMethodOptionsIdealSetupFutureUsage::OffSession => {
                "off_session"
            }
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsIdealSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsIdealSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsIdealSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsKlarna`'s `preferred_locale` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale {
    #[serde(rename = "da-DK")]
    DaDk,
    #[serde(rename = "de-AT")]
    DeAt,
    #[serde(rename = "de-DE")]
    DeDe,
    #[serde(rename = "en-AT")]
    EnAt,
    #[serde(rename = "en-BE")]
    EnBe,
    #[serde(rename = "en-DE")]
    EnDe,
    #[serde(rename = "en-DK")]
    EnDk,
    #[serde(rename = "en-ES")]
    EnEs,
    #[serde(rename = "en-FI")]
    EnFi,
    #[serde(rename = "en-FR")]
    EnFr,
    #[serde(rename = "en-GB")]
    EnGb,
    #[serde(rename = "en-IE")]
    EnIe,
    #[serde(rename = "en-IT")]
    EnIt,
    #[serde(rename = "en-NL")]
    EnNl,
    #[serde(rename = "en-NO")]
    EnNo,
    #[serde(rename = "en-SE")]
    EnSe,
    #[serde(rename = "en-US")]
    EnUs,
    #[serde(rename = "es-ES")]
    EsEs,
    #[serde(rename = "es-US")]
    EsUs,
    #[serde(rename = "fi-FI")]
    FiFi,
    #[serde(rename = "fr-BE")]
    FrBe,
    #[serde(rename = "fr-FR")]
    FrFr,
    #[serde(rename = "it-IT")]
    ItIt,
    #[serde(rename = "nb-NO")]
    NbNo,
    #[serde(rename = "nl-BE")]
    NlBe,
    #[serde(rename = "nl-NL")]
    NlNl,
    #[serde(rename = "sv-FI")]
    SvFi,
    #[serde(rename = "sv-SE")]
    SvSe,
}

impl CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::DaDk => "da-DK",
            CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::DeAt => "de-AT",
            CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::DeDe => "de-DE",
            CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EnAt => "en-AT",
            CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EnBe => "en-BE",
            CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EnDe => "en-DE",
            CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EnDk => "en-DK",
            CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EnEs => "en-ES",
            CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EnFi => "en-FI",
            CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EnFr => "en-FR",
            CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EnGb => "en-GB",
            CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EnIe => "en-IE",
            CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EnIt => "en-IT",
            CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EnNl => "en-NL",
            CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EnNo => "en-NO",
            CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EnSe => "en-SE",
            CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EnUs => "en-US",
            CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EsEs => "es-ES",
            CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EsUs => "es-US",
            CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::FiFi => "fi-FI",
            CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::FrBe => "fr-BE",
            CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::FrFr => "fr-FR",
            CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::ItIt => "it-IT",
            CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::NbNo => "nb-NO",
            CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::NlBe => "nl-BE",
            CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::NlNl => "nl-NL",
            CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::SvFi => "sv-FI",
            CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::SvSe => "sv-SE",
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale {
    fn default() -> Self {
        Self::DaDk
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsKlarna`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsKlarnaSetupFutureUsage {
    None,
}

impl CreatePaymentIntentPaymentMethodOptionsKlarnaSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsKlarnaSetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsKlarnaSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsKlarnaSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsKlarnaSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsKonbini`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsKonbiniSetupFutureUsage {
    None,
}

impl CreatePaymentIntentPaymentMethodOptionsKonbiniSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsKonbiniSetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsKonbiniSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsKonbiniSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsKonbiniSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsOxxo`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsOxxoSetupFutureUsage {
    None,
}

impl CreatePaymentIntentPaymentMethodOptionsOxxoSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsOxxoSetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsOxxoSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsOxxoSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsOxxoSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsP24`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsP24SetupFutureUsage {
    None,
}

impl CreatePaymentIntentPaymentMethodOptionsP24SetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsP24SetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsP24SetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsP24SetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsP24SetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsSepaDebit`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsSepaDebitSetupFutureUsage {
    None,
    OffSession,
    OnSession,
}

impl CreatePaymentIntentPaymentMethodOptionsSepaDebitSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsSepaDebitSetupFutureUsage::None => "none",
            CreatePaymentIntentPaymentMethodOptionsSepaDebitSetupFutureUsage::OffSession => {
                "off_session"
            }
            CreatePaymentIntentPaymentMethodOptionsSepaDebitSetupFutureUsage::OnSession => {
                "on_session"
            }
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsSepaDebitSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsSepaDebitSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsSepaDebitSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsSofort`'s `preferred_language` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsSofortPreferredLanguage {
    De,
    En,
    Es,
    Fr,
    It,
    Nl,
    Pl,
}

impl CreatePaymentIntentPaymentMethodOptionsSofortPreferredLanguage {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsSofortPreferredLanguage::De => "de",
            CreatePaymentIntentPaymentMethodOptionsSofortPreferredLanguage::En => "en",
            CreatePaymentIntentPaymentMethodOptionsSofortPreferredLanguage::Es => "es",
            CreatePaymentIntentPaymentMethodOptionsSofortPreferredLanguage::Fr => "fr",
            CreatePaymentIntentPaymentMethodOptionsSofortPreferredLanguage::It => "it",
            CreatePaymentIntentPaymentMethodOptionsSofortPreferredLanguage::Nl => "nl",
            CreatePaymentIntentPaymentMethodOptionsSofortPreferredLanguage::Pl => "pl",
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsSofortPreferredLanguage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsSofortPreferredLanguage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsSofortPreferredLanguage {
    fn default() -> Self {
        Self::De
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsSofort`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsSofortSetupFutureUsage {
    None,
    OffSession,
}

impl CreatePaymentIntentPaymentMethodOptionsSofortSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsSofortSetupFutureUsage::None => "none",
            CreatePaymentIntentPaymentMethodOptionsSofortSetupFutureUsage::OffSession => {
                "off_session"
            }
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsSofortSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsSofortSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsSofortSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsWechatPay`'s `client` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsWechatPayClient {
    Android,
    Ios,
    Web,
}

impl CreatePaymentIntentPaymentMethodOptionsWechatPayClient {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsWechatPayClient::Android => "android",
            CreatePaymentIntentPaymentMethodOptionsWechatPayClient::Ios => "ios",
            CreatePaymentIntentPaymentMethodOptionsWechatPayClient::Web => "web",
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsWechatPayClient {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsWechatPayClient {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsWechatPayClient {
    fn default() -> Self {
        Self::Android
    }
}

/// An enum representing the possible values of an `CreatePaymentIntentPaymentMethodOptionsWechatPay`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum CreatePaymentIntentPaymentMethodOptionsWechatPaySetupFutureUsage {
    None,
}

impl CreatePaymentIntentPaymentMethodOptionsWechatPaySetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            CreatePaymentIntentPaymentMethodOptionsWechatPaySetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for CreatePaymentIntentPaymentMethodOptionsWechatPaySetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for CreatePaymentIntentPaymentMethodOptionsWechatPaySetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for CreatePaymentIntentPaymentMethodOptionsWechatPaySetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `PaymentIntent`'s `cancellation_reason` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentIntentCancellationReason {
    Abandoned,
    Automatic,
    Duplicate,
    FailedInvoice,
    Fraudulent,
    RequestedByCustomer,
    VoidInvoice,
}

impl PaymentIntentCancellationReason {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentIntentCancellationReason::Abandoned => "abandoned",
            PaymentIntentCancellationReason::Automatic => "automatic",
            PaymentIntentCancellationReason::Duplicate => "duplicate",
            PaymentIntentCancellationReason::FailedInvoice => "failed_invoice",
            PaymentIntentCancellationReason::Fraudulent => "fraudulent",
            PaymentIntentCancellationReason::RequestedByCustomer => "requested_by_customer",
            PaymentIntentCancellationReason::VoidInvoice => "void_invoice",
        }
    }
}

impl AsRef<str> for PaymentIntentCancellationReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentIntentCancellationReason {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentIntentCancellationReason {
    fn default() -> Self {
        Self::Abandoned
    }
}

/// An enum representing the possible values of an `PaymentIntent`'s `capture_method` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentIntentCaptureMethod {
    Automatic,
    Manual,
}

impl PaymentIntentCaptureMethod {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentIntentCaptureMethod::Automatic => "automatic",
            PaymentIntentCaptureMethod::Manual => "manual",
        }
    }
}

impl AsRef<str> for PaymentIntentCaptureMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentIntentCaptureMethod {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentIntentCaptureMethod {
    fn default() -> Self {
        Self::Automatic
    }
}

/// An enum representing the possible values of an `PaymentIntent`'s `confirmation_method` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentIntentConfirmationMethod {
    Automatic,
    Manual,
}

impl PaymentIntentConfirmationMethod {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentIntentConfirmationMethod::Automatic => "automatic",
            PaymentIntentConfirmationMethod::Manual => "manual",
        }
    }
}

impl AsRef<str> for PaymentIntentConfirmationMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentIntentConfirmationMethod {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentIntentConfirmationMethod {
    fn default() -> Self {
        Self::Automatic
    }
}

/// An enum representing the possible values of an `PaymentIntentPaymentMethodOptionsAcssDebit`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsAcssDebitSetupFutureUsage {
    None,
    OffSession,
    OnSession,
}

impl PaymentIntentPaymentMethodOptionsAcssDebitSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentIntentPaymentMethodOptionsAcssDebitSetupFutureUsage::None => "none",
            PaymentIntentPaymentMethodOptionsAcssDebitSetupFutureUsage::OffSession => "off_session",
            PaymentIntentPaymentMethodOptionsAcssDebitSetupFutureUsage::OnSession => "on_session",
        }
    }
}

impl AsRef<str> for PaymentIntentPaymentMethodOptionsAcssDebitSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentIntentPaymentMethodOptionsAcssDebitSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsAcssDebitSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `PaymentIntentPaymentMethodOptionsAcssDebit`'s `verification_method` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsAcssDebitVerificationMethod {
    Automatic,
    Instant,
    Microdeposits,
}

impl PaymentIntentPaymentMethodOptionsAcssDebitVerificationMethod {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentIntentPaymentMethodOptionsAcssDebitVerificationMethod::Automatic => "automatic",
            PaymentIntentPaymentMethodOptionsAcssDebitVerificationMethod::Instant => "instant",
            PaymentIntentPaymentMethodOptionsAcssDebitVerificationMethod::Microdeposits => {
                "microdeposits"
            }
        }
    }
}

impl AsRef<str> for PaymentIntentPaymentMethodOptionsAcssDebitVerificationMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentIntentPaymentMethodOptionsAcssDebitVerificationMethod {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsAcssDebitVerificationMethod {
    fn default() -> Self {
        Self::Automatic
    }
}

/// An enum representing the possible values of an `PaymentIntentPaymentMethodOptionsAuBecsDebit`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsAuBecsDebitSetupFutureUsage {
    None,
    OffSession,
    OnSession,
}

impl PaymentIntentPaymentMethodOptionsAuBecsDebitSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentIntentPaymentMethodOptionsAuBecsDebitSetupFutureUsage::None => "none",
            PaymentIntentPaymentMethodOptionsAuBecsDebitSetupFutureUsage::OffSession => {
                "off_session"
            }
            PaymentIntentPaymentMethodOptionsAuBecsDebitSetupFutureUsage::OnSession => "on_session",
        }
    }
}

impl AsRef<str> for PaymentIntentPaymentMethodOptionsAuBecsDebitSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentIntentPaymentMethodOptionsAuBecsDebitSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsAuBecsDebitSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `PaymentIntentPaymentMethodOptionsCard`'s `network` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsCardNetwork {
    Amex,
    CartesBancaires,
    Diners,
    Discover,
    Interac,
    Jcb,
    Mastercard,
    Unionpay,
    Unknown,
    Visa,
}

impl PaymentIntentPaymentMethodOptionsCardNetwork {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentIntentPaymentMethodOptionsCardNetwork::Amex => "amex",
            PaymentIntentPaymentMethodOptionsCardNetwork::CartesBancaires => "cartes_bancaires",
            PaymentIntentPaymentMethodOptionsCardNetwork::Diners => "diners",
            PaymentIntentPaymentMethodOptionsCardNetwork::Discover => "discover",
            PaymentIntentPaymentMethodOptionsCardNetwork::Interac => "interac",
            PaymentIntentPaymentMethodOptionsCardNetwork::Jcb => "jcb",
            PaymentIntentPaymentMethodOptionsCardNetwork::Mastercard => "mastercard",
            PaymentIntentPaymentMethodOptionsCardNetwork::Unionpay => "unionpay",
            PaymentIntentPaymentMethodOptionsCardNetwork::Unknown => "unknown",
            PaymentIntentPaymentMethodOptionsCardNetwork::Visa => "visa",
        }
    }
}

impl AsRef<str> for PaymentIntentPaymentMethodOptionsCardNetwork {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentIntentPaymentMethodOptionsCardNetwork {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsCardNetwork {
    fn default() -> Self {
        Self::Amex
    }
}

/// An enum representing the possible values of an `PaymentIntentPaymentMethodOptionsCard`'s `request_three_d_secure` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsCardRequestThreeDSecure {
    Any,
    Automatic,
    ChallengeOnly,
}

impl PaymentIntentPaymentMethodOptionsCardRequestThreeDSecure {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentIntentPaymentMethodOptionsCardRequestThreeDSecure::Any => "any",
            PaymentIntentPaymentMethodOptionsCardRequestThreeDSecure::Automatic => "automatic",
            PaymentIntentPaymentMethodOptionsCardRequestThreeDSecure::ChallengeOnly => {
                "challenge_only"
            }
        }
    }
}

impl AsRef<str> for PaymentIntentPaymentMethodOptionsCardRequestThreeDSecure {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentIntentPaymentMethodOptionsCardRequestThreeDSecure {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsCardRequestThreeDSecure {
    fn default() -> Self {
        Self::Any
    }
}

/// An enum representing the possible values of an `PaymentIntentPaymentMethodOptionsCard`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsCardSetupFutureUsage {
    None,
    OffSession,
    OnSession,
}

impl PaymentIntentPaymentMethodOptionsCardSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentIntentPaymentMethodOptionsCardSetupFutureUsage::None => "none",
            PaymentIntentPaymentMethodOptionsCardSetupFutureUsage::OffSession => "off_session",
            PaymentIntentPaymentMethodOptionsCardSetupFutureUsage::OnSession => "on_session",
        }
    }
}

impl AsRef<str> for PaymentIntentPaymentMethodOptionsCardSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentIntentPaymentMethodOptionsCardSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsCardSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `PaymentIntentPaymentMethodOptionsEps`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsEpsSetupFutureUsage {
    None,
}

impl PaymentIntentPaymentMethodOptionsEpsSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentIntentPaymentMethodOptionsEpsSetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for PaymentIntentPaymentMethodOptionsEpsSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentIntentPaymentMethodOptionsEpsSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsEpsSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `PaymentIntentPaymentMethodOptionsMandateOptionsAcssDebit`'s `payment_schedule` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsMandateOptionsAcssDebitPaymentSchedule {
    Combined,
    Interval,
    Sporadic,
}

impl PaymentIntentPaymentMethodOptionsMandateOptionsAcssDebitPaymentSchedule {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentIntentPaymentMethodOptionsMandateOptionsAcssDebitPaymentSchedule::Combined => {
                "combined"
            }
            PaymentIntentPaymentMethodOptionsMandateOptionsAcssDebitPaymentSchedule::Interval => {
                "interval"
            }
            PaymentIntentPaymentMethodOptionsMandateOptionsAcssDebitPaymentSchedule::Sporadic => {
                "sporadic"
            }
        }
    }
}

impl AsRef<str> for PaymentIntentPaymentMethodOptionsMandateOptionsAcssDebitPaymentSchedule {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentIntentPaymentMethodOptionsMandateOptionsAcssDebitPaymentSchedule {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default
    for PaymentIntentPaymentMethodOptionsMandateOptionsAcssDebitPaymentSchedule
{
    fn default() -> Self {
        Self::Combined
    }
}

/// An enum representing the possible values of an `PaymentIntentPaymentMethodOptionsMandateOptionsAcssDebit`'s `transaction_type` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsMandateOptionsAcssDebitTransactionType {
    Business,
    Personal,
}

impl PaymentIntentPaymentMethodOptionsMandateOptionsAcssDebitTransactionType {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentIntentPaymentMethodOptionsMandateOptionsAcssDebitTransactionType::Business => {
                "business"
            }
            PaymentIntentPaymentMethodOptionsMandateOptionsAcssDebitTransactionType::Personal => {
                "personal"
            }
        }
    }
}

impl AsRef<str> for PaymentIntentPaymentMethodOptionsMandateOptionsAcssDebitTransactionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentIntentPaymentMethodOptionsMandateOptionsAcssDebitTransactionType {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default
    for PaymentIntentPaymentMethodOptionsMandateOptionsAcssDebitTransactionType
{
    fn default() -> Self {
        Self::Business
    }
}

/// An enum representing the possible values of an `PaymentIntentPaymentMethodOptionsSepaDebit`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentIntentPaymentMethodOptionsSepaDebitSetupFutureUsage {
    None,
    OffSession,
    OnSession,
}

impl PaymentIntentPaymentMethodOptionsSepaDebitSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentIntentPaymentMethodOptionsSepaDebitSetupFutureUsage::None => "none",
            PaymentIntentPaymentMethodOptionsSepaDebitSetupFutureUsage::OffSession => "off_session",
            PaymentIntentPaymentMethodOptionsSepaDebitSetupFutureUsage::OnSession => "on_session",
        }
    }
}

impl AsRef<str> for PaymentIntentPaymentMethodOptionsSepaDebitSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentIntentPaymentMethodOptionsSepaDebitSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentIntentPaymentMethodOptionsSepaDebitSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `PaymentIntentProcessing`'s `type` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentIntentProcessingType {
    Card,
}

impl PaymentIntentProcessingType {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentIntentProcessingType::Card => "card",
        }
    }
}

impl AsRef<str> for PaymentIntentProcessingType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentIntentProcessingType {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentIntentProcessingType {
    fn default() -> Self {
        Self::Card
    }
}

/// An enum representing the possible values of an `PaymentIntent`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentIntentSetupFutureUsage {
    OffSession,
    OnSession,
}

impl PaymentIntentSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentIntentSetupFutureUsage::OffSession => "off_session",
            PaymentIntentSetupFutureUsage::OnSession => "on_session",
        }
    }
}

impl AsRef<str> for PaymentIntentSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentIntentSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentIntentSetupFutureUsage {
    fn default() -> Self {
        Self::OffSession
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntent`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentIntentSetupFutureUsageFilter {
    OffSession,
    OnSession,
}

impl PaymentIntentSetupFutureUsageFilter {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentIntentSetupFutureUsageFilter::OffSession => "off_session",
            PaymentIntentSetupFutureUsageFilter::OnSession => "on_session",
        }
    }
}

impl AsRef<str> for PaymentIntentSetupFutureUsageFilter {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentIntentSetupFutureUsageFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentIntentSetupFutureUsageFilter {
    fn default() -> Self {
        Self::OffSession
    }
}

/// An enum representing the possible values of an `PaymentIntent`'s `status` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentIntentStatus {
    Canceled,
    Processing,
    RequiresAction,
    RequiresCapture,
    RequiresConfirmation,
    RequiresPaymentMethod,
    Succeeded,
}

impl PaymentIntentStatus {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentIntentStatus::Canceled => "canceled",
            PaymentIntentStatus::Processing => "processing",
            PaymentIntentStatus::RequiresAction => "requires_action",
            PaymentIntentStatus::RequiresCapture => "requires_capture",
            PaymentIntentStatus::RequiresConfirmation => "requires_confirmation",
            PaymentIntentStatus::RequiresPaymentMethod => "requires_payment_method",
            PaymentIntentStatus::Succeeded => "succeeded",
        }
    }
}

impl AsRef<str> for PaymentIntentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentIntentStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentIntentStatus {
    fn default() -> Self {
        Self::Canceled
    }
}

/// An enum representing the possible values of an `PaymentIntentTypeSpecificPaymentMethodOptionsClient`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentIntentTypeSpecificPaymentMethodOptionsClientSetupFutureUsage {
    None,
    OffSession,
    OnSession,
}

impl PaymentIntentTypeSpecificPaymentMethodOptionsClientSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentIntentTypeSpecificPaymentMethodOptionsClientSetupFutureUsage::None => "none",
            PaymentIntentTypeSpecificPaymentMethodOptionsClientSetupFutureUsage::OffSession => {
                "off_session"
            }
            PaymentIntentTypeSpecificPaymentMethodOptionsClientSetupFutureUsage::OnSession => {
                "on_session"
            }
        }
    }
}

impl AsRef<str> for PaymentIntentTypeSpecificPaymentMethodOptionsClientSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentIntentTypeSpecificPaymentMethodOptionsClientSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentIntentTypeSpecificPaymentMethodOptionsClientSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `PaymentMethodOptionsAfterpayClearpay`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentMethodOptionsAfterpayClearpaySetupFutureUsage {
    None,
}

impl PaymentMethodOptionsAfterpayClearpaySetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentMethodOptionsAfterpayClearpaySetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for PaymentMethodOptionsAfterpayClearpaySetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentMethodOptionsAfterpayClearpaySetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentMethodOptionsAfterpayClearpaySetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `PaymentMethodOptionsAlipay`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentMethodOptionsAlipaySetupFutureUsage {
    None,
    OffSession,
}

impl PaymentMethodOptionsAlipaySetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentMethodOptionsAlipaySetupFutureUsage::None => "none",
            PaymentMethodOptionsAlipaySetupFutureUsage::OffSession => "off_session",
        }
    }
}

impl AsRef<str> for PaymentMethodOptionsAlipaySetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentMethodOptionsAlipaySetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentMethodOptionsAlipaySetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `PaymentMethodOptionsBacsDebit`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentMethodOptionsBacsDebitSetupFutureUsage {
    None,
    OffSession,
    OnSession,
}

impl PaymentMethodOptionsBacsDebitSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentMethodOptionsBacsDebitSetupFutureUsage::None => "none",
            PaymentMethodOptionsBacsDebitSetupFutureUsage::OffSession => "off_session",
            PaymentMethodOptionsBacsDebitSetupFutureUsage::OnSession => "on_session",
        }
    }
}

impl AsRef<str> for PaymentMethodOptionsBacsDebitSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentMethodOptionsBacsDebitSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentMethodOptionsBacsDebitSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `PaymentMethodOptionsBancontact`'s `preferred_language` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentMethodOptionsBancontactPreferredLanguage {
    De,
    En,
    Fr,
    Nl,
}

impl PaymentMethodOptionsBancontactPreferredLanguage {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentMethodOptionsBancontactPreferredLanguage::De => "de",
            PaymentMethodOptionsBancontactPreferredLanguage::En => "en",
            PaymentMethodOptionsBancontactPreferredLanguage::Fr => "fr",
            PaymentMethodOptionsBancontactPreferredLanguage::Nl => "nl",
        }
    }
}

impl AsRef<str> for PaymentMethodOptionsBancontactPreferredLanguage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentMethodOptionsBancontactPreferredLanguage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentMethodOptionsBancontactPreferredLanguage {
    fn default() -> Self {
        Self::De
    }
}

/// An enum representing the possible values of an `PaymentMethodOptionsBancontact`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentMethodOptionsBancontactSetupFutureUsage {
    None,
    OffSession,
}

impl PaymentMethodOptionsBancontactSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentMethodOptionsBancontactSetupFutureUsage::None => "none",
            PaymentMethodOptionsBancontactSetupFutureUsage::OffSession => "off_session",
        }
    }
}

impl AsRef<str> for PaymentMethodOptionsBancontactSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentMethodOptionsBancontactSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentMethodOptionsBancontactSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `PaymentMethodOptionsBoleto`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentMethodOptionsBoletoSetupFutureUsage {
    None,
    OffSession,
    OnSession,
}

impl PaymentMethodOptionsBoletoSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentMethodOptionsBoletoSetupFutureUsage::None => "none",
            PaymentMethodOptionsBoletoSetupFutureUsage::OffSession => "off_session",
            PaymentMethodOptionsBoletoSetupFutureUsage::OnSession => "on_session",
        }
    }
}

impl AsRef<str> for PaymentMethodOptionsBoletoSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentMethodOptionsBoletoSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentMethodOptionsBoletoSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `PaymentMethodOptionsCardMandateOptions`'s `amount_type` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentMethodOptionsCardMandateOptionsAmountType {
    Fixed,
    Maximum,
}

impl PaymentMethodOptionsCardMandateOptionsAmountType {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentMethodOptionsCardMandateOptionsAmountType::Fixed => "fixed",
            PaymentMethodOptionsCardMandateOptionsAmountType::Maximum => "maximum",
        }
    }
}

impl AsRef<str> for PaymentMethodOptionsCardMandateOptionsAmountType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentMethodOptionsCardMandateOptionsAmountType {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentMethodOptionsCardMandateOptionsAmountType {
    fn default() -> Self {
        Self::Fixed
    }
}

/// An enum representing the possible values of an `PaymentMethodOptionsCardMandateOptions`'s `interval` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentMethodOptionsCardMandateOptionsInterval {
    Day,
    Month,
    Sporadic,
    Week,
    Year,
}

impl PaymentMethodOptionsCardMandateOptionsInterval {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentMethodOptionsCardMandateOptionsInterval::Day => "day",
            PaymentMethodOptionsCardMandateOptionsInterval::Month => "month",
            PaymentMethodOptionsCardMandateOptionsInterval::Sporadic => "sporadic",
            PaymentMethodOptionsCardMandateOptionsInterval::Week => "week",
            PaymentMethodOptionsCardMandateOptionsInterval::Year => "year",
        }
    }
}

impl AsRef<str> for PaymentMethodOptionsCardMandateOptionsInterval {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentMethodOptionsCardMandateOptionsInterval {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentMethodOptionsCardMandateOptionsInterval {
    fn default() -> Self {
        Self::Day
    }
}

/// An enum representing the possible values of an `PaymentMethodOptionsCardMandateOptions`'s `supported_types` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentMethodOptionsCardMandateOptionsSupportedTypes {
    India,
}

impl PaymentMethodOptionsCardMandateOptionsSupportedTypes {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentMethodOptionsCardMandateOptionsSupportedTypes::India => "india",
        }
    }
}

impl AsRef<str> for PaymentMethodOptionsCardMandateOptionsSupportedTypes {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentMethodOptionsCardMandateOptionsSupportedTypes {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentMethodOptionsCardMandateOptionsSupportedTypes {
    fn default() -> Self {
        Self::India
    }
}

/// An enum representing the possible values of an `PaymentMethodOptionsFpx`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentMethodOptionsFpxSetupFutureUsage {
    None,
}

impl PaymentMethodOptionsFpxSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentMethodOptionsFpxSetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for PaymentMethodOptionsFpxSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentMethodOptionsFpxSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentMethodOptionsFpxSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `PaymentMethodOptionsGiropay`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentMethodOptionsGiropaySetupFutureUsage {
    None,
}

impl PaymentMethodOptionsGiropaySetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentMethodOptionsGiropaySetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for PaymentMethodOptionsGiropaySetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentMethodOptionsGiropaySetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentMethodOptionsGiropaySetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `PaymentMethodOptionsGrabpay`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentMethodOptionsGrabpaySetupFutureUsage {
    None,
}

impl PaymentMethodOptionsGrabpaySetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentMethodOptionsGrabpaySetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for PaymentMethodOptionsGrabpaySetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentMethodOptionsGrabpaySetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentMethodOptionsGrabpaySetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `PaymentMethodOptionsIdeal`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentMethodOptionsIdealSetupFutureUsage {
    None,
    OffSession,
}

impl PaymentMethodOptionsIdealSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentMethodOptionsIdealSetupFutureUsage::None => "none",
            PaymentMethodOptionsIdealSetupFutureUsage::OffSession => "off_session",
        }
    }
}

impl AsRef<str> for PaymentMethodOptionsIdealSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentMethodOptionsIdealSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentMethodOptionsIdealSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `PaymentMethodOptionsKlarna`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentMethodOptionsKlarnaSetupFutureUsage {
    None,
}

impl PaymentMethodOptionsKlarnaSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentMethodOptionsKlarnaSetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for PaymentMethodOptionsKlarnaSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentMethodOptionsKlarnaSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentMethodOptionsKlarnaSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `PaymentMethodOptionsKonbini`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentMethodOptionsKonbiniSetupFutureUsage {
    None,
}

impl PaymentMethodOptionsKonbiniSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentMethodOptionsKonbiniSetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for PaymentMethodOptionsKonbiniSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentMethodOptionsKonbiniSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentMethodOptionsKonbiniSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `PaymentMethodOptionsOxxo`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentMethodOptionsOxxoSetupFutureUsage {
    None,
}

impl PaymentMethodOptionsOxxoSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentMethodOptionsOxxoSetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for PaymentMethodOptionsOxxoSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentMethodOptionsOxxoSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentMethodOptionsOxxoSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `PaymentMethodOptionsP24`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentMethodOptionsP24SetupFutureUsage {
    None,
}

impl PaymentMethodOptionsP24SetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentMethodOptionsP24SetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for PaymentMethodOptionsP24SetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentMethodOptionsP24SetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentMethodOptionsP24SetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `PaymentMethodOptionsSofort`'s `preferred_language` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentMethodOptionsSofortPreferredLanguage {
    De,
    En,
    Es,
    Fr,
    It,
    Nl,
    Pl,
}

impl PaymentMethodOptionsSofortPreferredLanguage {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentMethodOptionsSofortPreferredLanguage::De => "de",
            PaymentMethodOptionsSofortPreferredLanguage::En => "en",
            PaymentMethodOptionsSofortPreferredLanguage::Es => "es",
            PaymentMethodOptionsSofortPreferredLanguage::Fr => "fr",
            PaymentMethodOptionsSofortPreferredLanguage::It => "it",
            PaymentMethodOptionsSofortPreferredLanguage::Nl => "nl",
            PaymentMethodOptionsSofortPreferredLanguage::Pl => "pl",
        }
    }
}

impl AsRef<str> for PaymentMethodOptionsSofortPreferredLanguage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentMethodOptionsSofortPreferredLanguage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentMethodOptionsSofortPreferredLanguage {
    fn default() -> Self {
        Self::De
    }
}

/// An enum representing the possible values of an `PaymentMethodOptionsSofort`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentMethodOptionsSofortSetupFutureUsage {
    None,
    OffSession,
}

impl PaymentMethodOptionsSofortSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentMethodOptionsSofortSetupFutureUsage::None => "none",
            PaymentMethodOptionsSofortSetupFutureUsage::OffSession => "off_session",
        }
    }
}

impl AsRef<str> for PaymentMethodOptionsSofortSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentMethodOptionsSofortSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentMethodOptionsSofortSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `PaymentMethodOptionsWechatPay`'s `client` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentMethodOptionsWechatPayClient {
    Android,
    Ios,
    Web,
}

impl PaymentMethodOptionsWechatPayClient {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentMethodOptionsWechatPayClient::Android => "android",
            PaymentMethodOptionsWechatPayClient::Ios => "ios",
            PaymentMethodOptionsWechatPayClient::Web => "web",
        }
    }
}

impl AsRef<str> for PaymentMethodOptionsWechatPayClient {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentMethodOptionsWechatPayClient {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentMethodOptionsWechatPayClient {
    fn default() -> Self {
        Self::Android
    }
}

/// An enum representing the possible values of an `PaymentMethodOptionsWechatPay`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum PaymentMethodOptionsWechatPaySetupFutureUsage {
    None,
}

impl PaymentMethodOptionsWechatPaySetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            PaymentMethodOptionsWechatPaySetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for PaymentMethodOptionsWechatPaySetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for PaymentMethodOptionsWechatPaySetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for PaymentMethodOptionsWechatPaySetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodDataEps`'s `bank` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodDataEpsBank {
    ArzteUndApothekerBank,
    AustrianAnadiBankAg,
    BankAustria,
    BankhausCarlSpangler,
    BankhausSchelhammerUndSchatteraAg,
    BawagPskAg,
    BksBankAg,
    BrullKallmusBankAg,
    BtvVierLanderBank,
    CapitalBankGraweGruppeAg,
    Dolomitenbank,
    EasybankAg,
    ErsteBankUndSparkassen,
    HypoAlpeadriabankInternationalAg,
    HypoBankBurgenlandAktiengesellschaft,
    HypoNoeLbFurNiederosterreichUWien,
    HypoOberosterreichSalzburgSteiermark,
    HypoTirolBankAg,
    HypoVorarlbergBankAg,
    MarchfelderBank,
    OberbankAg,
    RaiffeisenBankengruppeOsterreich,
    SchoellerbankAg,
    SpardaBankWien,
    VolksbankGruppe,
    VolkskreditbankAg,
    VrBankBraunau,
}

impl UpdatePaymentIntentPaymentMethodDataEpsBank {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodDataEpsBank::ArzteUndApothekerBank => {
                "arzte_und_apotheker_bank"
            }
            UpdatePaymentIntentPaymentMethodDataEpsBank::AustrianAnadiBankAg => {
                "austrian_anadi_bank_ag"
            }
            UpdatePaymentIntentPaymentMethodDataEpsBank::BankAustria => "bank_austria",
            UpdatePaymentIntentPaymentMethodDataEpsBank::BankhausCarlSpangler => {
                "bankhaus_carl_spangler"
            }
            UpdatePaymentIntentPaymentMethodDataEpsBank::BankhausSchelhammerUndSchatteraAg => {
                "bankhaus_schelhammer_und_schattera_ag"
            }
            UpdatePaymentIntentPaymentMethodDataEpsBank::BawagPskAg => "bawag_psk_ag",
            UpdatePaymentIntentPaymentMethodDataEpsBank::BksBankAg => "bks_bank_ag",
            UpdatePaymentIntentPaymentMethodDataEpsBank::BrullKallmusBankAg => {
                "brull_kallmus_bank_ag"
            }
            UpdatePaymentIntentPaymentMethodDataEpsBank::BtvVierLanderBank => {
                "btv_vier_lander_bank"
            }
            UpdatePaymentIntentPaymentMethodDataEpsBank::CapitalBankGraweGruppeAg => {
                "capital_bank_grawe_gruppe_ag"
            }
            UpdatePaymentIntentPaymentMethodDataEpsBank::Dolomitenbank => "dolomitenbank",
            UpdatePaymentIntentPaymentMethodDataEpsBank::EasybankAg => "easybank_ag",
            UpdatePaymentIntentPaymentMethodDataEpsBank::ErsteBankUndSparkassen => {
                "erste_bank_und_sparkassen"
            }
            UpdatePaymentIntentPaymentMethodDataEpsBank::HypoAlpeadriabankInternationalAg => {
                "hypo_alpeadriabank_international_ag"
            }
            UpdatePaymentIntentPaymentMethodDataEpsBank::HypoBankBurgenlandAktiengesellschaft => {
                "hypo_bank_burgenland_aktiengesellschaft"
            }
            UpdatePaymentIntentPaymentMethodDataEpsBank::HypoNoeLbFurNiederosterreichUWien => {
                "hypo_noe_lb_fur_niederosterreich_u_wien"
            }
            UpdatePaymentIntentPaymentMethodDataEpsBank::HypoOberosterreichSalzburgSteiermark => {
                "hypo_oberosterreich_salzburg_steiermark"
            }
            UpdatePaymentIntentPaymentMethodDataEpsBank::HypoTirolBankAg => "hypo_tirol_bank_ag",
            UpdatePaymentIntentPaymentMethodDataEpsBank::HypoVorarlbergBankAg => {
                "hypo_vorarlberg_bank_ag"
            }
            UpdatePaymentIntentPaymentMethodDataEpsBank::MarchfelderBank => "marchfelder_bank",
            UpdatePaymentIntentPaymentMethodDataEpsBank::OberbankAg => "oberbank_ag",
            UpdatePaymentIntentPaymentMethodDataEpsBank::RaiffeisenBankengruppeOsterreich => {
                "raiffeisen_bankengruppe_osterreich"
            }
            UpdatePaymentIntentPaymentMethodDataEpsBank::SchoellerbankAg => "schoellerbank_ag",
            UpdatePaymentIntentPaymentMethodDataEpsBank::SpardaBankWien => "sparda_bank_wien",
            UpdatePaymentIntentPaymentMethodDataEpsBank::VolksbankGruppe => "volksbank_gruppe",
            UpdatePaymentIntentPaymentMethodDataEpsBank::VolkskreditbankAg => "volkskreditbank_ag",
            UpdatePaymentIntentPaymentMethodDataEpsBank::VrBankBraunau => "vr_bank_braunau",
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodDataEpsBank {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodDataEpsBank {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodDataEpsBank {
    fn default() -> Self {
        Self::ArzteUndApothekerBank
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodDataFpx`'s `bank` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodDataFpxBank {
    AffinBank,
    Agrobank,
    AllianceBank,
    Ambank,
    BankIslam,
    BankMuamalat,
    BankRakyat,
    Bsn,
    Cimb,
    DeutscheBank,
    HongLeongBank,
    Hsbc,
    Kfh,
    Maybank2e,
    Maybank2u,
    Ocbc,
    PbEnterprise,
    PublicBank,
    Rhb,
    StandardChartered,
    Uob,
}

impl UpdatePaymentIntentPaymentMethodDataFpxBank {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodDataFpxBank::AffinBank => "affin_bank",
            UpdatePaymentIntentPaymentMethodDataFpxBank::Agrobank => "agrobank",
            UpdatePaymentIntentPaymentMethodDataFpxBank::AllianceBank => "alliance_bank",
            UpdatePaymentIntentPaymentMethodDataFpxBank::Ambank => "ambank",
            UpdatePaymentIntentPaymentMethodDataFpxBank::BankIslam => "bank_islam",
            UpdatePaymentIntentPaymentMethodDataFpxBank::BankMuamalat => "bank_muamalat",
            UpdatePaymentIntentPaymentMethodDataFpxBank::BankRakyat => "bank_rakyat",
            UpdatePaymentIntentPaymentMethodDataFpxBank::Bsn => "bsn",
            UpdatePaymentIntentPaymentMethodDataFpxBank::Cimb => "cimb",
            UpdatePaymentIntentPaymentMethodDataFpxBank::DeutscheBank => "deutsche_bank",
            UpdatePaymentIntentPaymentMethodDataFpxBank::HongLeongBank => "hong_leong_bank",
            UpdatePaymentIntentPaymentMethodDataFpxBank::Hsbc => "hsbc",
            UpdatePaymentIntentPaymentMethodDataFpxBank::Kfh => "kfh",
            UpdatePaymentIntentPaymentMethodDataFpxBank::Maybank2e => "maybank2e",
            UpdatePaymentIntentPaymentMethodDataFpxBank::Maybank2u => "maybank2u",
            UpdatePaymentIntentPaymentMethodDataFpxBank::Ocbc => "ocbc",
            UpdatePaymentIntentPaymentMethodDataFpxBank::PbEnterprise => "pb_enterprise",
            UpdatePaymentIntentPaymentMethodDataFpxBank::PublicBank => "public_bank",
            UpdatePaymentIntentPaymentMethodDataFpxBank::Rhb => "rhb",
            UpdatePaymentIntentPaymentMethodDataFpxBank::StandardChartered => "standard_chartered",
            UpdatePaymentIntentPaymentMethodDataFpxBank::Uob => "uob",
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodDataFpxBank {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodDataFpxBank {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodDataFpxBank {
    fn default() -> Self {
        Self::AffinBank
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodDataIdeal`'s `bank` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodDataIdealBank {
    AbnAmro,
    AsnBank,
    Bunq,
    Handelsbanken,
    Ing,
    Knab,
    Moneyou,
    Rabobank,
    Regiobank,
    Revolut,
    SnsBank,
    TriodosBank,
    VanLanschot,
}

impl UpdatePaymentIntentPaymentMethodDataIdealBank {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodDataIdealBank::AbnAmro => "abn_amro",
            UpdatePaymentIntentPaymentMethodDataIdealBank::AsnBank => "asn_bank",
            UpdatePaymentIntentPaymentMethodDataIdealBank::Bunq => "bunq",
            UpdatePaymentIntentPaymentMethodDataIdealBank::Handelsbanken => "handelsbanken",
            UpdatePaymentIntentPaymentMethodDataIdealBank::Ing => "ing",
            UpdatePaymentIntentPaymentMethodDataIdealBank::Knab => "knab",
            UpdatePaymentIntentPaymentMethodDataIdealBank::Moneyou => "moneyou",
            UpdatePaymentIntentPaymentMethodDataIdealBank::Rabobank => "rabobank",
            UpdatePaymentIntentPaymentMethodDataIdealBank::Regiobank => "regiobank",
            UpdatePaymentIntentPaymentMethodDataIdealBank::Revolut => "revolut",
            UpdatePaymentIntentPaymentMethodDataIdealBank::SnsBank => "sns_bank",
            UpdatePaymentIntentPaymentMethodDataIdealBank::TriodosBank => "triodos_bank",
            UpdatePaymentIntentPaymentMethodDataIdealBank::VanLanschot => "van_lanschot",
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodDataIdealBank {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodDataIdealBank {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodDataIdealBank {
    fn default() -> Self {
        Self::AbnAmro
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodDataP24`'s `bank` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodDataP24Bank {
    AliorBank,
    BankMillennium,
    BankNowyBfgSa,
    BankPekaoSa,
    BankiSpbdzielcze,
    Blik,
    BnpParibas,
    Boz,
    CitiHandlowy,
    CreditAgricole,
    Envelobank,
    EtransferPocztowy24,
    GetinBank,
    Ideabank,
    Ing,
    Inteligo,
    MbankMtransfer,
    NestPrzelew,
    NoblePay,
    PbacZIpko,
    PlusBank,
    SantanderPrzelew24,
    TmobileUsbugiBankowe,
    ToyotaBank,
    VolkswagenBank,
}

impl UpdatePaymentIntentPaymentMethodDataP24Bank {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodDataP24Bank::AliorBank => "alior_bank",
            UpdatePaymentIntentPaymentMethodDataP24Bank::BankMillennium => "bank_millennium",
            UpdatePaymentIntentPaymentMethodDataP24Bank::BankNowyBfgSa => "bank_nowy_bfg_sa",
            UpdatePaymentIntentPaymentMethodDataP24Bank::BankPekaoSa => "bank_pekao_sa",
            UpdatePaymentIntentPaymentMethodDataP24Bank::BankiSpbdzielcze => "banki_spbdzielcze",
            UpdatePaymentIntentPaymentMethodDataP24Bank::Blik => "blik",
            UpdatePaymentIntentPaymentMethodDataP24Bank::BnpParibas => "bnp_paribas",
            UpdatePaymentIntentPaymentMethodDataP24Bank::Boz => "boz",
            UpdatePaymentIntentPaymentMethodDataP24Bank::CitiHandlowy => "citi_handlowy",
            UpdatePaymentIntentPaymentMethodDataP24Bank::CreditAgricole => "credit_agricole",
            UpdatePaymentIntentPaymentMethodDataP24Bank::Envelobank => "envelobank",
            UpdatePaymentIntentPaymentMethodDataP24Bank::EtransferPocztowy24 => {
                "etransfer_pocztowy24"
            }
            UpdatePaymentIntentPaymentMethodDataP24Bank::GetinBank => "getin_bank",
            UpdatePaymentIntentPaymentMethodDataP24Bank::Ideabank => "ideabank",
            UpdatePaymentIntentPaymentMethodDataP24Bank::Ing => "ing",
            UpdatePaymentIntentPaymentMethodDataP24Bank::Inteligo => "inteligo",
            UpdatePaymentIntentPaymentMethodDataP24Bank::MbankMtransfer => "mbank_mtransfer",
            UpdatePaymentIntentPaymentMethodDataP24Bank::NestPrzelew => "nest_przelew",
            UpdatePaymentIntentPaymentMethodDataP24Bank::NoblePay => "noble_pay",
            UpdatePaymentIntentPaymentMethodDataP24Bank::PbacZIpko => "pbac_z_ipko",
            UpdatePaymentIntentPaymentMethodDataP24Bank::PlusBank => "plus_bank",
            UpdatePaymentIntentPaymentMethodDataP24Bank::SantanderPrzelew24 => {
                "santander_przelew24"
            }
            UpdatePaymentIntentPaymentMethodDataP24Bank::TmobileUsbugiBankowe => {
                "tmobile_usbugi_bankowe"
            }
            UpdatePaymentIntentPaymentMethodDataP24Bank::ToyotaBank => "toyota_bank",
            UpdatePaymentIntentPaymentMethodDataP24Bank::VolkswagenBank => "volkswagen_bank",
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodDataP24Bank {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodDataP24Bank {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodDataP24Bank {
    fn default() -> Self {
        Self::AliorBank
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodDataSofort`'s `country` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodDataSofortCountry {
    #[serde(rename = "AT")]
    At,
    #[serde(rename = "BE")]
    Be,
    #[serde(rename = "DE")]
    De,
    #[serde(rename = "ES")]
    Es,
    #[serde(rename = "IT")]
    It,
    #[serde(rename = "NL")]
    Nl,
}

impl UpdatePaymentIntentPaymentMethodDataSofortCountry {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodDataSofortCountry::At => "AT",
            UpdatePaymentIntentPaymentMethodDataSofortCountry::Be => "BE",
            UpdatePaymentIntentPaymentMethodDataSofortCountry::De => "DE",
            UpdatePaymentIntentPaymentMethodDataSofortCountry::Es => "ES",
            UpdatePaymentIntentPaymentMethodDataSofortCountry::It => "IT",
            UpdatePaymentIntentPaymentMethodDataSofortCountry::Nl => "NL",
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodDataSofortCountry {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodDataSofortCountry {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodDataSofortCountry {
    fn default() -> Self {
        Self::At
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodData`'s `type` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodDataType {
    AcssDebit,
    AfterpayClearpay,
    Alipay,
    AuBecsDebit,
    BacsDebit,
    Bancontact,
    Boleto,
    Eps,
    Fpx,
    Giropay,
    Grabpay,
    Ideal,
    Klarna,
    Konbini,
    Oxxo,
    P24,
    SepaDebit,
    Sofort,
    WechatPay,
}

impl UpdatePaymentIntentPaymentMethodDataType {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodDataType::AcssDebit => "acss_debit",
            UpdatePaymentIntentPaymentMethodDataType::AfterpayClearpay => "afterpay_clearpay",
            UpdatePaymentIntentPaymentMethodDataType::Alipay => "alipay",
            UpdatePaymentIntentPaymentMethodDataType::AuBecsDebit => "au_becs_debit",
            UpdatePaymentIntentPaymentMethodDataType::BacsDebit => "bacs_debit",
            UpdatePaymentIntentPaymentMethodDataType::Bancontact => "bancontact",
            UpdatePaymentIntentPaymentMethodDataType::Boleto => "boleto",
            UpdatePaymentIntentPaymentMethodDataType::Eps => "eps",
            UpdatePaymentIntentPaymentMethodDataType::Fpx => "fpx",
            UpdatePaymentIntentPaymentMethodDataType::Giropay => "giropay",
            UpdatePaymentIntentPaymentMethodDataType::Grabpay => "grabpay",
            UpdatePaymentIntentPaymentMethodDataType::Ideal => "ideal",
            UpdatePaymentIntentPaymentMethodDataType::Klarna => "klarna",
            UpdatePaymentIntentPaymentMethodDataType::Konbini => "konbini",
            UpdatePaymentIntentPaymentMethodDataType::Oxxo => "oxxo",
            UpdatePaymentIntentPaymentMethodDataType::P24 => "p24",
            UpdatePaymentIntentPaymentMethodDataType::SepaDebit => "sepa_debit",
            UpdatePaymentIntentPaymentMethodDataType::Sofort => "sofort",
            UpdatePaymentIntentPaymentMethodDataType::WechatPay => "wechat_pay",
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodDataType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodDataType {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodDataType {
    fn default() -> Self {
        Self::AcssDebit
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptions`'s `payment_schedule` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsPaymentSchedule {
    Combined,
    Interval,
    Sporadic,
}

impl UpdatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsPaymentSchedule {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsPaymentSchedule::Combined => "combined",
            UpdatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsPaymentSchedule::Interval => "interval",
            UpdatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsPaymentSchedule::Sporadic => "sporadic",
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsPaymentSchedule {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display
    for UpdatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsPaymentSchedule
{
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default
    for UpdatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsPaymentSchedule
{
    fn default() -> Self {
        Self::Combined
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptions`'s `transaction_type` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsTransactionType {
    Business,
    Personal,
}

impl UpdatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsTransactionType {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsTransactionType::Business => "business",
            UpdatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsTransactionType::Personal => "personal",
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsTransactionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display
    for UpdatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsTransactionType
{
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default
    for UpdatePaymentIntentPaymentMethodOptionsAcssDebitMandateOptionsTransactionType
{
    fn default() -> Self {
        Self::Business
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsAcssDebit`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsAcssDebitSetupFutureUsage {
    None,
    OffSession,
    OnSession,
}

impl UpdatePaymentIntentPaymentMethodOptionsAcssDebitSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsAcssDebitSetupFutureUsage::None => "none",
            UpdatePaymentIntentPaymentMethodOptionsAcssDebitSetupFutureUsage::OffSession => {
                "off_session"
            }
            UpdatePaymentIntentPaymentMethodOptionsAcssDebitSetupFutureUsage::OnSession => {
                "on_session"
            }
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsAcssDebitSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsAcssDebitSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsAcssDebitSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsAcssDebit`'s `verification_method` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsAcssDebitVerificationMethod {
    Automatic,
    Instant,
    Microdeposits,
}

impl UpdatePaymentIntentPaymentMethodOptionsAcssDebitVerificationMethod {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsAcssDebitVerificationMethod::Automatic => {
                "automatic"
            }
            UpdatePaymentIntentPaymentMethodOptionsAcssDebitVerificationMethod::Instant => {
                "instant"
            }
            UpdatePaymentIntentPaymentMethodOptionsAcssDebitVerificationMethod::Microdeposits => {
                "microdeposits"
            }
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsAcssDebitVerificationMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsAcssDebitVerificationMethod {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsAcssDebitVerificationMethod {
    fn default() -> Self {
        Self::Automatic
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsAfterpayClearpay`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsAfterpayClearpaySetupFutureUsage {
    None,
}

impl UpdatePaymentIntentPaymentMethodOptionsAfterpayClearpaySetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsAfterpayClearpaySetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsAfterpayClearpaySetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsAfterpayClearpaySetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default
    for UpdatePaymentIntentPaymentMethodOptionsAfterpayClearpaySetupFutureUsage
{
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsAlipay`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsAlipaySetupFutureUsage {
    None,
    OffSession,
}

impl UpdatePaymentIntentPaymentMethodOptionsAlipaySetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsAlipaySetupFutureUsage::None => "none",
            UpdatePaymentIntentPaymentMethodOptionsAlipaySetupFutureUsage::OffSession => {
                "off_session"
            }
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsAlipaySetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsAlipaySetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsAlipaySetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsAuBecsDebit`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsAuBecsDebitSetupFutureUsage {
    None,
    OffSession,
    OnSession,
}

impl UpdatePaymentIntentPaymentMethodOptionsAuBecsDebitSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsAuBecsDebitSetupFutureUsage::None => "none",
            UpdatePaymentIntentPaymentMethodOptionsAuBecsDebitSetupFutureUsage::OffSession => {
                "off_session"
            }
            UpdatePaymentIntentPaymentMethodOptionsAuBecsDebitSetupFutureUsage::OnSession => {
                "on_session"
            }
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsAuBecsDebitSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsAuBecsDebitSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsAuBecsDebitSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsBacsDebit`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsBacsDebitSetupFutureUsage {
    None,
    OffSession,
    OnSession,
}

impl UpdatePaymentIntentPaymentMethodOptionsBacsDebitSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsBacsDebitSetupFutureUsage::None => "none",
            UpdatePaymentIntentPaymentMethodOptionsBacsDebitSetupFutureUsage::OffSession => {
                "off_session"
            }
            UpdatePaymentIntentPaymentMethodOptionsBacsDebitSetupFutureUsage::OnSession => {
                "on_session"
            }
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsBacsDebitSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsBacsDebitSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsBacsDebitSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsBancontact`'s `preferred_language` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsBancontactPreferredLanguage {
    De,
    En,
    Fr,
    Nl,
}

impl UpdatePaymentIntentPaymentMethodOptionsBancontactPreferredLanguage {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsBancontactPreferredLanguage::De => "de",
            UpdatePaymentIntentPaymentMethodOptionsBancontactPreferredLanguage::En => "en",
            UpdatePaymentIntentPaymentMethodOptionsBancontactPreferredLanguage::Fr => "fr",
            UpdatePaymentIntentPaymentMethodOptionsBancontactPreferredLanguage::Nl => "nl",
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsBancontactPreferredLanguage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsBancontactPreferredLanguage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsBancontactPreferredLanguage {
    fn default() -> Self {
        Self::De
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsBancontact`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsBancontactSetupFutureUsage {
    None,
    OffSession,
}

impl UpdatePaymentIntentPaymentMethodOptionsBancontactSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsBancontactSetupFutureUsage::None => "none",
            UpdatePaymentIntentPaymentMethodOptionsBancontactSetupFutureUsage::OffSession => {
                "off_session"
            }
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsBancontactSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsBancontactSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsBancontactSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsBoleto`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsBoletoSetupFutureUsage {
    None,
    OffSession,
    OnSession,
}

impl UpdatePaymentIntentPaymentMethodOptionsBoletoSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsBoletoSetupFutureUsage::None => "none",
            UpdatePaymentIntentPaymentMethodOptionsBoletoSetupFutureUsage::OffSession => {
                "off_session"
            }
            UpdatePaymentIntentPaymentMethodOptionsBoletoSetupFutureUsage::OnSession => {
                "on_session"
            }
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsBoletoSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsBoletoSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsBoletoSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsCardInstallmentsPlan`'s `interval` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsCardInstallmentsPlanInterval {
    Month,
}

impl UpdatePaymentIntentPaymentMethodOptionsCardInstallmentsPlanInterval {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsCardInstallmentsPlanInterval::Month => "month",
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsCardInstallmentsPlanInterval {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsCardInstallmentsPlanInterval {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsCardInstallmentsPlanInterval {
    fn default() -> Self {
        Self::Month
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsCardInstallmentsPlan`'s `type` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsCardInstallmentsPlanType {
    FixedCount,
}

impl UpdatePaymentIntentPaymentMethodOptionsCardInstallmentsPlanType {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsCardInstallmentsPlanType::FixedCount => {
                "fixed_count"
            }
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsCardInstallmentsPlanType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsCardInstallmentsPlanType {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsCardInstallmentsPlanType {
    fn default() -> Self {
        Self::FixedCount
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsCardMandateOptions`'s `amount_type` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsCardMandateOptionsAmountType {
    Fixed,
    Maximum,
}

impl UpdatePaymentIntentPaymentMethodOptionsCardMandateOptionsAmountType {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsCardMandateOptionsAmountType::Fixed => "fixed",
            UpdatePaymentIntentPaymentMethodOptionsCardMandateOptionsAmountType::Maximum => {
                "maximum"
            }
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsCardMandateOptionsAmountType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsCardMandateOptionsAmountType {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsCardMandateOptionsAmountType {
    fn default() -> Self {
        Self::Fixed
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsCardMandateOptions`'s `interval` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsCardMandateOptionsInterval {
    Day,
    Month,
    Sporadic,
    Week,
    Year,
}

impl UpdatePaymentIntentPaymentMethodOptionsCardMandateOptionsInterval {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsCardMandateOptionsInterval::Day => "day",
            UpdatePaymentIntentPaymentMethodOptionsCardMandateOptionsInterval::Month => "month",
            UpdatePaymentIntentPaymentMethodOptionsCardMandateOptionsInterval::Sporadic => {
                "sporadic"
            }
            UpdatePaymentIntentPaymentMethodOptionsCardMandateOptionsInterval::Week => "week",
            UpdatePaymentIntentPaymentMethodOptionsCardMandateOptionsInterval::Year => "year",
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsCardMandateOptionsInterval {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsCardMandateOptionsInterval {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsCardMandateOptionsInterval {
    fn default() -> Self {
        Self::Day
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsCardMandateOptions`'s `supported_types` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsCardMandateOptionsSupportedTypes {
    India,
}

impl UpdatePaymentIntentPaymentMethodOptionsCardMandateOptionsSupportedTypes {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsCardMandateOptionsSupportedTypes::India => {
                "india"
            }
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsCardMandateOptionsSupportedTypes {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsCardMandateOptionsSupportedTypes {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default
    for UpdatePaymentIntentPaymentMethodOptionsCardMandateOptionsSupportedTypes
{
    fn default() -> Self {
        Self::India
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsCard`'s `network` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsCardNetwork {
    Amex,
    CartesBancaires,
    Diners,
    Discover,
    Interac,
    Jcb,
    Mastercard,
    Unionpay,
    Unknown,
    Visa,
}

impl UpdatePaymentIntentPaymentMethodOptionsCardNetwork {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsCardNetwork::Amex => "amex",
            UpdatePaymentIntentPaymentMethodOptionsCardNetwork::CartesBancaires => {
                "cartes_bancaires"
            }
            UpdatePaymentIntentPaymentMethodOptionsCardNetwork::Diners => "diners",
            UpdatePaymentIntentPaymentMethodOptionsCardNetwork::Discover => "discover",
            UpdatePaymentIntentPaymentMethodOptionsCardNetwork::Interac => "interac",
            UpdatePaymentIntentPaymentMethodOptionsCardNetwork::Jcb => "jcb",
            UpdatePaymentIntentPaymentMethodOptionsCardNetwork::Mastercard => "mastercard",
            UpdatePaymentIntentPaymentMethodOptionsCardNetwork::Unionpay => "unionpay",
            UpdatePaymentIntentPaymentMethodOptionsCardNetwork::Unknown => "unknown",
            UpdatePaymentIntentPaymentMethodOptionsCardNetwork::Visa => "visa",
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsCardNetwork {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsCardNetwork {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsCardNetwork {
    fn default() -> Self {
        Self::Amex
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsCard`'s `request_three_d_secure` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsCardRequestThreeDSecure {
    Any,
    Automatic,
}

impl UpdatePaymentIntentPaymentMethodOptionsCardRequestThreeDSecure {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsCardRequestThreeDSecure::Any => "any",
            UpdatePaymentIntentPaymentMethodOptionsCardRequestThreeDSecure::Automatic => {
                "automatic"
            }
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsCardRequestThreeDSecure {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsCardRequestThreeDSecure {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsCardRequestThreeDSecure {
    fn default() -> Self {
        Self::Any
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsCard`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsCardSetupFutureUsage {
    None,
    OffSession,
    OnSession,
}

impl UpdatePaymentIntentPaymentMethodOptionsCardSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsCardSetupFutureUsage::None => "none",
            UpdatePaymentIntentPaymentMethodOptionsCardSetupFutureUsage::OffSession => {
                "off_session"
            }
            UpdatePaymentIntentPaymentMethodOptionsCardSetupFutureUsage::OnSession => "on_session",
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsCardSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsCardSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsCardSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsEps`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsEpsSetupFutureUsage {
    None,
}

impl UpdatePaymentIntentPaymentMethodOptionsEpsSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsEpsSetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsEpsSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsEpsSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsEpsSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsFpx`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsFpxSetupFutureUsage {
    None,
}

impl UpdatePaymentIntentPaymentMethodOptionsFpxSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsFpxSetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsFpxSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsFpxSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsFpxSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsGiropay`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsGiropaySetupFutureUsage {
    None,
}

impl UpdatePaymentIntentPaymentMethodOptionsGiropaySetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsGiropaySetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsGiropaySetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsGiropaySetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsGiropaySetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsGrabpay`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsGrabpaySetupFutureUsage {
    None,
}

impl UpdatePaymentIntentPaymentMethodOptionsGrabpaySetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsGrabpaySetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsGrabpaySetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsGrabpaySetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsGrabpaySetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsIdeal`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsIdealSetupFutureUsage {
    None,
    OffSession,
}

impl UpdatePaymentIntentPaymentMethodOptionsIdealSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsIdealSetupFutureUsage::None => "none",
            UpdatePaymentIntentPaymentMethodOptionsIdealSetupFutureUsage::OffSession => {
                "off_session"
            }
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsIdealSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsIdealSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsIdealSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsKlarna`'s `preferred_locale` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale {
    #[serde(rename = "da-DK")]
    DaDk,
    #[serde(rename = "de-AT")]
    DeAt,
    #[serde(rename = "de-DE")]
    DeDe,
    #[serde(rename = "en-AT")]
    EnAt,
    #[serde(rename = "en-BE")]
    EnBe,
    #[serde(rename = "en-DE")]
    EnDe,
    #[serde(rename = "en-DK")]
    EnDk,
    #[serde(rename = "en-ES")]
    EnEs,
    #[serde(rename = "en-FI")]
    EnFi,
    #[serde(rename = "en-FR")]
    EnFr,
    #[serde(rename = "en-GB")]
    EnGb,
    #[serde(rename = "en-IE")]
    EnIe,
    #[serde(rename = "en-IT")]
    EnIt,
    #[serde(rename = "en-NL")]
    EnNl,
    #[serde(rename = "en-NO")]
    EnNo,
    #[serde(rename = "en-SE")]
    EnSe,
    #[serde(rename = "en-US")]
    EnUs,
    #[serde(rename = "es-ES")]
    EsEs,
    #[serde(rename = "es-US")]
    EsUs,
    #[serde(rename = "fi-FI")]
    FiFi,
    #[serde(rename = "fr-BE")]
    FrBe,
    #[serde(rename = "fr-FR")]
    FrFr,
    #[serde(rename = "it-IT")]
    ItIt,
    #[serde(rename = "nb-NO")]
    NbNo,
    #[serde(rename = "nl-BE")]
    NlBe,
    #[serde(rename = "nl-NL")]
    NlNl,
    #[serde(rename = "sv-FI")]
    SvFi,
    #[serde(rename = "sv-SE")]
    SvSe,
}

impl UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::DaDk => "da-DK",
            UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::DeAt => "de-AT",
            UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::DeDe => "de-DE",
            UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EnAt => "en-AT",
            UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EnBe => "en-BE",
            UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EnDe => "en-DE",
            UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EnDk => "en-DK",
            UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EnEs => "en-ES",
            UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EnFi => "en-FI",
            UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EnFr => "en-FR",
            UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EnGb => "en-GB",
            UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EnIe => "en-IE",
            UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EnIt => "en-IT",
            UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EnNl => "en-NL",
            UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EnNo => "en-NO",
            UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EnSe => "en-SE",
            UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EnUs => "en-US",
            UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EsEs => "es-ES",
            UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::EsUs => "es-US",
            UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::FiFi => "fi-FI",
            UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::FrBe => "fr-BE",
            UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::FrFr => "fr-FR",
            UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::ItIt => "it-IT",
            UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::NbNo => "nb-NO",
            UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::NlBe => "nl-BE",
            UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::NlNl => "nl-NL",
            UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::SvFi => "sv-FI",
            UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale::SvSe => "sv-SE",
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsKlarnaPreferredLocale {
    fn default() -> Self {
        Self::DaDk
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsKlarna`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsKlarnaSetupFutureUsage {
    None,
}

impl UpdatePaymentIntentPaymentMethodOptionsKlarnaSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsKlarnaSetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsKlarnaSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsKlarnaSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsKlarnaSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsKonbini`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsKonbiniSetupFutureUsage {
    None,
}

impl UpdatePaymentIntentPaymentMethodOptionsKonbiniSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsKonbiniSetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsKonbiniSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsKonbiniSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsKonbiniSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsOxxo`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsOxxoSetupFutureUsage {
    None,
}

impl UpdatePaymentIntentPaymentMethodOptionsOxxoSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsOxxoSetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsOxxoSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsOxxoSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsOxxoSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsP24`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsP24SetupFutureUsage {
    None,
}

impl UpdatePaymentIntentPaymentMethodOptionsP24SetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsP24SetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsP24SetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsP24SetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsP24SetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsSepaDebit`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsSepaDebitSetupFutureUsage {
    None,
    OffSession,
    OnSession,
}

impl UpdatePaymentIntentPaymentMethodOptionsSepaDebitSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsSepaDebitSetupFutureUsage::None => "none",
            UpdatePaymentIntentPaymentMethodOptionsSepaDebitSetupFutureUsage::OffSession => {
                "off_session"
            }
            UpdatePaymentIntentPaymentMethodOptionsSepaDebitSetupFutureUsage::OnSession => {
                "on_session"
            }
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsSepaDebitSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsSepaDebitSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsSepaDebitSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsSofort`'s `preferred_language` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsSofortPreferredLanguage {
    De,
    En,
    Es,
    Fr,
    It,
    Nl,
    Pl,
}

impl UpdatePaymentIntentPaymentMethodOptionsSofortPreferredLanguage {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsSofortPreferredLanguage::De => "de",
            UpdatePaymentIntentPaymentMethodOptionsSofortPreferredLanguage::En => "en",
            UpdatePaymentIntentPaymentMethodOptionsSofortPreferredLanguage::Es => "es",
            UpdatePaymentIntentPaymentMethodOptionsSofortPreferredLanguage::Fr => "fr",
            UpdatePaymentIntentPaymentMethodOptionsSofortPreferredLanguage::It => "it",
            UpdatePaymentIntentPaymentMethodOptionsSofortPreferredLanguage::Nl => "nl",
            UpdatePaymentIntentPaymentMethodOptionsSofortPreferredLanguage::Pl => "pl",
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsSofortPreferredLanguage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsSofortPreferredLanguage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsSofortPreferredLanguage {
    fn default() -> Self {
        Self::De
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsSofort`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsSofortSetupFutureUsage {
    None,
    OffSession,
}

impl UpdatePaymentIntentPaymentMethodOptionsSofortSetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsSofortSetupFutureUsage::None => "none",
            UpdatePaymentIntentPaymentMethodOptionsSofortSetupFutureUsage::OffSession => {
                "off_session"
            }
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsSofortSetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsSofortSetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsSofortSetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsWechatPay`'s `client` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsWechatPayClient {
    Android,
    Ios,
    Web,
}

impl UpdatePaymentIntentPaymentMethodOptionsWechatPayClient {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsWechatPayClient::Android => "android",
            UpdatePaymentIntentPaymentMethodOptionsWechatPayClient::Ios => "ios",
            UpdatePaymentIntentPaymentMethodOptionsWechatPayClient::Web => "web",
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsWechatPayClient {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsWechatPayClient {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsWechatPayClient {
    fn default() -> Self {
        Self::Android
    }
}

/// An enum representing the possible values of an `UpdatePaymentIntentPaymentMethodOptionsWechatPay`'s `setup_future_usage` field.
#[derive(Copy, Clone, Debug, Deserialize, Serialize, Eq, PartialEq)]
#[serde(rename_all = "snake_case")]
pub enum UpdatePaymentIntentPaymentMethodOptionsWechatPaySetupFutureUsage {
    None,
}

impl UpdatePaymentIntentPaymentMethodOptionsWechatPaySetupFutureUsage {
    pub fn as_str(self) -> &'static str {
        match self {
            UpdatePaymentIntentPaymentMethodOptionsWechatPaySetupFutureUsage::None => "none",
        }
    }
}

impl AsRef<str> for UpdatePaymentIntentPaymentMethodOptionsWechatPaySetupFutureUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

impl std::fmt::Display for UpdatePaymentIntentPaymentMethodOptionsWechatPaySetupFutureUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        self.as_str().fmt(f)
    }
}
impl std::default::Default for UpdatePaymentIntentPaymentMethodOptionsWechatPaySetupFutureUsage {
    fn default() -> Self {
        Self::None
    }
}
