use futures_lite::{AsyncWriteExt, StreamExt};
use smol::io::BufReader;
use smol::net::TcpListener;
use std::str::from_utf8;

fn main() -> anyhow::Result<()> {
    smol::block_on(async {
        let listener = TcpListener::bind("127.0.0.1:12345").await?;
        let mut incoming = listener.incoming();
        while let Some(stream) = incoming.next().await {
            let mut stream = BufReader::new(stream?);
            let req = async_scgi::read_request(&mut stream).await?;
            println!("Headers: {:?}", req.headers);
            println!("Body: {}", from_utf8(&req.body).unwrap());
            stream.write_all(b"Hello Client!").await?;
        }
        Ok(())
    })
}
