use std::str::from_utf8;

use async_scgi::{ScgiHeaders, ScgiRequest};
use futures_lite::{AsyncReadExt, AsyncWriteExt};
use smol::net::TcpStream;

fn main() -> anyhow::Result<()> {
    smol::block_on(async {
        let mut stream = TcpStream::connect("127.0.0.1:12345").await?;
        let mut headers = ScgiHeaders::new();
        headers.insert("PATH_INFO".to_owned(), "/".to_owned());
        headers.insert("SERVER_NAME".to_owned(), "example.com".to_owned());
        let body = b"Hello world!";
        let req = ScgiRequest {
            headers,
            body: body.to_vec(),
        };
        stream.write_all(&req.encode()).await?;
        let mut resp = vec![];
        stream.read_to_end(&mut resp).await?;
        let resp_str = from_utf8(&resp)?;
        println!("{}", resp_str);
        Ok(())
    })
}
