#!/usr/bin/env -S deno run -A

import { BufReader, readLines } from "https://deno.land/std/io/mod.ts";

let enc = new TextEncoder();
let ln = Deno.listen({hostname: "0.0.0.0", port: 8080, transport: "tcp"});
let addr = ln.addr as Deno.NetAddr;
console.log(`listening on ${addr.hostname}:${addr.port}`);

for (var id = 0; id < 10; id ++) {
  let conn = await ln.accept();
  let addr = conn.remoteAddr as Deno.NetAddr;
  console.log(`client[${id}] connected from ${addr.hostname}:${addr.port}`);
  readclose(conn, id);
  write(conn, id);
}

async function readclose(conn: Deno.Reader | Deno.Closer, id: number){
  let scanner = new BufReader(conn as Deno.Reader);
  for (;;) {
    try {
      let line = await scanner.readString('\n');
      if (line == null) {
        console.log(`client[${id}] disconnected: read: EOF`);
        break;
      }
      console.log(`client[${id}]: ${line}`);
    }
    catch (e) {
      console.log(`client[${id}] connected: read: ${e.message}`);
      break;
    }
  }
  (conn as Deno.Closer).close();
}

async function write(conn: Deno.Writer, id: number){
  for (;;) {
    let msg = `client[${id}]: stf\n`;
    let buf = enc.encode(msg);
    try {
      await conn.write(buf);
    }
    catch (e) {
      console.log(`client[${id}] disconnected: write: ${e.message}`);
      break;
    }
    await delay(1000);
  }
}

function delay(ms: number) {
    return new Promise( resolve => setTimeout(resolve, ms) );
}

