use tokio::spawn as go;
use tokio::io::BufReader;
use tokio::io::AsyncBufReadExt;
use tokio::io::AsyncWriteExt;
use tokio::net::TcpListener;
use tokio::net::tcp::OwnedReadHalf;
use tokio::net::tcp::OwnedWriteHalf;
use tokio::time::sleep;
use tokio::time::Duration;

#[tokio::main]
async fn main(){
    let ln = TcpListener::bind("0.0.0.0:8080").await.unwrap();
    println!("listening on {:?}", ln.local_addr().unwrap());
    for client_id in 0.. {
        if let Ok((stream, addr)) = ln.accept().await {
            println!("client[{}] connected from {:?}", client_id, addr);
            let (rd, wr) = stream.into_split();
            go(read(rd, client_id));
            go(write(wr, client_id));
        }
    }
}

async fn read(rd : OwnedReadHalf, client_id : u32) {
    let mut scanner = BufReader::new(rd).lines();
    loop {
        let line = scanner.next_line().await;
        match line {
            Ok(Some(line)) => {
                println!("client[{}]: {}", client_id, line);
            },
            Err(e) => {
                println!("client[{}] disconnected: read: {:?}", client_id, e);
                break;
            },
            Ok(None) => {
                println!("client[{}] disconnected: read: EOF", client_id);
                break;
            },
        };
    }
}

async fn write(mut wr : OwnedWriteHalf, client_id : u32) {
    for i in 0.. {
        if let Err(e) = wr.write_all((format!("client[{}]: {}\n", client_id, i)).as_bytes()).await {
            // client write error
            println!("client[{}] disconnected: write: {}", client_id, e);
            break;
        };
        sleep(Duration::new(1, 0)).await;
    }
}
