use tokio::spawn as go;
use tokio::net::TcpStream;
use tokio::io;
// use tokio::io::AsyncWriteExt;
// use tokio::io::AsyncReadExt;
use std::error::Error;
use std::env;

#[tokio::main]
async fn main() -> Result<(), Box<dyn Error>> {
    let hostport = env::args().nth(1).unwrap_or("127.0.0.1:8080".to_string());
    println!("connecting to {}", hostport);

    // Connect to a peer
    let stream = TcpStream::connect(hostport).await?;

    let mut stdin = io::stdin();
    let mut stdout = io::stdout();

    let (mut r, mut w) = stream.into_split();

    let t1 = go(async move{
        io::copy(&mut stdin, &mut w).await.unwrap();
    });

    let t2 = go(async move{
        io::copy(&mut r, &mut stdout).await.unwrap();
    });

    t1.await.unwrap();
    t2.await.unwrap();

    Ok(())
}
