import 'dart:io';
import 'dart:typed_data';
import 'dart:convert';
import 'dart:async';

main() async {
  var ln = await ServerSocket.bind('0.0.0.0', 8080);
  var client_id = 0;
  var pub = generator(0).map(utf8.encode).asBroadcastStream();
  print("listening on ${ln.address.address}:${ln.port}");
  ln.forEach((conn) async {
    var id = client_id++;
    print("client[${id}] connected from ${conn.remoteAddress.address}:${conn.remotePort}");
    conn..addStream(pub)
         .catchError((e) => print("client[${id}] disconnected: write: ${e}"))
        ..cast<List<int>>().transform(utf8.decoder).transform(LineSplitter())
         .forEach((line) => print('client[${id}]: ["o", "${line}"]'))
         .whenComplete(conn.close)
         .catchError((e) => print("client[${id}] disconnected: read: ${e}"));
  });
}

Stream<String> generator(int id) async* {
  for (var i = 0;; await Future.delayed(Duration(seconds: 1))) {
    yield "${DateTime.now()}\n";
  }
}
