use actix_web::{get, middleware, App, HttpRequest, HttpServer, Responder};
use simple_logger::SimpleLogger;

/// Entry point for index
#[get("/*")]
async fn index(req: HttpRequest) -> impl Responder {
    println!("path: {}\n", req.path());

    let mut body = "".to_string();
    body.push_str(&format!("path: {}\n", req.path()));
    body.push_str(&format!("query_string: {}\n", req.query_string()));
    body.push_str(&format!("headers: {:?}\n", req.headers()));
    body
}

/// Telemetry entry point. Listening by default on 127.0.0.1:8000.
/// This can be changed using the `PORT` and `BIND` ENV variables.
#[actix_rt::main]
async fn main() -> std::io::Result<()> {
    SimpleLogger::new()
        .with_level(log::LevelFilter::Info)
        .init()
        .expect("Must be able to start a logger");
    log::info!("Starting telemetry version: {}", env!("CARGO_PKG_VERSION"));
    HttpServer::new(move || {
        App::new()
            .wrap(middleware::NormalizePath::default())
            .service(index)
    })
    .bind("127.0.0.1:8000")?
    .run()
    .await
}
