use std::sync::{Arc, RwLock};
use lazy_static::lazy_static;

pub type GlobalString = Arc<RwLock<String>>;

#[derive(Debug)]
pub struct Person {
    pub name: String,
    pub age: u8,
}

lazy_static! {
    pub static ref NAME: GlobalString = Arc::new(RwLock::new(String::new()));
    pub static ref ID: String = String::new();
    pub static ref COUNTER: Arc<RwLock<u8>> = Arc::new(RwLock::new(0u8));
    pub static ref SOMEONE: Arc<RwLock<Person>> = Arc::new(RwLock::new(Person{age: 3, name: "alice".to_string()}));
    pub static ref LIST: Arc<RwLock<Vec<u8>>> = Arc::new(RwLock::new(Vec::new()));
}

fn main() {
    {
        println!("{:?}", NAME.read().unwrap());
    }
    {
        let mut w = NAME.write().unwrap();
        w.push_str("btwiuse");
        w.push_str("/");
        w.push_str("arch");
        println!("{:?}", w);
    }
    {
        println!("{:?}", NAME.read().unwrap());
    }
    {
        println!("{:?}", *ID);
        // ID.push_str("hello");
        println!("{:?}", *ID);
    }
    {
        println!("{}", COUNTER.read().unwrap());
    }
    {
        let mut counter = COUNTER.write().unwrap();
        *counter += 1;
        println!("{}", counter);
    }
    {
        let mut someone = SOMEONE.write().unwrap();
        println!("{:?}", someone);
        someone.age = 42;
        println!("{:?}", someone);
        *someone = Person {
            age: 99,
            name: "jack".to_string(),
        };
        println!("{:?}", someone);
    }
    {
        let mut list = LIST.write().unwrap();
        println!("{:?}", list);
        list.push(42);
        println!("{:?}", list);
        *list = (1..9).collect();
        println!("{:?}", list);
    }
}
