#![feature(default_free_fn)]
use std::default::default as def;

#[derive(Debug,Default)]
struct Unit;

// `Default` cannot be derived for enums, only structs
#[derive(Debug)]
enum Number {
    One,
    Two,
}

impl Default for Number {
    fn default() -> Self {
        Self::Two
    }
}

fn main(){
    let default: u8 = Default::default();
    println!("default for u8: {}", default);

    let default: u8 = <u8 as Default>::default();
    println!("default for u8: {}", default);

    let default: u8 = u8::default();
    println!("default for u8: {}", default);

    let default = u8::default();
    println!("default for u8: {}", default);

    let default = Unit::default();
    println!("default for Unit: {:?}", default);

    let default : Unit = def();
    println!("default for Unit: {:?}", default);

    let default = Number::default();
    println!("default for Number: {:?}", default);

    let default : Number = def();
    println!("default for Number: {:?}", default);
}
