use tokio;
use std::{thread, time};
use crossbeam_channel::bounded;
use futures::future::join_all;

async fn println(i : u32) {
    println!("{}", i)
}

pub async fn go() {
    let duration = time::Duration::from_millis(1);
    let (sender, receiver) = bounded::<u32>(1);
    let mut wg = vec![];
    for i in 0..1000 {
        let sender = sender.clone();
        let receiver = receiver.clone();
        wg.push(tokio::spawn(async move {
            sender.send(i).unwrap();
            thread::sleep(duration);
            let i = receiver.recv().unwrap();
            println(i).await;
        }));
    };
    join_all(wg).await;
}

#[tokio::main]
async fn main(){
    go().await;
}
