// +build ignore

package main

import (
	"log"
	"sync"
	"time"
)

func f(w *sync.WaitGroup, i int, c chan bool) {
	defer w.Done()
	c <- true
	time.Sleep(time.Millisecond)
	log.Println(i)
	<-c
}

func main() {
	c := make(chan bool, 1)
	w := &sync.WaitGroup{}
	for i := 0; i < 1000; i++ {
		w.Add(1)
		go f(w, i, c)
	}
	w.Wait()
}
