use std::env;

fn main(){
    let argc = env::args().count();
    println!("{}", argc);

    for i in 0..argc {
        println!("{} {}", i, env::args().nth(i).unwrap());
    }

    for arg in env::args() {
        println!("{}", arg);
    }

    for (i, arg) in env::args().enumerate() {
        println!("{} {}", i, arg);
    }

    for (i, (k, v)) in env::vars().enumerate() {
        println!("{} {}={}", i, k, v);
    }

    println!("{}", env::current_exe().unwrap().into_os_string().into_string().unwrap());

    let args : Vec<String> = env::args().collect();
    println!("{:?}", args);
    println!("{:?}", args.len());
}
