use std::net::TcpListener;
use std::net::TcpStream;
use std::thread::spawn as go;
use tungstenite::accept;

/// A WebSocket echo server
fn main() {
    let hostport = "127.0.0.1:9001";
    let ln = TcpListener::bind(hostport).unwrap();
    println!("listening on {}", hostport);
    loop {
        if let Ok((stream, addr)) = ln.accept() {
            println!("client from {:?}", addr);
            go(|| echo(stream));
        }
    }
}

fn echo(stream: TcpStream) {
    let mut websocket = accept(stream).unwrap();
    loop {
        if let Ok(msg) = websocket.read_message() {
            // We do not want to send back ping/pong messages.
            if msg.is_binary() || msg.is_text() {
                websocket.write_message(msg).unwrap();
            }
        }
    }
}
