use std::str::FromStr;

fn main(){
    let str : &str = "魑魅魍魉";
    let buf : &[u8] = str.as_bytes();
    let string : std::string::String = std::string::String::from_str(str).unwrap();
    println!("str: {}", str);
    println!("buf: {:?}", buf);
    println!("string: {}", string);
    println!("str len: {}", str.len());
    println!("buf len: {}", buf.len());
    println!("string len: {}", string.len());
    for i in 0..=buf.len() {
        //println!("buf[{}]: {}", i, &str[0..=i]);
        //let b : &[u8] = &buf[0..=i];
        //println!("{}", i);
        //if let Ok(s) = std::str::from_utf8(&buf[..i]) {
        match std::str::from_utf8(&buf[..i]) {
            Ok(s) => {
                println!("buf[..{}]: {:?}", i, s);
            },
            Err(e) => {
                println!("buf[..{}]: {:?}", i, e);
            },
        }
    }
    for i in 0..=buf.len() {
        let s = std::string::String::from_utf8_lossy(&buf[..i]);
        println!("buf[..{}]: {:?}", i, s);
    }
}
/*
var str : string = ;
console.log("str:", str);
console.log("str len:", str.length);
var enc : TextEncoder = new TextEncoder();
var dec : TextDecoder = new TextDecoder();
var buf : Uint8Array = enc.encode(str);
console.log("buf:", buf);
console.log("buf len:", buf.length);
for (var i = 0; i <= buf.length; i++) {
  console.log(`buf[${i}]: ${ dec.decode(buf.slice(0, i)) }`);
}
*/
