// +build ignore

package main

import (
	"bufio"
	"fmt"
	"io"
	"log"
	"net"
	"time"
)

func main() {
	ln, err := net.Listen("tcp", "0.0.0.0:8080")
	if err != nil {
		log.Fatalln(err)
	}
	fmt.Println("listening on", ln.Addr())
	for id := 0; ; id++ {
		if conn, err := ln.Accept(); err == nil {
			fmt.Printf("client[%d] connected from %s\n", id, conn.RemoteAddr())
			go readclose(conn, id)
			go write(conn, id)
		}
	}
}

func readclose(conn io.ReadCloser, id int) {
	defer func() {
		fmt.Printf("client[%d] disconnected: read: EOF\n", id)
		conn.Close()
	}()
	scanner := bufio.NewScanner(conn)
	for scanner.Scan() {
		line := scanner.Text()
		fmt.Printf("client[%d]: %s\n", id, line)
	}
}

func write(conn io.Writer, id int) {
	for i := 0; ; i++ {
		if _, err := io.WriteString(conn, fmt.Sprintf("client[%d]: %d\n", id, i)); err != nil {
			fmt.Printf("client[%d] disconnected: write: %s\n", id, err.Error())
			break
		}
		time.Sleep(time.Second)
	}
}
