use actix::prelude::*;
use actix::{Actor, ActorContext, AsyncContext, Addr, Handler, StreamHandler};
use actix_http::ws::Codec;
use actix_http::ResponseBuilder;
use actix_web::{web, get, middleware, App, Error, HttpRequest, HttpResponse, HttpServer, Responder};
use actix_web_actors::ws;
use serde::Deserialize;
use lazy_static::lazy_static;
use std::sync::{Arc, RwLock};
use std::collections::{HashMap, HashSet};
use simple_logger::SimpleLogger;

/// Entry point for index
#[get("/*")]
async fn index(req: HttpRequest) -> impl Responder {
    println!("path: {}\n", req.path());

    let mut body = "".to_string();
    body.push_str(&format!("path: {}\n", req.path()));
    body.push_str(&format!("query_string: {}\n", req.query_string()));
    body.push_str(&format!("headers: {:?}\n", req.headers()));
    body
}

/// Telemetry entry point. Listening by default on 127.0.0.1:8000.
/// This can be changed using the `PORT` and `BIND` ENV variables.
#[actix_rt::main]
async fn main() -> std::io::Result<()> {
    SimpleLogger::new()
        .with_level(log::LevelFilter::Info)
        .init()
        .expect("Must be able to start a logger");
    log::info!("Starting telemetry version: {}", env!("CARGO_PKG_VERSION"));
    HttpServer::new(move || {
        App::new()
            .wrap(middleware::NormalizePath::default())
            .service(index)
    })
    .bind("127.0.0.1:8000")?
    .run()
    .await
}
