trait Foo {
    fn foo(&self);
}
trait Bar {
    fn bar(&self);
}

impl Foo for u32 {
    fn foo(&self) {
        println!("u32::foo");
    }
}

impl Bar for u32 {
    fn bar(&self) {
        println!("u32::bar");
    }
}

impl Foo for String {
    fn foo(&self) {
        println!("String::foo");
    }
}

fn call_foo<T>(value: T)
    where T: Foo
{
    value.foo()
}
//fn call_bar<T: Foo>(value: T) { value.bar() }
//fn call_bar(value: Foo) { value.bar() } // not ok
//fn call_bar(value: impl Foo) { value.bar() }

fn main() {
    (1u32).bar();
    call_foo(1u32);
    call_foo("foo".to_string());
}
