use std::any::Any;
use std::mem;
use std::thread::JoinHandle;

pub type ThreadError = Box<dyn Any + Send + 'static>;
pub enum MapReduceError<E> {
    ThreadFailed(ThreadError),
    Custom(E),
}

pub(crate) struct CtxWrapper {
    data: *const u8,
}

impl Clone for CtxWrapper {
    fn clone(&self) -> Self {
        CtxWrapper { data: self.data }
    }
}

impl Copy for CtxWrapper {}

unsafe impl Send for CtxWrapper {}
unsafe impl Sync for CtxWrapper {}

impl CtxWrapper {
    pub fn new<T>(value: &T) -> CtxWrapper {
        unsafe {
            CtxWrapper {
                data: mem::transmute(value),
            }
        }
    }

    pub fn get<T>(&self) -> &T {
        unsafe { &*(self.data as *const T) }
    }
}

pub(crate) struct Worker<Resp> {
    pub id: usize,
    pub thread: Box<JoinHandle<Resp>>,
}
