use std::any::Any;
use std::thread::JoinHandle;

pub type ThreadError = Box<dyn Any + Send + 'static>;
pub enum MapReduceError<E> {
    ThreadFailed(ThreadError),
    Custom(E),
}

pub(crate) struct CtxWrapper<T: ?Sized> {
    data: *const T,
}

impl<T: ?Sized> Clone for CtxWrapper<T> {
    fn clone(&self) -> Self {
        CtxWrapper { data: self.data }
    }
}

impl<T: ?Sized> Copy for CtxWrapper<T> {}

unsafe impl<T: ?Sized> Send for CtxWrapper<T> {}
unsafe impl<T: ?Sized> Sync for CtxWrapper<T> {}

impl<T: ?Sized> CtxWrapper<T> {
    pub fn new(value: &T) -> CtxWrapper<T> {
        CtxWrapper { data: &*value }
    }

    pub fn get_data(&self) -> &T {
        unsafe { &*self.data }
    }
}

pub(crate) struct Worker<Resp> {
    pub id: usize,
    pub thread: Box<JoinHandle<Resp>>,
}
