# Circe

[![crates.io](https://img.shields.io/crates/v/circe.svg)](https://crates.io/crates/async-circe)
[![Documentation](https://docs.rs/circe/badge.svg)](https://docs.rs/async-circe)
[![Unlicense](https://img.shields.io/crates/l/circe.svg)](./LICENSE)

`Circe` is a an IRC crate built to be as minimal as possible. It's currently work-in-progress, and more stuff is on its way!

## Getting started

To start using Circe, just add the crate to your `Cargo.toml`, and then follow the example below.

```rust
use circe::{Client, Config, Command};

fn main() -> Result<(), std::io::Error> {
    let config = Default::default();
    let mut client = Client::new(config).await.unwrap();
    client.identify().await.unwrap();

    loop {
        if let Ok(ref command) = client.read().await {
            if let Command::PRIVMSG(nick, channel, message) = command {
                println!("{} in {}: {}", nick, channel, message);
            }
        }
    }
}
```

Happy hacking!
