use serde::{Deserialize, Serialize};

// we are modeling a financial planner.

// account for fixed expenses. dont worry about dynamic data yet.
// in this first model a fixed expense is called a "Bill"
// the current version is a simple list with the following points
/* Who we owe?
   How much do we owe?
   How Often?
   what is this bill for?

*/

#[derive(Serialize, Deserialize)]
struct BillBase {
    /// A string holding the name of the Person, Place, or Thing
    payee: String,
    amount: rust_decimal::Decimal,
    date: chrono::DateTime<chrono::Utc>,
    repeat_seconds: Option<u32>,
}
#[cfg(all(not(feature="wasm32"),feature="desktop"))]
#[derive(Serialize,Deserialize,wither::Model)]
pub struct Bill {
    #[serde(rename="_id", skip_serializing_if="Option::is_none")]
    id: Option<wither::mongodb::bson::oid::ObjectId>,
    fields: BillBase
}
#[cfg(all(not(feature="desktop"),feature="wasm32"))]
#[derive(Serialize,Deserialize)]
pub struct Bill {
    #[serde(rename="_id", skip_serializing_if="Option::is_none")]
    id: Option<String>,
    fields: BillBase
}