
//CONSTANTS
///this macro used to declare a constant string

macro_rules! constant_str {
    ($name:ident)=> {
        const $name: &'static str = stringify!($name);
    };
    ($vis:vis,$name:ident)=> {
        $vis const $name: &'static str = stringify!($name);
    };
    ($name:ident,$value:ident)=> {
        const $name: &'static str = stringify!($value);
    };
    ($vis:vis,$name:ident,$value:ident) => {
        $vis const $name:&'static str = stringify!($value);
    };
}
constant_str!(pub,ENV_KEY_SERVER_PORT,SERVER_PORT);
constant_str!(pub,ENV_KEY_PORT,PORT);
constant_str!(pub,ENV_KEY_SERVER_ADDRESS,SERVER_ADDRESS);
cfg_if::cfg_if! {
    if #[cfg(debug_assertions)] {
        pub const DEFAULT_SERVER_PORT:&'static str = "8443";
        pub const DEFAULT_SERVER_ADDRESS:&'static str = "localhost";

    }
    else {
        pub const DEFAULT_SERVER_PORT:&'static str = "443";
        pub const DEFAULT_SERVER_ADDRESS:&'static str = "0.0.0.0";

    }
}
cfg_if::cfg_if! {
    if #[cfg(target_arch="wasm32")] {
        pub extern crate yew;
        pub mod frontend;
    }
    else {
        pub use wither;
        pub mod models;
    }
}

#[derive(thiserror::Error, Debug)]
pub enum Error {
    #[error("{0}")]
    StdEnvVarError(std::env::VarError),
    #[error("{0}")]
    StdNumParseIntError(std::num::ParseIntError),
    #[cfg(not(target_arch = "wasm32"))]
    #[error("{0}")]
    WitherError(wither::WitherError),
    #[cfg(not(target_arch = "wasm32"))]
    #[error("{0}")]
    MongodbError(wither::mongodb::error::Error),
    // #[cfg(all(target_arch="wasm32",feature="wasm32"))]
    // #[error("{0}")]
    // Request
}
cfg_if::cfg_if! {
    if #[cfg(not(target_arch="wasm32"))] {
        impl std::convert::From<std::env::VarError> for crate::Error {
            fn from(e:std::env::VarError) -> Self {
                Self::StdEnvVarError(e)
            }
        }

        impl std::convert::From<wither::mongodb::error::Error> for crate::Error {
            fn from(e:wither::mongodb::error::Error) -> Self {
                Self::MongodbError(e)
            }
        }
        impl std::convert::From<wither::WitherError> for crate::Error {
            fn from(e:wither::WitherError) -> Self {
                Self::WitherError(e)
            }
        }
    }
}
