// use rust_decimal::Decimal;
use serde::{Deserialize, Serialize};

cfg_if::cfg_if! {
    if #[cfg(target_arch="wasm32")]
    {
        pub type Oid = String;
        pub type NaiveDate = String;
        pub type Decimal = String;
        use wasm_bindgen::prelude::*;
    }
    else {
        use wither::bson::{doc, oid::ObjectId};
        // use wither::mongodb::Client;
        // use wither::prelude::*;
        // use wither::Model;
        pub type Oid = ObjectId;
        pub type Decimal = rust_decimal::Decimal;
        pub type NaiveDate = chrono::NaiveDate;
    }
}

#[derive(Serialize, Deserialize)]
#[cfg_attr(target_arch = "wasm32", wasm_bindgen)]
#[cfg_attr(not(target_arch="wasm32"),derive(wither::Model))]
pub struct PlaidTransaction {
    account_id: String,
    amount: Decimal,
    authorized_date: Option<chrono::NaiveDate>,
    category: Vec<String>,
    category_id: String,
    check_number: String,
    date: chrono::NaiveDate,
    #[serde(rename = "_id", skip_serializing_if = "Option::is_none")]
    id: Option<Oid>,
    iso_currency_code: String,
    unofficial_currency_code: Option<String>,
}
#[cfg_attr(target_arch = "wasm32", wasm_bindgen)]
impl PlaidTransaction {
    #[cfg_attr(target_arch = "wasm32", wasm_bindgen(getter))]
    pub fn account_id(&self) -> String {
        self.account_id.to_owned()
    }
    #[cfg_attr(target_arch = "wasm32", wasm_bindgen(getter))]
    pub fn amount(&self) -> Decimal {
        self.amount.into()
    }
    pub fn date(&self) -> NaiveDate {
        self.date.into()
    }
}
