pub type JobId = String;

#[cfg(feature="bill")]
pub mod bill;
#[cfg(feature="user")]
pub mod user;
pub mod plaid_transaction;

// wither::mongodb::bson::ObjectId's cant be imported in target wasm32_unknown_unknown
// becacuse wither depends on socket2, which relies on code not available on that target
#[cfg(target_arch = "wasm32")]
pub type Id = String;
#[cfg(not(target_arch = "wasm32"))]
pub type Id = wither::mongodb::bson::oid::ObjectId;

cfg_if::cfg_if! {
    if #[cfg(not(target_arch="wasm32"))]
    {
        use wither::bson::{doc, oid::ObjectId};
        use wither::mongodb::Client;
        use wither::prelude::*;
        use wither::Model;
        pub const ENV_PREFIX_MONGODB: &'static str = "MONGODB_";
        pub const ENV_KEY_MONGODB_URL: &'static str = "URL";
        pub const ENV_KEY_MONGODB_MAX_CONNECTIONS: &'static str = "MAX_CONNECTIONS";
        pub const ENV_DEFAULT_MONGODB_MAX_CONNECTIONS: u32 = 5;
    }
}



// mongo clients cant be created in webassembly
#[cfg(not(target_arch = "wasm32"))]
pub async fn create_mongo_client() -> Result<Client, crate::Error> {
    let connection_uri = std::env::var(&format!("{}{}", ENV_PREFIX_MONGODB, ENV_KEY_MONGODB_URL))?;
    let max_connections_string = std::env::var(&format!(
        "{}{}",
        ENV_PREFIX_MONGODB, ENV_KEY_MONGODB_MAX_CONNECTIONS
    ))
    .unwrap_or(ENV_DEFAULT_MONGODB_MAX_CONNECTIONS.to_string());
    let max_connections: u32 = max_connections_string
        .as_str()
        .parse::<u32>()
        .unwrap_or(ENV_DEFAULT_MONGODB_MAX_CONNECTIONS);

    // let MAX_CONNECTIONS
    // let client = Client::with_uri_str(&connection_uri).await?;
    let mut options: wither::mongodb::options::ClientOptions =
        wither::mongodb::options::ClientOptions::parse(&connection_uri).await?;
    if (options.max_pool_size).is_none() {
        options.max_pool_size = Some(max_connections);
    };
    // let database= client.database("");
    Ok(Client::with_options(options)?)
}
// it is impossible to perform mongodb related operations directly in wasm
#[cfg(not(target_arch = "wasm32"))]
pub async fn sync_indexes(db: &wither::mongodb::Database) -> Result<(), crate::Error> {
    #[cfg(feature = "log")]
    log::debug!("Syncing Indexes...");
    // #[cfg(feature="user")]
    // user::User::sync(db).await?;
    // plaid_transaction::PlaidTransaction::sync(db).await?;
    Ok(())
}

#[cfg(test)]
#[cfg(not(target_arch = "wasm32"))]
pub mod mongo_tests {

    use super::{create_mongo_client, sync_indexes};
    #[tokio::test]
    pub async fn test_create_mongo_client() -> Result<(), crate::Error> {
        let client = create_mongo_client().await?;
        let database = client
            .default_database()
            .expect("Database to be specified in the connection string");
        sync_indexes(&database).await?;
        Ok(())
    }
}
