# Hampi - Rust ASN.1 Toolkit

The Goal of this project is to implement an ASN.1 Compiler in Rust which can generate Rust bindings for different ASN.1 specifications, which can be used in various protocol implementations in Rust. Also, support for different ASN.1 encoding rules like DER, BER, PER is planned to be implemented as ASN.1 codecs.

While it is certainly desirable to have a fully compliant ASN.1 Compiler, initial focus of the project is to be able to generate code that can be used in other software. First goal is to work with 3GPP specifications for protocols like Radio Network Access Protocl (RANAP), S1 Application protocl (S1AP) and NG Application Protocol (NGAP). Consequently current implementation also focuses on codecs used by these specifications viz. Aligned Packed Encoding Rules (APER).

The use cases targeted by this implementation are similar to the use cases targeted by `asn1c` compiler, which generates `C` bindings from the ASN.1 Specifications.

This project is divided into three crates -

1. asn1-compiler: This crate provides the actual ASN.1 Compiler. Typically a utility (`hampi-asn1c`) will generate Rust structures starting with ASN.1 Specifications. Basic working features required to work with the 3GPP specifications is provided by the compiler, this includes Parameterized Types, Information Object Classes and Type Constraints.
2. asn1-codecs: Support for different encodings supported by individual ASN.1 specifications is provided in this crate. Currently only APER Codec is supported. Each Codec is supported as a `trait` implementing `encode` and `decode` functions. Support for different 'encoding rules' will be implemented in this crate and then the derive macros will utilize this code to actually generate the encoding support for Rust Structures generated by the compiler above.
3. asn1_codecs_derive: This crate provides the `derive` macros for the codecs in `asn-codecs`. The code generated using `asn-compiler` can be directed to `derive` appropriate codecs by passing the flags during compilation.

Note: This is an early implementation and very likely the APIs will change.

## Status

Currently specifications from the `specs/` directory can be compiled into respective Rust modules. These include `RANAP`, `S1AP`, `NGAP` and `NR-RRC`. See below for how these Rust modules can be used.

## Getting Started

The simplest way to try out this in action is - `cargo run --release specs/ngap/NGAP-*  > ngap.rs` and then take a look at generated `ngap` module. (Better CLI support is coming soon.)

### Running Test Cases

1. Test cases can be run through `cargo test`.
2. Right now `examples/` directory contains simple `decode` test cases for modules generated using the `asn-compiler`. This support will be improved to include the generated modules using mechanisms like `build.rs`.
