use serde::{Serialize, Deserialize};

#[derive(Serialize, Deserialize)]
pub struct PutObjectRequest {
    pub object_key: String,
    pub payload_z85: String,
}

#[derive(Serialize, Deserialize)]
pub struct GetObjectRequest {
    pub object_key: String,
}

#[derive(Serialize, Deserialize)]
pub struct GetObjectResponse {
    pub payload_z85: String,
}

#[derive(Serialize, Deserialize, Debug)]
pub struct PutIomodAtRequest {
    pub coordinates: Coordinates,
    pub version: Version,
    pub payload_part_id: Option<u32>,
    pub payload_content_type: String,
    pub payload_z85: String,
}

#[derive(Serialize, Deserialize, Debug)]
pub struct GetIomodAtResponse {
    pub uuid: String,
    pub user_id: String,
    pub coordinates: Coordinates,
    pub version: Version,
    pub payload_z85: String,
}

#[derive(Serialize, Deserialize, Debug, Clone)]
pub struct Coordinates {
    pub organization: String,
    pub namespace: String,
    pub name: String,
}

#[derive(Serialize, Deserialize, Debug, Clone)]
pub struct Version {
    pub major: u32,
    pub minor: u32,
    pub patch: u32,
}

#[derive(Serialize, Deserialize, Debug, Clone)]
pub struct RunConcatRequest {
    pub coordinates: Coordinates,
    pub version: Version,
}

#[derive(Serialize, Deserialize, Clone, Debug)]
pub struct PreSignUpEvent {
    pub version: String,
    pub region: String,
    #[serde(rename = "userPoolId")]
    pub user_pool_id: String,
    #[serde(rename = "userName")]
    pub user_name: String,
    #[serde(rename = "triggerSource")]
    pub trigger_source: String,
    #[serde(rename = "callerContext")]
    pub caller_context: CallerContext, 
    pub request: CognitoPreSignUpRequest,
    pub response: CognitoPreSignUpResponse,
}

#[derive(Serialize, Deserialize, Clone, Debug)]
pub struct CognitoPreSignUpRequest {
    #[serde(rename = "userAttributes", skip_serializing_if = "Option::is_none")]
    pub user_attributes: Option<std::collections::HashMap<String, String>>,
    #[serde(rename = "validationData", skip_serializing_if = "Option::is_none")]
    pub validation_data: Option<std::collections::HashMap<String, String>>,
    #[serde(rename = "clientMetadata", skip_serializing_if = "Option::is_none")]
    pub client_metadata: Option<std::collections::HashMap<String, String>>,
}

#[derive(Serialize, Deserialize, Clone, Debug)]
pub struct CognitoPreSignUpResponse {
    #[serde(rename = "autoConfirmUser")]
    pub auto_confirm_user: bool,
    #[serde(rename = "autoVerifyEmail")]
    pub auto_verify_email: bool,
    #[serde(rename = "autoVerifyPhone")]
    pub auto_verify_phone: bool,
}

#[derive(Serialize, Deserialize, Clone, Debug)]
pub struct CallerContext {
    #[serde(rename = "awsSdkVersion")]
    pub aws_sdk_version: String,
    #[serde(rename = "clientId")]
    pub client_id: String,
}
