use std::fmt;
use std::fmt::Formatter;

use serde::{Serialize, Deserialize};

#[derive(Debug, Serialize, Deserialize)]
pub struct DynamoDbError {
    pub why: String,
}
impl fmt::Display for DynamoDbError {
    fn fmt(&self, f: &mut Formatter<'_>) -> fmt::Result {
        write!(f, "{}", self.why)
    }
}
impl std::error::Error for DynamoDbError {}
