use std::fmt::{self, Debug, Display};
use std::ops::Deref;

#[derive(Copy, Clone, Eq, PartialEq, Ord, PartialOrd, Hash)]
pub struct Name {
    index: i32,
}

impl Name {
    pub(crate) const unsafe fn new(index: i32) -> Self {
        Name { index }
    }

    pub fn as_str(&self) -> &'static str {
        unsafe { *crate::generated::NAMES.get_unchecked(self.index as usize) }
    }
}

impl Deref for Name {
    type Target = str;
    fn deref(&self) -> &Self::Target {
        self.as_str()
    }
}

impl Display for Name {
    fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
        Display::fmt(&**self, formatter)
    }
}

impl Debug for Name {
    fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
        Debug::fmt(&**self, formatter)
    }
}
