enum Opcode {}

enum Register {
    EAX,
    AX,
    AH,
    AL,

    EBX,
    BX,
    BH,
    BL,

    ECX,
    CX,
    CH,
    CL,

    EDX,
    DX,
    DH,
    DL,

    ESI,
    EBP,
    ESP,

    CS,
    DS,
    SS,
    ES,
    FS,
    GS,

    EFLAGS,

    EIP,
}

bitflags::bitflags! {
    struct EFlags: u32 {
        /// # Carry flag
        ///
        /// Set if an arithmetic operation generates a carry or a borrow out of
        /// the most-significant bit of the result; cleared otherwise. This
        /// flag indicates an overflow condition for unsigned-integer
        /// arithmetic. It is also used in multiple-precision arithmetic.
        const CF = 1 << 0;

        /// # Parity flag
        ///
        /// Set if the least-significant byte of the result contains an even
        /// number of 1 bits; cleared otherwise.
        const PF = 1 << 2;

        /// # Auxiliary Carry flag
        ///
        /// Set if an arithmetic operation generates a carry or a borrow out of
        /// bit 3 of the result; cleared otherwise. This flag is used in
        /// binary-coded decimal (BCD) arithmetic.
        const AF = 1 << 4;

        /// # Zero flag
        ///
        /// Set if the result is zero; cleared otherwise.
        const ZF = 1 << 6;

        /// # Sign flag
        /// Set equal to the most-significant bit of the result, which is the sign
        /// bit of a signed integer. (0 indicates a positive value and 1 indicates a
        /// negative value.)
        const SF = 1 << 7;

        /// # Trap flag
        ///
        /// Set to enable single-step mode for debugging; clear to disable single-step mode.
        const TF = 1 << 8;

        /// # Interrupt enable flag
        ///
        /// Controls the response of the processor to maskable interrupt
        /// requests. Set to respond to maskable interrupts; cleared to inhibit
        /// maskable interrupts.
        const IF = 1 << 9;

        /// # Direction flag
        ///
        /// The direction flag (DF, located in bit 10 of the EFLAGS register)
        /// controls string instructions (MOVS, CMPS, SCAS, LODS, and STOS). Setting
        /// the DF flag causes the string instructions to auto-decrement (to process
        /// strings from high addresses to low addresses). Clearing the DF flag
        /// causes the string instructions to auto-increment (process strings from
        /// low addresses to high addresses).
        /// The STD and CLD instructions set and clear the DF flag, respectively
        const DF = 1 << 10;

        /// # Overflow flag
        ///
        /// Set if the integer result is too large a positive number or too small a
        /// negative number (excluding the sign-bit) to fit in the destination
        /// operand; cleared otherwise. This flag indicates an overflow condition
        /// for signed-integer (two’s complement) arithmetic.
        const OF = 1 << 11;

        /// # I/O privilege level field
        ///
        /// Indicates the I/O privilege level of the currently running program
        /// or task. The current privilege level (CPL) of the currently running
        /// program or task must be less than or equal to the I/O privilege level to
        /// access the I/O address space. The POPF and IRET instructions can modify
        /// this field only when operating at a CPL of 0.
        const IOPL = 1 << 12 & 1 << 13;

        /// # Nested task flag
        ///
        /// Controls the chaining of interrupted and called tasks. Set when the
        /// current task is linked to the previously executed task; cleared when the
        /// current task is not linked to another task.
        const NT = 1 << 14;

        /// # Resume flag
        ///
        /// Controls the processor’s response to debug exceptions.
        const RF = 1 << 16;

        /// # Virtual-8086 mode flag
        ///
        /// Set to enable virtual-8086 mode; clear to return to protected mode
        /// without virtual-8086 mode semantics.
        const VM = 1 << 17;

        /// # Alignment check (or access control) flag
        ///
        /// If the AM bit is set in the CR0 register, alignment checking of
        /// user-mode data accesses is enabled if and only if this flag is 1.
        const AC = 1 << 18;

        /// # Virtual interrupt flag
        ///
        /// Virtual image of the IF flag. Used in conjunction with the VIP flag.
        const VIF = 1 << 19;

        /// # Virtual interrupt pending flag
        ///
        /// Set to indicate that an interrupt is pending; clear when no interrupt is
        /// pending. (Software sets and clears this flag; the processor only reads
        /// it.) Used in conjunction with the VIF flag.
        const VIP = 1 << 20;

        /// # Identification flag
        ///
        /// The ability of a program to set or clear this flag indicates support for
        /// the CPUID instruction.
        const ID = 1 << 21;
    }
}
