/* automatically generated by rust-bindgen 0.58.0 */

#![allow(nonstandard_style, clippy::all)]

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ImGuiContext {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ImFontBuilderIO {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ImDrawListSharedData {
    _unused: [u8; 0],
}
pub type ImGuiCol = cty::c_int;
pub type ImGuiCond = cty::c_int;
pub type ImGuiDataType = cty::c_int;
pub type ImGuiDir = cty::c_int;
pub type ImGuiKey = cty::c_int;
pub type ImGuiMouseButton = cty::c_int;
pub type ImGuiMouseCursor = cty::c_int;
pub type ImGuiSortDirection = cty::c_int;
pub type ImGuiStyleVar = cty::c_int;
pub type ImGuiTableBgTarget = cty::c_int;
pub type ImDrawFlags = cty::c_int;
pub type ImDrawListFlags = cty::c_int;
pub type ImFontAtlasFlags = cty::c_int;
pub type ImGuiBackendFlags = cty::c_int;
pub type ImGuiButtonFlags = cty::c_int;
pub type ImGuiColorEditFlags = cty::c_int;
pub type ImGuiConfigFlags = cty::c_int;
pub type ImGuiComboFlags = cty::c_int;
pub type ImGuiDragDropFlags = cty::c_int;
pub type ImGuiFocusedFlags = cty::c_int;
pub type ImGuiHoveredFlags = cty::c_int;
pub type ImGuiInputTextFlags = cty::c_int;
pub type ImGuiKeyModFlags = cty::c_int;
pub type ImGuiPopupFlags = cty::c_int;
pub type ImGuiSelectableFlags = cty::c_int;
pub type ImGuiSliderFlags = cty::c_int;
pub type ImGuiTabBarFlags = cty::c_int;
pub type ImGuiTabItemFlags = cty::c_int;
pub type ImGuiTableFlags = cty::c_int;
pub type ImGuiTableColumnFlags = cty::c_int;
pub type ImGuiTableRowFlags = cty::c_int;
pub type ImGuiTreeNodeFlags = cty::c_int;
pub type ImGuiViewportFlags = cty::c_int;
pub type ImGuiWindowFlags = cty::c_int;
pub type ImTextureID = *mut cty::c_void;
pub type ImGuiID = cty::c_uint;
pub type ImGuiInputTextCallback = ::core::option::Option<
    unsafe extern "C" fn(data: *mut ImGuiInputTextCallbackData) -> cty::c_int,
>;
pub type ImGuiSizeCallback =
    ::core::option::Option<unsafe extern "C" fn(data: *mut ImGuiSizeCallbackData)>;
pub type ImGuiMemAllocFunc = ::core::option::Option<
    unsafe extern "C" fn(sz: usize, user_data: *mut cty::c_void) -> *mut cty::c_void,
>;
pub type ImGuiMemFreeFunc = ::core::option::Option<
    unsafe extern "C" fn(ptr: *mut cty::c_void, user_data: *mut cty::c_void),
>;
pub type ImWchar16 = cty::c_ushort;
pub type ImWchar32 = cty::c_uint;
pub type ImWchar = ImWchar32;
pub type ImU8 = cty::c_uchar;
pub type ImS16 = cty::c_short;
pub type ImU32 = cty::c_uint;
pub type ImDrawCallback = ::core::option::Option<
    unsafe extern "C" fn(parent_list: *const ImDrawList, cmd: *const ImDrawCmd),
>;
pub type ImDrawIdx = cty::c_ushort;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImDrawChannel {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImDrawChannel,
}
impl Default for ImVector_ImDrawChannel {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImDrawCmd {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImDrawCmd,
}
impl Default for ImVector_ImDrawCmd {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImDrawIdx {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImDrawIdx,
}
impl Default for ImVector_ImDrawIdx {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImDrawVert {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImDrawVert,
}
impl Default for ImVector_ImDrawVert {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImFontPtr {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut *mut ImFont,
}
impl Default for ImVector_ImFontPtr {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImFontAtlasCustomRect {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImFontAtlasCustomRect,
}
impl Default for ImVector_ImFontAtlasCustomRect {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImFontConfig {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImFontConfig,
}
impl Default for ImVector_ImFontConfig {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImFontGlyph {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImFontGlyph,
}
impl Default for ImVector_ImFontGlyph {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiStoragePair {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiStoragePair,
}
impl Default for ImVector_ImGuiStoragePair {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiTextRange {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiTextRange,
}
impl Default for ImVector_ImGuiTextRange {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImTextureID {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImTextureID,
}
impl Default for ImVector_ImTextureID {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImU32 {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImU32,
}
impl Default for ImVector_ImU32 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImVec2 {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImVec2,
}
impl Default for ImVector_ImVec2 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImVec4 {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImVec4,
}
impl Default for ImVector_ImVec4 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImWchar {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImWchar,
}
impl Default for ImVector_ImWchar {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_char {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut cty::c_char,
}
impl Default for ImVector_char {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_float {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut f32,
}
impl Default for ImVector_float {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImVec2 {
    pub x: f32,
    pub y: f32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImVec4 {
    pub x: f32,
    pub y: f32,
    pub z: f32,
    pub w: f32,
}
pub const ImGuiWindowFlags_None: ImGuiWindowFlags_ = 0;
pub const ImGuiWindowFlags_NoTitleBar: ImGuiWindowFlags_ = 1;
pub const ImGuiWindowFlags_NoResize: ImGuiWindowFlags_ = 2;
pub const ImGuiWindowFlags_NoMove: ImGuiWindowFlags_ = 4;
pub const ImGuiWindowFlags_NoScrollbar: ImGuiWindowFlags_ = 8;
pub const ImGuiWindowFlags_NoScrollWithMouse: ImGuiWindowFlags_ = 16;
pub const ImGuiWindowFlags_NoCollapse: ImGuiWindowFlags_ = 32;
pub const ImGuiWindowFlags_AlwaysAutoResize: ImGuiWindowFlags_ = 64;
pub const ImGuiWindowFlags_NoBackground: ImGuiWindowFlags_ = 128;
pub const ImGuiWindowFlags_NoSavedSettings: ImGuiWindowFlags_ = 256;
pub const ImGuiWindowFlags_NoMouseInputs: ImGuiWindowFlags_ = 512;
pub const ImGuiWindowFlags_MenuBar: ImGuiWindowFlags_ = 1024;
pub const ImGuiWindowFlags_HorizontalScrollbar: ImGuiWindowFlags_ = 2048;
pub const ImGuiWindowFlags_NoFocusOnAppearing: ImGuiWindowFlags_ = 4096;
pub const ImGuiWindowFlags_NoBringToFrontOnFocus: ImGuiWindowFlags_ = 8192;
pub const ImGuiWindowFlags_AlwaysVerticalScrollbar: ImGuiWindowFlags_ = 16384;
pub const ImGuiWindowFlags_AlwaysHorizontalScrollbar: ImGuiWindowFlags_ = 32768;
pub const ImGuiWindowFlags_AlwaysUseWindowPadding: ImGuiWindowFlags_ = 65536;
pub const ImGuiWindowFlags_NoNavInputs: ImGuiWindowFlags_ = 262144;
pub const ImGuiWindowFlags_NoNavFocus: ImGuiWindowFlags_ = 524288;
pub const ImGuiWindowFlags_UnsavedDocument: ImGuiWindowFlags_ = 1048576;
pub const ImGuiWindowFlags_NoNav: ImGuiWindowFlags_ = 786432;
pub const ImGuiWindowFlags_NoDecoration: ImGuiWindowFlags_ = 43;
pub const ImGuiWindowFlags_NoInputs: ImGuiWindowFlags_ = 786944;
pub const ImGuiWindowFlags_NavFlattened: ImGuiWindowFlags_ = 8388608;
pub const ImGuiWindowFlags_ChildWindow: ImGuiWindowFlags_ = 16777216;
pub const ImGuiWindowFlags_Tooltip: ImGuiWindowFlags_ = 33554432;
pub const ImGuiWindowFlags_Popup: ImGuiWindowFlags_ = 67108864;
pub const ImGuiWindowFlags_Modal: ImGuiWindowFlags_ = 134217728;
pub const ImGuiWindowFlags_ChildMenu: ImGuiWindowFlags_ = 268435456;
pub type ImGuiWindowFlags_ = cty::c_uint;
pub const ImGuiInputTextFlags_None: ImGuiInputTextFlags_ = 0;
pub const ImGuiInputTextFlags_CharsDecimal: ImGuiInputTextFlags_ = 1;
pub const ImGuiInputTextFlags_CharsHexadecimal: ImGuiInputTextFlags_ = 2;
pub const ImGuiInputTextFlags_CharsUppercase: ImGuiInputTextFlags_ = 4;
pub const ImGuiInputTextFlags_CharsNoBlank: ImGuiInputTextFlags_ = 8;
pub const ImGuiInputTextFlags_AutoSelectAll: ImGuiInputTextFlags_ = 16;
pub const ImGuiInputTextFlags_EnterReturnsTrue: ImGuiInputTextFlags_ = 32;
pub const ImGuiInputTextFlags_CallbackCompletion: ImGuiInputTextFlags_ = 64;
pub const ImGuiInputTextFlags_CallbackHistory: ImGuiInputTextFlags_ = 128;
pub const ImGuiInputTextFlags_CallbackAlways: ImGuiInputTextFlags_ = 256;
pub const ImGuiInputTextFlags_CallbackCharFilter: ImGuiInputTextFlags_ = 512;
pub const ImGuiInputTextFlags_AllowTabInput: ImGuiInputTextFlags_ = 1024;
pub const ImGuiInputTextFlags_CtrlEnterForNewLine: ImGuiInputTextFlags_ = 2048;
pub const ImGuiInputTextFlags_NoHorizontalScroll: ImGuiInputTextFlags_ = 4096;
pub const ImGuiInputTextFlags_AlwaysOverwrite: ImGuiInputTextFlags_ = 8192;
pub const ImGuiInputTextFlags_ReadOnly: ImGuiInputTextFlags_ = 16384;
pub const ImGuiInputTextFlags_Password: ImGuiInputTextFlags_ = 32768;
pub const ImGuiInputTextFlags_NoUndoRedo: ImGuiInputTextFlags_ = 65536;
pub const ImGuiInputTextFlags_CharsScientific: ImGuiInputTextFlags_ = 131072;
pub const ImGuiInputTextFlags_CallbackResize: ImGuiInputTextFlags_ = 262144;
pub const ImGuiInputTextFlags_CallbackEdit: ImGuiInputTextFlags_ = 524288;
pub const ImGuiInputTextFlags_Multiline: ImGuiInputTextFlags_ = 1048576;
pub const ImGuiInputTextFlags_NoMarkEdited: ImGuiInputTextFlags_ = 2097152;
pub type ImGuiInputTextFlags_ = cty::c_uint;
pub const ImGuiTreeNodeFlags_None: ImGuiTreeNodeFlags_ = 0;
pub const ImGuiTreeNodeFlags_Selected: ImGuiTreeNodeFlags_ = 1;
pub const ImGuiTreeNodeFlags_Framed: ImGuiTreeNodeFlags_ = 2;
pub const ImGuiTreeNodeFlags_AllowItemOverlap: ImGuiTreeNodeFlags_ = 4;
pub const ImGuiTreeNodeFlags_NoTreePushOnOpen: ImGuiTreeNodeFlags_ = 8;
pub const ImGuiTreeNodeFlags_NoAutoOpenOnLog: ImGuiTreeNodeFlags_ = 16;
pub const ImGuiTreeNodeFlags_DefaultOpen: ImGuiTreeNodeFlags_ = 32;
pub const ImGuiTreeNodeFlags_OpenOnDoubleClick: ImGuiTreeNodeFlags_ = 64;
pub const ImGuiTreeNodeFlags_OpenOnArrow: ImGuiTreeNodeFlags_ = 128;
pub const ImGuiTreeNodeFlags_Leaf: ImGuiTreeNodeFlags_ = 256;
pub const ImGuiTreeNodeFlags_Bullet: ImGuiTreeNodeFlags_ = 512;
pub const ImGuiTreeNodeFlags_FramePadding: ImGuiTreeNodeFlags_ = 1024;
pub const ImGuiTreeNodeFlags_SpanAvailWidth: ImGuiTreeNodeFlags_ = 2048;
pub const ImGuiTreeNodeFlags_SpanFullWidth: ImGuiTreeNodeFlags_ = 4096;
pub const ImGuiTreeNodeFlags_NavLeftJumpsBackHere: ImGuiTreeNodeFlags_ = 8192;
pub const ImGuiTreeNodeFlags_CollapsingHeader: ImGuiTreeNodeFlags_ = 26;
pub type ImGuiTreeNodeFlags_ = cty::c_uint;
pub const ImGuiPopupFlags_None: ImGuiPopupFlags_ = 0;
pub const ImGuiPopupFlags_MouseButtonLeft: ImGuiPopupFlags_ = 0;
pub const ImGuiPopupFlags_MouseButtonRight: ImGuiPopupFlags_ = 1;
pub const ImGuiPopupFlags_MouseButtonMiddle: ImGuiPopupFlags_ = 2;
pub const ImGuiPopupFlags_MouseButtonMask_: ImGuiPopupFlags_ = 31;
pub const ImGuiPopupFlags_MouseButtonDefault_: ImGuiPopupFlags_ = 1;
pub const ImGuiPopupFlags_NoOpenOverExistingPopup: ImGuiPopupFlags_ = 32;
pub const ImGuiPopupFlags_NoOpenOverItems: ImGuiPopupFlags_ = 64;
pub const ImGuiPopupFlags_AnyPopupId: ImGuiPopupFlags_ = 128;
pub const ImGuiPopupFlags_AnyPopupLevel: ImGuiPopupFlags_ = 256;
pub const ImGuiPopupFlags_AnyPopup: ImGuiPopupFlags_ = 384;
pub type ImGuiPopupFlags_ = cty::c_uint;
pub const ImGuiSelectableFlags_None: ImGuiSelectableFlags_ = 0;
pub const ImGuiSelectableFlags_DontClosePopups: ImGuiSelectableFlags_ = 1;
pub const ImGuiSelectableFlags_SpanAllColumns: ImGuiSelectableFlags_ = 2;
pub const ImGuiSelectableFlags_AllowDoubleClick: ImGuiSelectableFlags_ = 4;
pub const ImGuiSelectableFlags_Disabled: ImGuiSelectableFlags_ = 8;
pub const ImGuiSelectableFlags_AllowItemOverlap: ImGuiSelectableFlags_ = 16;
pub type ImGuiSelectableFlags_ = cty::c_uint;
pub const ImGuiComboFlags_None: ImGuiComboFlags_ = 0;
pub const ImGuiComboFlags_PopupAlignLeft: ImGuiComboFlags_ = 1;
pub const ImGuiComboFlags_HeightSmall: ImGuiComboFlags_ = 2;
pub const ImGuiComboFlags_HeightRegular: ImGuiComboFlags_ = 4;
pub const ImGuiComboFlags_HeightLarge: ImGuiComboFlags_ = 8;
pub const ImGuiComboFlags_HeightLargest: ImGuiComboFlags_ = 16;
pub const ImGuiComboFlags_NoArrowButton: ImGuiComboFlags_ = 32;
pub const ImGuiComboFlags_NoPreview: ImGuiComboFlags_ = 64;
pub const ImGuiComboFlags_HeightMask_: ImGuiComboFlags_ = 30;
pub type ImGuiComboFlags_ = cty::c_uint;
pub const ImGuiTabBarFlags_None: ImGuiTabBarFlags_ = 0;
pub const ImGuiTabBarFlags_Reorderable: ImGuiTabBarFlags_ = 1;
pub const ImGuiTabBarFlags_AutoSelectNewTabs: ImGuiTabBarFlags_ = 2;
pub const ImGuiTabBarFlags_TabListPopupButton: ImGuiTabBarFlags_ = 4;
pub const ImGuiTabBarFlags_NoCloseWithMiddleMouseButton: ImGuiTabBarFlags_ = 8;
pub const ImGuiTabBarFlags_NoTabListScrollingButtons: ImGuiTabBarFlags_ = 16;
pub const ImGuiTabBarFlags_NoTooltip: ImGuiTabBarFlags_ = 32;
pub const ImGuiTabBarFlags_FittingPolicyResizeDown: ImGuiTabBarFlags_ = 64;
pub const ImGuiTabBarFlags_FittingPolicyScroll: ImGuiTabBarFlags_ = 128;
pub const ImGuiTabBarFlags_FittingPolicyMask_: ImGuiTabBarFlags_ = 192;
pub const ImGuiTabBarFlags_FittingPolicyDefault_: ImGuiTabBarFlags_ = 64;
pub type ImGuiTabBarFlags_ = cty::c_uint;
pub const ImGuiTabItemFlags_None: ImGuiTabItemFlags_ = 0;
pub const ImGuiTabItemFlags_UnsavedDocument: ImGuiTabItemFlags_ = 1;
pub const ImGuiTabItemFlags_SetSelected: ImGuiTabItemFlags_ = 2;
pub const ImGuiTabItemFlags_NoCloseWithMiddleMouseButton: ImGuiTabItemFlags_ = 4;
pub const ImGuiTabItemFlags_NoPushId: ImGuiTabItemFlags_ = 8;
pub const ImGuiTabItemFlags_NoTooltip: ImGuiTabItemFlags_ = 16;
pub const ImGuiTabItemFlags_NoReorder: ImGuiTabItemFlags_ = 32;
pub const ImGuiTabItemFlags_Leading: ImGuiTabItemFlags_ = 64;
pub const ImGuiTabItemFlags_Trailing: ImGuiTabItemFlags_ = 128;
pub type ImGuiTabItemFlags_ = cty::c_uint;
pub const ImGuiTableFlags_None: ImGuiTableFlags_ = 0;
pub const ImGuiTableFlags_Resizable: ImGuiTableFlags_ = 1;
pub const ImGuiTableFlags_Reorderable: ImGuiTableFlags_ = 2;
pub const ImGuiTableFlags_Hideable: ImGuiTableFlags_ = 4;
pub const ImGuiTableFlags_Sortable: ImGuiTableFlags_ = 8;
pub const ImGuiTableFlags_NoSavedSettings: ImGuiTableFlags_ = 16;
pub const ImGuiTableFlags_ContextMenuInBody: ImGuiTableFlags_ = 32;
pub const ImGuiTableFlags_RowBg: ImGuiTableFlags_ = 64;
pub const ImGuiTableFlags_BordersInnerH: ImGuiTableFlags_ = 128;
pub const ImGuiTableFlags_BordersOuterH: ImGuiTableFlags_ = 256;
pub const ImGuiTableFlags_BordersInnerV: ImGuiTableFlags_ = 512;
pub const ImGuiTableFlags_BordersOuterV: ImGuiTableFlags_ = 1024;
pub const ImGuiTableFlags_BordersH: ImGuiTableFlags_ = 384;
pub const ImGuiTableFlags_BordersV: ImGuiTableFlags_ = 1536;
pub const ImGuiTableFlags_BordersInner: ImGuiTableFlags_ = 640;
pub const ImGuiTableFlags_BordersOuter: ImGuiTableFlags_ = 1280;
pub const ImGuiTableFlags_Borders: ImGuiTableFlags_ = 1920;
pub const ImGuiTableFlags_NoBordersInBody: ImGuiTableFlags_ = 2048;
pub const ImGuiTableFlags_NoBordersInBodyUntilResize: ImGuiTableFlags_ = 4096;
pub const ImGuiTableFlags_SizingFixedFit: ImGuiTableFlags_ = 8192;
pub const ImGuiTableFlags_SizingFixedSame: ImGuiTableFlags_ = 16384;
pub const ImGuiTableFlags_SizingStretchProp: ImGuiTableFlags_ = 24576;
pub const ImGuiTableFlags_SizingStretchSame: ImGuiTableFlags_ = 32768;
pub const ImGuiTableFlags_NoHostExtendX: ImGuiTableFlags_ = 65536;
pub const ImGuiTableFlags_NoHostExtendY: ImGuiTableFlags_ = 131072;
pub const ImGuiTableFlags_NoKeepColumnsVisible: ImGuiTableFlags_ = 262144;
pub const ImGuiTableFlags_PreciseWidths: ImGuiTableFlags_ = 524288;
pub const ImGuiTableFlags_NoClip: ImGuiTableFlags_ = 1048576;
pub const ImGuiTableFlags_PadOuterX: ImGuiTableFlags_ = 2097152;
pub const ImGuiTableFlags_NoPadOuterX: ImGuiTableFlags_ = 4194304;
pub const ImGuiTableFlags_NoPadInnerX: ImGuiTableFlags_ = 8388608;
pub const ImGuiTableFlags_ScrollX: ImGuiTableFlags_ = 16777216;
pub const ImGuiTableFlags_ScrollY: ImGuiTableFlags_ = 33554432;
pub const ImGuiTableFlags_SortMulti: ImGuiTableFlags_ = 67108864;
pub const ImGuiTableFlags_SortTristate: ImGuiTableFlags_ = 134217728;
pub const ImGuiTableFlags_SizingMask_: ImGuiTableFlags_ = 57344;
pub type ImGuiTableFlags_ = cty::c_uint;
pub const ImGuiTableColumnFlags_None: ImGuiTableColumnFlags_ = 0;
pub const ImGuiTableColumnFlags_DefaultHide: ImGuiTableColumnFlags_ = 1;
pub const ImGuiTableColumnFlags_DefaultSort: ImGuiTableColumnFlags_ = 2;
pub const ImGuiTableColumnFlags_WidthStretch: ImGuiTableColumnFlags_ = 4;
pub const ImGuiTableColumnFlags_WidthFixed: ImGuiTableColumnFlags_ = 8;
pub const ImGuiTableColumnFlags_NoResize: ImGuiTableColumnFlags_ = 16;
pub const ImGuiTableColumnFlags_NoReorder: ImGuiTableColumnFlags_ = 32;
pub const ImGuiTableColumnFlags_NoHide: ImGuiTableColumnFlags_ = 64;
pub const ImGuiTableColumnFlags_NoClip: ImGuiTableColumnFlags_ = 128;
pub const ImGuiTableColumnFlags_NoSort: ImGuiTableColumnFlags_ = 256;
pub const ImGuiTableColumnFlags_NoSortAscending: ImGuiTableColumnFlags_ = 512;
pub const ImGuiTableColumnFlags_NoSortDescending: ImGuiTableColumnFlags_ = 1024;
pub const ImGuiTableColumnFlags_NoHeaderWidth: ImGuiTableColumnFlags_ = 2048;
pub const ImGuiTableColumnFlags_PreferSortAscending: ImGuiTableColumnFlags_ = 4096;
pub const ImGuiTableColumnFlags_PreferSortDescending: ImGuiTableColumnFlags_ = 8192;
pub const ImGuiTableColumnFlags_IndentEnable: ImGuiTableColumnFlags_ = 16384;
pub const ImGuiTableColumnFlags_IndentDisable: ImGuiTableColumnFlags_ = 32768;
pub const ImGuiTableColumnFlags_IsEnabled: ImGuiTableColumnFlags_ = 1048576;
pub const ImGuiTableColumnFlags_IsVisible: ImGuiTableColumnFlags_ = 2097152;
pub const ImGuiTableColumnFlags_IsSorted: ImGuiTableColumnFlags_ = 4194304;
pub const ImGuiTableColumnFlags_IsHovered: ImGuiTableColumnFlags_ = 8388608;
pub const ImGuiTableColumnFlags_WidthMask_: ImGuiTableColumnFlags_ = 12;
pub const ImGuiTableColumnFlags_IndentMask_: ImGuiTableColumnFlags_ = 49152;
pub const ImGuiTableColumnFlags_StatusMask_: ImGuiTableColumnFlags_ = 15728640;
pub const ImGuiTableColumnFlags_NoDirectResize_: ImGuiTableColumnFlags_ = 1073741824;
pub type ImGuiTableColumnFlags_ = cty::c_uint;
pub const ImGuiTableRowFlags_None: ImGuiTableRowFlags_ = 0;
pub const ImGuiTableRowFlags_Headers: ImGuiTableRowFlags_ = 1;
pub type ImGuiTableRowFlags_ = cty::c_uint;
pub const ImGuiTableBgTarget_None: ImGuiTableBgTarget_ = 0;
pub const ImGuiTableBgTarget_RowBg0: ImGuiTableBgTarget_ = 1;
pub const ImGuiTableBgTarget_RowBg1: ImGuiTableBgTarget_ = 2;
pub const ImGuiTableBgTarget_CellBg: ImGuiTableBgTarget_ = 3;
pub type ImGuiTableBgTarget_ = cty::c_uint;
pub const ImGuiFocusedFlags_None: ImGuiFocusedFlags_ = 0;
pub const ImGuiFocusedFlags_ChildWindows: ImGuiFocusedFlags_ = 1;
pub const ImGuiFocusedFlags_RootWindow: ImGuiFocusedFlags_ = 2;
pub const ImGuiFocusedFlags_AnyWindow: ImGuiFocusedFlags_ = 4;
pub const ImGuiFocusedFlags_RootAndChildWindows: ImGuiFocusedFlags_ = 3;
pub type ImGuiFocusedFlags_ = cty::c_uint;
pub const ImGuiHoveredFlags_None: ImGuiHoveredFlags_ = 0;
pub const ImGuiHoveredFlags_ChildWindows: ImGuiHoveredFlags_ = 1;
pub const ImGuiHoveredFlags_RootWindow: ImGuiHoveredFlags_ = 2;
pub const ImGuiHoveredFlags_AnyWindow: ImGuiHoveredFlags_ = 4;
pub const ImGuiHoveredFlags_AllowWhenBlockedByPopup: ImGuiHoveredFlags_ = 8;
pub const ImGuiHoveredFlags_AllowWhenBlockedByActiveItem: ImGuiHoveredFlags_ = 32;
pub const ImGuiHoveredFlags_AllowWhenOverlapped: ImGuiHoveredFlags_ = 64;
pub const ImGuiHoveredFlags_AllowWhenDisabled: ImGuiHoveredFlags_ = 128;
pub const ImGuiHoveredFlags_RectOnly: ImGuiHoveredFlags_ = 104;
pub const ImGuiHoveredFlags_RootAndChildWindows: ImGuiHoveredFlags_ = 3;
pub type ImGuiHoveredFlags_ = cty::c_uint;
pub const ImGuiDragDropFlags_None: ImGuiDragDropFlags_ = 0;
pub const ImGuiDragDropFlags_SourceNoPreviewTooltip: ImGuiDragDropFlags_ = 1;
pub const ImGuiDragDropFlags_SourceNoDisableHover: ImGuiDragDropFlags_ = 2;
pub const ImGuiDragDropFlags_SourceNoHoldToOpenOthers: ImGuiDragDropFlags_ = 4;
pub const ImGuiDragDropFlags_SourceAllowNullID: ImGuiDragDropFlags_ = 8;
pub const ImGuiDragDropFlags_SourceExtern: ImGuiDragDropFlags_ = 16;
pub const ImGuiDragDropFlags_SourceAutoExpirePayload: ImGuiDragDropFlags_ = 32;
pub const ImGuiDragDropFlags_AcceptBeforeDelivery: ImGuiDragDropFlags_ = 1024;
pub const ImGuiDragDropFlags_AcceptNoDrawDefaultRect: ImGuiDragDropFlags_ = 2048;
pub const ImGuiDragDropFlags_AcceptNoPreviewTooltip: ImGuiDragDropFlags_ = 4096;
pub const ImGuiDragDropFlags_AcceptPeekOnly: ImGuiDragDropFlags_ = 3072;
pub type ImGuiDragDropFlags_ = cty::c_uint;
pub const ImGuiDataType_S8: ImGuiDataType_ = 0;
pub const ImGuiDataType_U8: ImGuiDataType_ = 1;
pub const ImGuiDataType_S16: ImGuiDataType_ = 2;
pub const ImGuiDataType_U16: ImGuiDataType_ = 3;
pub const ImGuiDataType_S32: ImGuiDataType_ = 4;
pub const ImGuiDataType_U32: ImGuiDataType_ = 5;
pub const ImGuiDataType_S64: ImGuiDataType_ = 6;
pub const ImGuiDataType_U64: ImGuiDataType_ = 7;
pub const ImGuiDataType_Float: ImGuiDataType_ = 8;
pub const ImGuiDataType_Double: ImGuiDataType_ = 9;
pub const ImGuiDataType_COUNT: ImGuiDataType_ = 10;
pub type ImGuiDataType_ = cty::c_uint;
pub const ImGuiDir_None: ImGuiDir_ = -1;
pub const ImGuiDir_Left: ImGuiDir_ = 0;
pub const ImGuiDir_Right: ImGuiDir_ = 1;
pub const ImGuiDir_Up: ImGuiDir_ = 2;
pub const ImGuiDir_Down: ImGuiDir_ = 3;
pub const ImGuiDir_COUNT: ImGuiDir_ = 4;
pub type ImGuiDir_ = cty::c_int;
pub const ImGuiSortDirection_None: ImGuiSortDirection_ = 0;
pub const ImGuiSortDirection_Ascending: ImGuiSortDirection_ = 1;
pub const ImGuiSortDirection_Descending: ImGuiSortDirection_ = 2;
pub type ImGuiSortDirection_ = cty::c_uint;
pub const ImGuiKey_Tab: ImGuiKey_ = 0;
pub const ImGuiKey_LeftArrow: ImGuiKey_ = 1;
pub const ImGuiKey_RightArrow: ImGuiKey_ = 2;
pub const ImGuiKey_UpArrow: ImGuiKey_ = 3;
pub const ImGuiKey_DownArrow: ImGuiKey_ = 4;
pub const ImGuiKey_PageUp: ImGuiKey_ = 5;
pub const ImGuiKey_PageDown: ImGuiKey_ = 6;
pub const ImGuiKey_Home: ImGuiKey_ = 7;
pub const ImGuiKey_End: ImGuiKey_ = 8;
pub const ImGuiKey_Insert: ImGuiKey_ = 9;
pub const ImGuiKey_Delete: ImGuiKey_ = 10;
pub const ImGuiKey_Backspace: ImGuiKey_ = 11;
pub const ImGuiKey_Space: ImGuiKey_ = 12;
pub const ImGuiKey_Enter: ImGuiKey_ = 13;
pub const ImGuiKey_Escape: ImGuiKey_ = 14;
pub const ImGuiKey_KeyPadEnter: ImGuiKey_ = 15;
pub const ImGuiKey_A: ImGuiKey_ = 16;
pub const ImGuiKey_C: ImGuiKey_ = 17;
pub const ImGuiKey_V: ImGuiKey_ = 18;
pub const ImGuiKey_X: ImGuiKey_ = 19;
pub const ImGuiKey_Y: ImGuiKey_ = 20;
pub const ImGuiKey_Z: ImGuiKey_ = 21;
pub const ImGuiKey_COUNT: ImGuiKey_ = 22;
pub type ImGuiKey_ = cty::c_uint;
pub const ImGuiKeyModFlags_None: ImGuiKeyModFlags_ = 0;
pub const ImGuiKeyModFlags_Ctrl: ImGuiKeyModFlags_ = 1;
pub const ImGuiKeyModFlags_Shift: ImGuiKeyModFlags_ = 2;
pub const ImGuiKeyModFlags_Alt: ImGuiKeyModFlags_ = 4;
pub const ImGuiKeyModFlags_Super: ImGuiKeyModFlags_ = 8;
pub type ImGuiKeyModFlags_ = cty::c_uint;
pub const ImGuiNavInput_Activate: ImGuiNavInput_ = 0;
pub const ImGuiNavInput_Cancel: ImGuiNavInput_ = 1;
pub const ImGuiNavInput_Input: ImGuiNavInput_ = 2;
pub const ImGuiNavInput_Menu: ImGuiNavInput_ = 3;
pub const ImGuiNavInput_DpadLeft: ImGuiNavInput_ = 4;
pub const ImGuiNavInput_DpadRight: ImGuiNavInput_ = 5;
pub const ImGuiNavInput_DpadUp: ImGuiNavInput_ = 6;
pub const ImGuiNavInput_DpadDown: ImGuiNavInput_ = 7;
pub const ImGuiNavInput_LStickLeft: ImGuiNavInput_ = 8;
pub const ImGuiNavInput_LStickRight: ImGuiNavInput_ = 9;
pub const ImGuiNavInput_LStickUp: ImGuiNavInput_ = 10;
pub const ImGuiNavInput_LStickDown: ImGuiNavInput_ = 11;
pub const ImGuiNavInput_FocusPrev: ImGuiNavInput_ = 12;
pub const ImGuiNavInput_FocusNext: ImGuiNavInput_ = 13;
pub const ImGuiNavInput_TweakSlow: ImGuiNavInput_ = 14;
pub const ImGuiNavInput_TweakFast: ImGuiNavInput_ = 15;
pub const ImGuiNavInput_KeyMenu_: ImGuiNavInput_ = 16;
pub const ImGuiNavInput_KeyLeft_: ImGuiNavInput_ = 17;
pub const ImGuiNavInput_KeyRight_: ImGuiNavInput_ = 18;
pub const ImGuiNavInput_KeyUp_: ImGuiNavInput_ = 19;
pub const ImGuiNavInput_KeyDown_: ImGuiNavInput_ = 20;
pub const ImGuiNavInput_COUNT: ImGuiNavInput_ = 21;
pub const ImGuiNavInput_InternalStart_: ImGuiNavInput_ = 16;
pub type ImGuiNavInput_ = cty::c_uint;
pub const ImGuiConfigFlags_None: ImGuiConfigFlags_ = 0;
pub const ImGuiConfigFlags_NavEnableKeyboard: ImGuiConfigFlags_ = 1;
pub const ImGuiConfigFlags_NavEnableGamepad: ImGuiConfigFlags_ = 2;
pub const ImGuiConfigFlags_NavEnableSetMousePos: ImGuiConfigFlags_ = 4;
pub const ImGuiConfigFlags_NavNoCaptureKeyboard: ImGuiConfigFlags_ = 8;
pub const ImGuiConfigFlags_NoMouse: ImGuiConfigFlags_ = 16;
pub const ImGuiConfigFlags_NoMouseCursorChange: ImGuiConfigFlags_ = 32;
pub const ImGuiConfigFlags_IsSRGB: ImGuiConfigFlags_ = 1048576;
pub const ImGuiConfigFlags_IsTouchScreen: ImGuiConfigFlags_ = 2097152;
pub type ImGuiConfigFlags_ = cty::c_uint;
pub const ImGuiBackendFlags_None: ImGuiBackendFlags_ = 0;
pub const ImGuiBackendFlags_HasGamepad: ImGuiBackendFlags_ = 1;
pub const ImGuiBackendFlags_HasMouseCursors: ImGuiBackendFlags_ = 2;
pub const ImGuiBackendFlags_HasSetMousePos: ImGuiBackendFlags_ = 4;
pub const ImGuiBackendFlags_RendererHasVtxOffset: ImGuiBackendFlags_ = 8;
pub type ImGuiBackendFlags_ = cty::c_uint;
pub const ImGuiCol_Text: ImGuiCol_ = 0;
pub const ImGuiCol_TextDisabled: ImGuiCol_ = 1;
pub const ImGuiCol_WindowBg: ImGuiCol_ = 2;
pub const ImGuiCol_ChildBg: ImGuiCol_ = 3;
pub const ImGuiCol_PopupBg: ImGuiCol_ = 4;
pub const ImGuiCol_Border: ImGuiCol_ = 5;
pub const ImGuiCol_BorderShadow: ImGuiCol_ = 6;
pub const ImGuiCol_FrameBg: ImGuiCol_ = 7;
pub const ImGuiCol_FrameBgHovered: ImGuiCol_ = 8;
pub const ImGuiCol_FrameBgActive: ImGuiCol_ = 9;
pub const ImGuiCol_TitleBg: ImGuiCol_ = 10;
pub const ImGuiCol_TitleBgActive: ImGuiCol_ = 11;
pub const ImGuiCol_TitleBgCollapsed: ImGuiCol_ = 12;
pub const ImGuiCol_MenuBarBg: ImGuiCol_ = 13;
pub const ImGuiCol_ScrollbarBg: ImGuiCol_ = 14;
pub const ImGuiCol_ScrollbarGrab: ImGuiCol_ = 15;
pub const ImGuiCol_ScrollbarGrabHovered: ImGuiCol_ = 16;
pub const ImGuiCol_ScrollbarGrabActive: ImGuiCol_ = 17;
pub const ImGuiCol_CheckMark: ImGuiCol_ = 18;
pub const ImGuiCol_SliderGrab: ImGuiCol_ = 19;
pub const ImGuiCol_SliderGrabActive: ImGuiCol_ = 20;
pub const ImGuiCol_Button: ImGuiCol_ = 21;
pub const ImGuiCol_ButtonHovered: ImGuiCol_ = 22;
pub const ImGuiCol_ButtonActive: ImGuiCol_ = 23;
pub const ImGuiCol_Header: ImGuiCol_ = 24;
pub const ImGuiCol_HeaderHovered: ImGuiCol_ = 25;
pub const ImGuiCol_HeaderActive: ImGuiCol_ = 26;
pub const ImGuiCol_Separator: ImGuiCol_ = 27;
pub const ImGuiCol_SeparatorHovered: ImGuiCol_ = 28;
pub const ImGuiCol_SeparatorActive: ImGuiCol_ = 29;
pub const ImGuiCol_ResizeGrip: ImGuiCol_ = 30;
pub const ImGuiCol_ResizeGripHovered: ImGuiCol_ = 31;
pub const ImGuiCol_ResizeGripActive: ImGuiCol_ = 32;
pub const ImGuiCol_Tab: ImGuiCol_ = 33;
pub const ImGuiCol_TabHovered: ImGuiCol_ = 34;
pub const ImGuiCol_TabActive: ImGuiCol_ = 35;
pub const ImGuiCol_TabUnfocused: ImGuiCol_ = 36;
pub const ImGuiCol_TabUnfocusedActive: ImGuiCol_ = 37;
pub const ImGuiCol_PlotLines: ImGuiCol_ = 38;
pub const ImGuiCol_PlotLinesHovered: ImGuiCol_ = 39;
pub const ImGuiCol_PlotHistogram: ImGuiCol_ = 40;
pub const ImGuiCol_PlotHistogramHovered: ImGuiCol_ = 41;
pub const ImGuiCol_TableHeaderBg: ImGuiCol_ = 42;
pub const ImGuiCol_TableBorderStrong: ImGuiCol_ = 43;
pub const ImGuiCol_TableBorderLight: ImGuiCol_ = 44;
pub const ImGuiCol_TableRowBg: ImGuiCol_ = 45;
pub const ImGuiCol_TableRowBgAlt: ImGuiCol_ = 46;
pub const ImGuiCol_TextSelectedBg: ImGuiCol_ = 47;
pub const ImGuiCol_DragDropTarget: ImGuiCol_ = 48;
pub const ImGuiCol_NavHighlight: ImGuiCol_ = 49;
pub const ImGuiCol_NavWindowingHighlight: ImGuiCol_ = 50;
pub const ImGuiCol_NavWindowingDimBg: ImGuiCol_ = 51;
pub const ImGuiCol_ModalWindowDimBg: ImGuiCol_ = 52;
pub const ImGuiCol_COUNT: ImGuiCol_ = 53;
pub type ImGuiCol_ = cty::c_uint;
pub const ImGuiStyleVar_Alpha: ImGuiStyleVar_ = 0;
pub const ImGuiStyleVar_WindowPadding: ImGuiStyleVar_ = 1;
pub const ImGuiStyleVar_WindowRounding: ImGuiStyleVar_ = 2;
pub const ImGuiStyleVar_WindowBorderSize: ImGuiStyleVar_ = 3;
pub const ImGuiStyleVar_WindowMinSize: ImGuiStyleVar_ = 4;
pub const ImGuiStyleVar_WindowTitleAlign: ImGuiStyleVar_ = 5;
pub const ImGuiStyleVar_ChildRounding: ImGuiStyleVar_ = 6;
pub const ImGuiStyleVar_ChildBorderSize: ImGuiStyleVar_ = 7;
pub const ImGuiStyleVar_PopupRounding: ImGuiStyleVar_ = 8;
pub const ImGuiStyleVar_PopupBorderSize: ImGuiStyleVar_ = 9;
pub const ImGuiStyleVar_FramePadding: ImGuiStyleVar_ = 10;
pub const ImGuiStyleVar_FrameRounding: ImGuiStyleVar_ = 11;
pub const ImGuiStyleVar_FrameBorderSize: ImGuiStyleVar_ = 12;
pub const ImGuiStyleVar_ItemSpacing: ImGuiStyleVar_ = 13;
pub const ImGuiStyleVar_ItemInnerSpacing: ImGuiStyleVar_ = 14;
pub const ImGuiStyleVar_IndentSpacing: ImGuiStyleVar_ = 15;
pub const ImGuiStyleVar_CellPadding: ImGuiStyleVar_ = 16;
pub const ImGuiStyleVar_ScrollbarSize: ImGuiStyleVar_ = 17;
pub const ImGuiStyleVar_ScrollbarRounding: ImGuiStyleVar_ = 18;
pub const ImGuiStyleVar_GrabMinSize: ImGuiStyleVar_ = 19;
pub const ImGuiStyleVar_GrabRounding: ImGuiStyleVar_ = 20;
pub const ImGuiStyleVar_TabRounding: ImGuiStyleVar_ = 21;
pub const ImGuiStyleVar_ButtonTextAlign: ImGuiStyleVar_ = 22;
pub const ImGuiStyleVar_SelectableTextAlign: ImGuiStyleVar_ = 23;
pub const ImGuiStyleVar_COUNT: ImGuiStyleVar_ = 24;
pub type ImGuiStyleVar_ = cty::c_uint;
pub const ImGuiButtonFlags_None: ImGuiButtonFlags_ = 0;
pub const ImGuiButtonFlags_MouseButtonLeft: ImGuiButtonFlags_ = 1;
pub const ImGuiButtonFlags_MouseButtonRight: ImGuiButtonFlags_ = 2;
pub const ImGuiButtonFlags_MouseButtonMiddle: ImGuiButtonFlags_ = 4;
pub const ImGuiButtonFlags_MouseButtonMask_: ImGuiButtonFlags_ = 7;
pub const ImGuiButtonFlags_MouseButtonDefault_: ImGuiButtonFlags_ = 1;
pub type ImGuiButtonFlags_ = cty::c_uint;
pub const ImGuiColorEditFlags_None: ImGuiColorEditFlags_ = 0;
pub const ImGuiColorEditFlags_NoAlpha: ImGuiColorEditFlags_ = 2;
pub const ImGuiColorEditFlags_NoPicker: ImGuiColorEditFlags_ = 4;
pub const ImGuiColorEditFlags_NoOptions: ImGuiColorEditFlags_ = 8;
pub const ImGuiColorEditFlags_NoSmallPreview: ImGuiColorEditFlags_ = 16;
pub const ImGuiColorEditFlags_NoInputs: ImGuiColorEditFlags_ = 32;
pub const ImGuiColorEditFlags_NoTooltip: ImGuiColorEditFlags_ = 64;
pub const ImGuiColorEditFlags_NoLabel: ImGuiColorEditFlags_ = 128;
pub const ImGuiColorEditFlags_NoSidePreview: ImGuiColorEditFlags_ = 256;
pub const ImGuiColorEditFlags_NoDragDrop: ImGuiColorEditFlags_ = 512;
pub const ImGuiColorEditFlags_NoBorder: ImGuiColorEditFlags_ = 1024;
pub const ImGuiColorEditFlags_AlphaBar: ImGuiColorEditFlags_ = 65536;
pub const ImGuiColorEditFlags_AlphaPreview: ImGuiColorEditFlags_ = 131072;
pub const ImGuiColorEditFlags_AlphaPreviewHalf: ImGuiColorEditFlags_ = 262144;
pub const ImGuiColorEditFlags_HDR: ImGuiColorEditFlags_ = 524288;
pub const ImGuiColorEditFlags_DisplayRGB: ImGuiColorEditFlags_ = 1048576;
pub const ImGuiColorEditFlags_DisplayHSV: ImGuiColorEditFlags_ = 2097152;
pub const ImGuiColorEditFlags_DisplayHex: ImGuiColorEditFlags_ = 4194304;
pub const ImGuiColorEditFlags_Uint8: ImGuiColorEditFlags_ = 8388608;
pub const ImGuiColorEditFlags_Float: ImGuiColorEditFlags_ = 16777216;
pub const ImGuiColorEditFlags_PickerHueBar: ImGuiColorEditFlags_ = 33554432;
pub const ImGuiColorEditFlags_PickerHueWheel: ImGuiColorEditFlags_ = 67108864;
pub const ImGuiColorEditFlags_InputRGB: ImGuiColorEditFlags_ = 134217728;
pub const ImGuiColorEditFlags_InputHSV: ImGuiColorEditFlags_ = 268435456;
pub const ImGuiColorEditFlags__OptionsDefault: ImGuiColorEditFlags_ = 177209344;
pub const ImGuiColorEditFlags__DisplayMask: ImGuiColorEditFlags_ = 7340032;
pub const ImGuiColorEditFlags__DataTypeMask: ImGuiColorEditFlags_ = 25165824;
pub const ImGuiColorEditFlags__PickerMask: ImGuiColorEditFlags_ = 100663296;
pub const ImGuiColorEditFlags__InputMask: ImGuiColorEditFlags_ = 402653184;
pub type ImGuiColorEditFlags_ = cty::c_uint;
pub const ImGuiSliderFlags_None: ImGuiSliderFlags_ = 0;
pub const ImGuiSliderFlags_AlwaysClamp: ImGuiSliderFlags_ = 16;
pub const ImGuiSliderFlags_Logarithmic: ImGuiSliderFlags_ = 32;
pub const ImGuiSliderFlags_NoRoundToFormat: ImGuiSliderFlags_ = 64;
pub const ImGuiSliderFlags_NoInput: ImGuiSliderFlags_ = 128;
pub const ImGuiSliderFlags_InvalidMask_: ImGuiSliderFlags_ = 1879048207;
pub type ImGuiSliderFlags_ = cty::c_uint;
pub const ImGuiMouseButton_Left: ImGuiMouseButton_ = 0;
pub const ImGuiMouseButton_Right: ImGuiMouseButton_ = 1;
pub const ImGuiMouseButton_Middle: ImGuiMouseButton_ = 2;
pub const ImGuiMouseButton_COUNT: ImGuiMouseButton_ = 5;
pub type ImGuiMouseButton_ = cty::c_uint;
pub const ImGuiMouseCursor_None: ImGuiMouseCursor_ = -1;
pub const ImGuiMouseCursor_Arrow: ImGuiMouseCursor_ = 0;
pub const ImGuiMouseCursor_TextInput: ImGuiMouseCursor_ = 1;
pub const ImGuiMouseCursor_ResizeAll: ImGuiMouseCursor_ = 2;
pub const ImGuiMouseCursor_ResizeNS: ImGuiMouseCursor_ = 3;
pub const ImGuiMouseCursor_ResizeEW: ImGuiMouseCursor_ = 4;
pub const ImGuiMouseCursor_ResizeNESW: ImGuiMouseCursor_ = 5;
pub const ImGuiMouseCursor_ResizeNWSE: ImGuiMouseCursor_ = 6;
pub const ImGuiMouseCursor_Hand: ImGuiMouseCursor_ = 7;
pub const ImGuiMouseCursor_NotAllowed: ImGuiMouseCursor_ = 8;
pub const ImGuiMouseCursor_COUNT: ImGuiMouseCursor_ = 9;
pub type ImGuiMouseCursor_ = cty::c_int;
pub const ImGuiCond_None: ImGuiCond_ = 0;
pub const ImGuiCond_Always: ImGuiCond_ = 1;
pub const ImGuiCond_Once: ImGuiCond_ = 2;
pub const ImGuiCond_FirstUseEver: ImGuiCond_ = 4;
pub const ImGuiCond_Appearing: ImGuiCond_ = 8;
pub type ImGuiCond_ = cty::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImGuiStyle {
    pub Alpha: f32,
    pub WindowPadding: ImVec2,
    pub WindowRounding: f32,
    pub WindowBorderSize: f32,
    pub WindowMinSize: ImVec2,
    pub WindowTitleAlign: ImVec2,
    pub WindowMenuButtonPosition: ImGuiDir,
    pub ChildRounding: f32,
    pub ChildBorderSize: f32,
    pub PopupRounding: f32,
    pub PopupBorderSize: f32,
    pub FramePadding: ImVec2,
    pub FrameRounding: f32,
    pub FrameBorderSize: f32,
    pub ItemSpacing: ImVec2,
    pub ItemInnerSpacing: ImVec2,
    pub CellPadding: ImVec2,
    pub TouchExtraPadding: ImVec2,
    pub IndentSpacing: f32,
    pub ColumnsMinSpacing: f32,
    pub ScrollbarSize: f32,
    pub ScrollbarRounding: f32,
    pub GrabMinSize: f32,
    pub GrabRounding: f32,
    pub LogSliderDeadzone: f32,
    pub TabRounding: f32,
    pub TabBorderSize: f32,
    pub TabMinWidthForCloseButton: f32,
    pub ColorButtonPosition: ImGuiDir,
    pub ButtonTextAlign: ImVec2,
    pub SelectableTextAlign: ImVec2,
    pub DisplayWindowPadding: ImVec2,
    pub DisplaySafeAreaPadding: ImVec2,
    pub MouseCursorScale: f32,
    pub AntiAliasedLines: bool,
    pub AntiAliasedLinesUseTex: bool,
    pub AntiAliasedFill: bool,
    pub CurveTessellationTol: f32,
    pub CircleTessellationMaxError: f32,
    pub Colors: [ImVec4; 53usize],
}
impl Default for ImGuiStyle {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for ImGuiStyle {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write ! (f , "ImGuiStyle {{ Alpha: {:?}, WindowPadding: {:?}, WindowRounding: {:?}, WindowBorderSize: {:?}, WindowMinSize: {:?}, WindowTitleAlign: {:?}, WindowMenuButtonPosition: {:?}, ChildRounding: {:?}, ChildBorderSize: {:?}, PopupRounding: {:?}, PopupBorderSize: {:?}, FramePadding: {:?}, FrameRounding: {:?}, FrameBorderSize: {:?}, ItemSpacing: {:?}, ItemInnerSpacing: {:?}, CellPadding: {:?}, TouchExtraPadding: {:?}, IndentSpacing: {:?}, ColumnsMinSpacing: {:?}, ScrollbarSize: {:?}, ScrollbarRounding: {:?}, GrabMinSize: {:?}, GrabRounding: {:?}, LogSliderDeadzone: {:?}, TabRounding: {:?}, TabBorderSize: {:?}, TabMinWidthForCloseButton: {:?}, ColorButtonPosition: {:?}, ButtonTextAlign: {:?}, SelectableTextAlign: {:?}, DisplayWindowPadding: {:?}, DisplaySafeAreaPadding: {:?}, MouseCursorScale: {:?}, AntiAliasedLines: {:?}, AntiAliasedLinesUseTex: {:?}, AntiAliasedFill: {:?}, CurveTessellationTol: {:?}, CircleTessellationMaxError: {:?}, Colors: [...] }}" , self . Alpha , self . WindowPadding , self . WindowRounding , self . WindowBorderSize , self . WindowMinSize , self . WindowTitleAlign , self . WindowMenuButtonPosition , self . ChildRounding , self . ChildBorderSize , self . PopupRounding , self . PopupBorderSize , self . FramePadding , self . FrameRounding , self . FrameBorderSize , self . ItemSpacing , self . ItemInnerSpacing , self . CellPadding , self . TouchExtraPadding , self . IndentSpacing , self . ColumnsMinSpacing , self . ScrollbarSize , self . ScrollbarRounding , self . GrabMinSize , self . GrabRounding , self . LogSliderDeadzone , self . TabRounding , self . TabBorderSize , self . TabMinWidthForCloseButton , self . ColorButtonPosition , self . ButtonTextAlign , self . SelectableTextAlign , self . DisplayWindowPadding , self . DisplaySafeAreaPadding , self . MouseCursorScale , self . AntiAliasedLines , self . AntiAliasedLinesUseTex , self . AntiAliasedFill , self . CurveTessellationTol , self . CircleTessellationMaxError)
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImGuiIO {
    pub ConfigFlags: ImGuiConfigFlags,
    pub BackendFlags: ImGuiBackendFlags,
    pub DisplaySize: ImVec2,
    pub DeltaTime: f32,
    pub IniSavingRate: f32,
    pub IniFilename: *const cty::c_char,
    pub LogFilename: *const cty::c_char,
    pub MouseDoubleClickTime: f32,
    pub MouseDoubleClickMaxDist: f32,
    pub MouseDragThreshold: f32,
    pub KeyMap: [cty::c_int; 22usize],
    pub KeyRepeatDelay: f32,
    pub KeyRepeatRate: f32,
    pub UserData: *mut cty::c_void,
    pub Fonts: *mut ImFontAtlas,
    pub FontGlobalScale: f32,
    pub FontAllowUserScaling: bool,
    pub FontDefault: *mut ImFont,
    pub DisplayFramebufferScale: ImVec2,
    pub MouseDrawCursor: bool,
    pub ConfigMacOSXBehaviors: bool,
    pub ConfigInputTextCursorBlink: bool,
    pub ConfigDragClickToInputText: bool,
    pub ConfigWindowsResizeFromEdges: bool,
    pub ConfigWindowsMoveFromTitleBarOnly: bool,
    pub ConfigMemoryCompactTimer: f32,
    pub BackendPlatformName: *const cty::c_char,
    pub BackendRendererName: *const cty::c_char,
    pub BackendPlatformUserData: *mut cty::c_void,
    pub BackendRendererUserData: *mut cty::c_void,
    pub BackendLanguageUserData: *mut cty::c_void,
    pub GetClipboardTextFn: ::core::option::Option<
        unsafe extern "C" fn(user_data: *mut cty::c_void) -> *const cty::c_char,
    >,
    pub SetClipboardTextFn: ::core::option::Option<
        unsafe extern "C" fn(user_data: *mut cty::c_void, text: *const cty::c_char),
    >,
    pub ClipboardUserData: *mut cty::c_void,
    pub ImeSetInputScreenPosFn:
        ::core::option::Option<unsafe extern "C" fn(x: cty::c_int, y: cty::c_int)>,
    pub ImeWindowHandle: *mut cty::c_void,
    pub MousePos: ImVec2,
    pub MouseDown: [bool; 5usize],
    pub MouseWheel: f32,
    pub MouseWheelH: f32,
    pub KeyCtrl: bool,
    pub KeyShift: bool,
    pub KeyAlt: bool,
    pub KeySuper: bool,
    pub KeysDown: [bool; 512usize],
    pub NavInputs: [f32; 21usize],
    pub WantCaptureMouse: bool,
    pub WantCaptureKeyboard: bool,
    pub WantTextInput: bool,
    pub WantSetMousePos: bool,
    pub WantSaveIniSettings: bool,
    pub NavActive: bool,
    pub NavVisible: bool,
    pub Framerate: f32,
    pub MetricsRenderVertices: cty::c_int,
    pub MetricsRenderIndices: cty::c_int,
    pub MetricsRenderWindows: cty::c_int,
    pub MetricsActiveWindows: cty::c_int,
    pub MetricsActiveAllocations: cty::c_int,
    pub MouseDelta: ImVec2,
    pub KeyMods: ImGuiKeyModFlags,
    pub MousePosPrev: ImVec2,
    pub MouseClickedPos: [ImVec2; 5usize],
    pub MouseClickedTime: [f64; 5usize],
    pub MouseClicked: [bool; 5usize],
    pub MouseDoubleClicked: [bool; 5usize],
    pub MouseReleased: [bool; 5usize],
    pub MouseDownOwned: [bool; 5usize],
    pub MouseDownWasDoubleClick: [bool; 5usize],
    pub MouseDownDuration: [f32; 5usize],
    pub MouseDownDurationPrev: [f32; 5usize],
    pub MouseDragMaxDistanceAbs: [ImVec2; 5usize],
    pub MouseDragMaxDistanceSqr: [f32; 5usize],
    pub KeysDownDuration: [f32; 512usize],
    pub KeysDownDurationPrev: [f32; 512usize],
    pub NavInputsDownDuration: [f32; 21usize],
    pub NavInputsDownDurationPrev: [f32; 21usize],
    pub PenPressure: f32,
    pub InputQueueSurrogate: ImWchar16,
    pub InputQueueCharacters: ImVector_ImWchar,
}
impl Default for ImGuiIO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for ImGuiIO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write ! (f , "ImGuiIO {{ ConfigFlags: {:?}, BackendFlags: {:?}, DisplaySize: {:?}, DeltaTime: {:?}, IniSavingRate: {:?}, IniFilename: {:?}, LogFilename: {:?}, MouseDoubleClickTime: {:?}, MouseDoubleClickMaxDist: {:?}, MouseDragThreshold: {:?}, KeyMap: {:?}, KeyRepeatDelay: {:?}, KeyRepeatRate: {:?}, UserData: {:?}, Fonts: {:?}, FontGlobalScale: {:?}, FontAllowUserScaling: {:?}, FontDefault: {:?}, DisplayFramebufferScale: {:?}, MouseDrawCursor: {:?}, ConfigMacOSXBehaviors: {:?}, ConfigInputTextCursorBlink: {:?}, ConfigDragClickToInputText: {:?}, ConfigWindowsResizeFromEdges: {:?}, ConfigWindowsMoveFromTitleBarOnly: {:?}, ConfigMemoryCompactTimer: {:?}, BackendPlatformName: {:?}, BackendRendererName: {:?}, BackendPlatformUserData: {:?}, BackendRendererUserData: {:?}, BackendLanguageUserData: {:?}, GetClipboardTextFn: {:?}, SetClipboardTextFn: {:?}, ClipboardUserData: {:?}, ImeSetInputScreenPosFn: {:?}, ImeWindowHandle: {:?}, MousePos: {:?}, MouseDown: {:?}, MouseWheel: {:?}, MouseWheelH: {:?}, KeyCtrl: {:?}, KeyShift: {:?}, KeyAlt: {:?}, KeySuper: {:?}, KeysDown: [...], NavInputs: {:?}, WantCaptureMouse: {:?}, WantCaptureKeyboard: {:?}, WantTextInput: {:?}, WantSetMousePos: {:?}, WantSaveIniSettings: {:?}, NavActive: {:?}, NavVisible: {:?}, Framerate: {:?}, MetricsRenderVertices: {:?}, MetricsRenderIndices: {:?}, MetricsRenderWindows: {:?}, MetricsActiveWindows: {:?}, MetricsActiveAllocations: {:?}, MouseDelta: {:?}, KeyMods: {:?}, MousePosPrev: {:?}, MouseClickedPos: {:?}, MouseClickedTime: {:?}, MouseClicked: {:?}, MouseDoubleClicked: {:?}, MouseReleased: {:?}, MouseDownOwned: {:?}, MouseDownWasDoubleClick: {:?}, MouseDownDuration: {:?}, MouseDownDurationPrev: {:?}, MouseDragMaxDistanceAbs: {:?}, MouseDragMaxDistanceSqr: {:?}, KeysDownDuration: [...], KeysDownDurationPrev: [...], NavInputsDownDuration: {:?}, NavInputsDownDurationPrev: {:?}, PenPressure: {:?}, InputQueueSurrogate: {:?}, InputQueueCharacters: {:?} }}" , self . ConfigFlags , self . BackendFlags , self . DisplaySize , self . DeltaTime , self . IniSavingRate , self . IniFilename , self . LogFilename , self . MouseDoubleClickTime , self . MouseDoubleClickMaxDist , self . MouseDragThreshold , self . KeyMap , self . KeyRepeatDelay , self . KeyRepeatRate , self . UserData , self . Fonts , self . FontGlobalScale , self . FontAllowUserScaling , self . FontDefault , self . DisplayFramebufferScale , self . MouseDrawCursor , self . ConfigMacOSXBehaviors , self . ConfigInputTextCursorBlink , self . ConfigDragClickToInputText , self . ConfigWindowsResizeFromEdges , self . ConfigWindowsMoveFromTitleBarOnly , self . ConfigMemoryCompactTimer , self . BackendPlatformName , self . BackendRendererName , self . BackendPlatformUserData , self . BackendRendererUserData , self . BackendLanguageUserData , self . GetClipboardTextFn , self . SetClipboardTextFn , self . ClipboardUserData , self . ImeSetInputScreenPosFn , self . ImeWindowHandle , self . MousePos , self . MouseDown , self . MouseWheel , self . MouseWheelH , self . KeyCtrl , self . KeyShift , self . KeyAlt , self . KeySuper , self . NavInputs , self . WantCaptureMouse , self . WantCaptureKeyboard , self . WantTextInput , self . WantSetMousePos , self . WantSaveIniSettings , self . NavActive , self . NavVisible , self . Framerate , self . MetricsRenderVertices , self . MetricsRenderIndices , self . MetricsRenderWindows , self . MetricsActiveWindows , self . MetricsActiveAllocations , self . MouseDelta , self . KeyMods , self . MousePosPrev , self . MouseClickedPos , self . MouseClickedTime , self . MouseClicked , self . MouseDoubleClicked , self . MouseReleased , self . MouseDownOwned , self . MouseDownWasDoubleClick , self . MouseDownDuration , self . MouseDownDurationPrev , self . MouseDragMaxDistanceAbs , self . MouseDragMaxDistanceSqr , self . NavInputsDownDuration , self . NavInputsDownDurationPrev , self . PenPressure , self . InputQueueSurrogate , self . InputQueueCharacters)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiInputTextCallbackData {
    pub EventFlag: ImGuiInputTextFlags,
    pub Flags: ImGuiInputTextFlags,
    pub UserData: *mut cty::c_void,
    pub EventChar: ImWchar,
    pub EventKey: ImGuiKey,
    pub Buf: *mut cty::c_char,
    pub BufTextLen: cty::c_int,
    pub BufSize: cty::c_int,
    pub BufDirty: bool,
    pub CursorPos: cty::c_int,
    pub SelectionStart: cty::c_int,
    pub SelectionEnd: cty::c_int,
}
impl Default for ImGuiInputTextCallbackData {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImGuiSizeCallbackData {
    pub UserData: *mut cty::c_void,
    pub Pos: ImVec2,
    pub CurrentSize: ImVec2,
    pub DesiredSize: ImVec2,
}
impl Default for ImGuiSizeCallbackData {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImGuiPayload {
    pub Data: *mut cty::c_void,
    pub DataSize: cty::c_int,
    pub SourceId: ImGuiID,
    pub SourceParentId: ImGuiID,
    pub DataFrameCount: cty::c_int,
    pub DataType: [cty::c_char; 33usize],
    pub Preview: bool,
    pub Delivery: bool,
}
impl Default for ImGuiPayload {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for ImGuiPayload {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write ! (f , "ImGuiPayload {{ Data: {:?}, DataSize: {:?}, SourceId: {:?}, SourceParentId: {:?}, DataFrameCount: {:?}, DataType: [...], Preview: {:?}, Delivery: {:?} }}" , self . Data , self . DataSize , self . SourceId , self . SourceParentId , self . DataFrameCount , self . Preview , self . Delivery)
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiTableColumnSortSpecs {
    pub ColumnUserID: ImGuiID,
    pub ColumnIndex: ImS16,
    pub SortOrder: ImS16,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
impl ImGuiTableColumnSortSpecs {
    #[inline]
    pub fn SortDirection(&self) -> ImGuiSortDirection {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_SortDirection(&mut self, val: ImGuiSortDirection) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        SortDirection: ImGuiSortDirection,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let SortDirection: u32 = unsafe { ::core::mem::transmute(SortDirection) };
            SortDirection as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiTableSortSpecs {
    pub Specs: *const ImGuiTableColumnSortSpecs,
    pub SpecsCount: cty::c_int,
    pub SpecsDirty: bool,
}
impl Default for ImGuiTableSortSpecs {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiOnceUponAFrame {
    pub RefFrame: cty::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiTextRange {
    pub b: *const cty::c_char,
    pub e: *const cty::c_char,
}
impl Default for ImGuiTextRange {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImGuiTextFilter {
    pub InputBuf: [cty::c_char; 256usize],
    pub Filters: ImVector_ImGuiTextRange,
    pub CountGrep: cty::c_int,
}
impl Default for ImGuiTextFilter {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for ImGuiTextFilter {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "ImGuiTextFilter {{ InputBuf: [...], Filters: {:?}, CountGrep: {:?} }}",
            self.Filters, self.CountGrep
        )
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiTextBuffer {
    pub Buf: ImVector_char,
}
impl Default for ImGuiTextBuffer {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImGuiStoragePair {
    pub key: ImGuiID,
    pub __bindgen_anon_1: ImGuiStoragePair__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union ImGuiStoragePair__bindgen_ty_1 {
    pub val_i: cty::c_int,
    pub val_f: f32,
    pub val_p: *mut cty::c_void,
}
impl Default for ImGuiStoragePair__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for ImGuiStoragePair__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "ImGuiStoragePair__bindgen_ty_1 {{ union }}")
    }
}
impl Default for ImGuiStoragePair {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for ImGuiStoragePair {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "ImGuiStoragePair {{ key: {:?}, __bindgen_anon_1: {:?} }}",
            self.key, self.__bindgen_anon_1
        )
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiStorage {
    pub Data: ImVector_ImGuiStoragePair,
}
impl Default for ImGuiStorage {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImGuiListClipper {
    pub DisplayStart: cty::c_int,
    pub DisplayEnd: cty::c_int,
    pub ItemsCount: cty::c_int,
    pub StepNo: cty::c_int,
    pub ItemsFrozen: cty::c_int,
    pub ItemsHeight: f32,
    pub StartPosY: f32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImColor {
    pub Value: ImVec4,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImDrawCmd {
    pub ClipRect: ImVec4,
    pub TextureId: ImTextureID,
    pub VtxOffset: cty::c_uint,
    pub IdxOffset: cty::c_uint,
    pub ElemCount: cty::c_uint,
    pub UserCallback: ImDrawCallback,
    pub UserCallbackData: *mut cty::c_void,
}
impl Default for ImDrawCmd {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImDrawVert {
    pub pos: ImVec2,
    pub uv: ImVec2,
    pub col: ImU32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImDrawCmdHeader {
    pub ClipRect: ImVec4,
    pub TextureId: ImTextureID,
    pub VtxOffset: cty::c_uint,
}
impl Default for ImDrawCmdHeader {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImDrawChannel {
    pub _CmdBuffer: ImVector_ImDrawCmd,
    pub _IdxBuffer: ImVector_ImDrawIdx,
}
impl Default for ImDrawChannel {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImDrawListSplitter {
    pub _Current: cty::c_int,
    pub _Count: cty::c_int,
    pub _Channels: ImVector_ImDrawChannel,
}
impl Default for ImDrawListSplitter {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
pub const ImDrawFlags_None: ImDrawFlags_ = 0;
pub const ImDrawFlags_Closed: ImDrawFlags_ = 1;
pub const ImDrawFlags_RoundCornersTopLeft: ImDrawFlags_ = 16;
pub const ImDrawFlags_RoundCornersTopRight: ImDrawFlags_ = 32;
pub const ImDrawFlags_RoundCornersBottomLeft: ImDrawFlags_ = 64;
pub const ImDrawFlags_RoundCornersBottomRight: ImDrawFlags_ = 128;
pub const ImDrawFlags_RoundCornersNone: ImDrawFlags_ = 256;
pub const ImDrawFlags_RoundCornersTop: ImDrawFlags_ = 48;
pub const ImDrawFlags_RoundCornersBottom: ImDrawFlags_ = 192;
pub const ImDrawFlags_RoundCornersLeft: ImDrawFlags_ = 80;
pub const ImDrawFlags_RoundCornersRight: ImDrawFlags_ = 160;
pub const ImDrawFlags_RoundCornersAll: ImDrawFlags_ = 240;
pub const ImDrawFlags_RoundCornersDefault_: ImDrawFlags_ = 240;
pub const ImDrawFlags_RoundCornersMask_: ImDrawFlags_ = 496;
pub type ImDrawFlags_ = cty::c_uint;
pub const ImDrawListFlags_None: ImDrawListFlags_ = 0;
pub const ImDrawListFlags_AntiAliasedLines: ImDrawListFlags_ = 1;
pub const ImDrawListFlags_AntiAliasedLinesUseTex: ImDrawListFlags_ = 2;
pub const ImDrawListFlags_AntiAliasedFill: ImDrawListFlags_ = 4;
pub const ImDrawListFlags_AllowVtxOffset: ImDrawListFlags_ = 8;
pub type ImDrawListFlags_ = cty::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImDrawList {
    pub CmdBuffer: ImVector_ImDrawCmd,
    pub IdxBuffer: ImVector_ImDrawIdx,
    pub VtxBuffer: ImVector_ImDrawVert,
    pub Flags: ImDrawListFlags,
    pub _VtxCurrentIdx: cty::c_uint,
    pub _Data: *const ImDrawListSharedData,
    pub _OwnerName: *const cty::c_char,
    pub _VtxWritePtr: *mut ImDrawVert,
    pub _IdxWritePtr: *mut ImDrawIdx,
    pub _ClipRectStack: ImVector_ImVec4,
    pub _TextureIdStack: ImVector_ImTextureID,
    pub _Path: ImVector_ImVec2,
    pub _CmdHeader: ImDrawCmdHeader,
    pub _Splitter: ImDrawListSplitter,
    pub _FringeScale: f32,
}
impl Default for ImDrawList {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImDrawData {
    pub Valid: bool,
    pub CmdListsCount: cty::c_int,
    pub TotalIdxCount: cty::c_int,
    pub TotalVtxCount: cty::c_int,
    pub CmdLists: *mut *mut ImDrawList,
    pub DisplayPos: ImVec2,
    pub DisplaySize: ImVec2,
    pub FramebufferScale: ImVec2,
}
impl Default for ImDrawData {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImFontConfig {
    pub FontData: *mut cty::c_void,
    pub FontDataSize: cty::c_int,
    pub FontDataOwnedByAtlas: bool,
    pub FontNo: cty::c_int,
    pub SizePixels: f32,
    pub OversampleH: cty::c_int,
    pub OversampleV: cty::c_int,
    pub PixelSnapH: bool,
    pub GlyphExtraSpacing: ImVec2,
    pub GlyphOffset: ImVec2,
    pub GlyphRanges: *const ImWchar,
    pub GlyphMinAdvanceX: f32,
    pub GlyphMaxAdvanceX: f32,
    pub MergeMode: bool,
    pub FontBuilderFlags: cty::c_uint,
    pub RasterizerMultiply: f32,
    pub EllipsisChar: ImWchar,
    pub Name: [cty::c_char; 40usize],
    pub DstFont: *mut ImFont,
}
impl Default for ImFontConfig {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for ImFontConfig {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write ! (f , "ImFontConfig {{ FontData: {:?}, FontDataSize: {:?}, FontDataOwnedByAtlas: {:?}, FontNo: {:?}, SizePixels: {:?}, OversampleH: {:?}, OversampleV: {:?}, PixelSnapH: {:?}, GlyphExtraSpacing: {:?}, GlyphOffset: {:?}, GlyphRanges: {:?}, GlyphMinAdvanceX: {:?}, GlyphMaxAdvanceX: {:?}, MergeMode: {:?}, FontBuilderFlags: {:?}, RasterizerMultiply: {:?}, EllipsisChar: {:?}, Name: [...], DstFont: {:?} }}" , self . FontData , self . FontDataSize , self . FontDataOwnedByAtlas , self . FontNo , self . SizePixels , self . OversampleH , self . OversampleV , self . PixelSnapH , self . GlyphExtraSpacing , self . GlyphOffset , self . GlyphRanges , self . GlyphMinAdvanceX , self . GlyphMaxAdvanceX , self . MergeMode , self . FontBuilderFlags , self . RasterizerMultiply , self . EllipsisChar , self . DstFont)
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImFontGlyph {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub AdvanceX: f32,
    pub X0: f32,
    pub Y0: f32,
    pub X1: f32,
    pub Y1: f32,
    pub U0: f32,
    pub V0: f32,
    pub U1: f32,
    pub V1: f32,
}
impl ImFontGlyph {
    #[inline]
    pub fn Colored(&self) -> cty::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_Colored(&mut self, val: cty::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn Visible(&self) -> cty::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_Visible(&mut self, val: cty::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn Codepoint(&self) -> cty::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 30u8) as u32) }
    }
    #[inline]
    pub fn set_Codepoint(&mut self, val: cty::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 30u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        Colored: cty::c_uint,
        Visible: cty::c_uint,
        Codepoint: cty::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let Colored: u32 = unsafe { ::core::mem::transmute(Colored) };
            Colored as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let Visible: u32 = unsafe { ::core::mem::transmute(Visible) };
            Visible as u64
        });
        __bindgen_bitfield_unit.set(2usize, 30u8, {
            let Codepoint: u32 = unsafe { ::core::mem::transmute(Codepoint) };
            Codepoint as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImFontGlyphRangesBuilder {
    pub UsedChars: ImVector_ImU32,
}
impl Default for ImFontGlyphRangesBuilder {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImFontAtlasCustomRect {
    pub Width: cty::c_ushort,
    pub Height: cty::c_ushort,
    pub X: cty::c_ushort,
    pub Y: cty::c_ushort,
    pub GlyphID: cty::c_uint,
    pub GlyphAdvanceX: f32,
    pub GlyphOffset: ImVec2,
    pub Font: *mut ImFont,
}
impl Default for ImFontAtlasCustomRect {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
pub const ImFontAtlasFlags_None: ImFontAtlasFlags_ = 0;
pub const ImFontAtlasFlags_NoPowerOfTwoHeight: ImFontAtlasFlags_ = 1;
pub const ImFontAtlasFlags_NoMouseCursors: ImFontAtlasFlags_ = 2;
pub const ImFontAtlasFlags_NoBakedLines: ImFontAtlasFlags_ = 4;
pub type ImFontAtlasFlags_ = cty::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImFontAtlas {
    pub Flags: ImFontAtlasFlags,
    pub TexID: ImTextureID,
    pub TexDesiredWidth: cty::c_int,
    pub TexGlyphPadding: cty::c_int,
    pub Locked: bool,
    pub TexPixelsUseColors: bool,
    pub TexPixelsAlpha8: *mut cty::c_uchar,
    pub TexPixelsRGBA32: *mut cty::c_uint,
    pub TexWidth: cty::c_int,
    pub TexHeight: cty::c_int,
    pub TexUvScale: ImVec2,
    pub TexUvWhitePixel: ImVec2,
    pub Fonts: ImVector_ImFontPtr,
    pub CustomRects: ImVector_ImFontAtlasCustomRect,
    pub ConfigData: ImVector_ImFontConfig,
    pub TexUvLines: [ImVec4; 64usize],
    pub FontBuilderIO: *const ImFontBuilderIO,
    pub FontBuilderFlags: cty::c_uint,
    pub PackIdMouseCursors: cty::c_int,
    pub PackIdLines: cty::c_int,
}
impl Default for ImFontAtlas {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for ImFontAtlas {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write ! (f , "ImFontAtlas {{ Flags: {:?}, TexID: {:?}, TexDesiredWidth: {:?}, TexGlyphPadding: {:?}, Locked: {:?}, TexPixelsUseColors: {:?}, TexPixelsAlpha8: {:?}, TexPixelsRGBA32: {:?}, TexWidth: {:?}, TexHeight: {:?}, TexUvScale: {:?}, TexUvWhitePixel: {:?}, Fonts: {:?}, CustomRects: {:?}, ConfigData: {:?}, TexUvLines: [...], FontBuilderIO: {:?}, FontBuilderFlags: {:?}, PackIdMouseCursors: {:?}, PackIdLines: {:?} }}" , self . Flags , self . TexID , self . TexDesiredWidth , self . TexGlyphPadding , self . Locked , self . TexPixelsUseColors , self . TexPixelsAlpha8 , self . TexPixelsRGBA32 , self . TexWidth , self . TexHeight , self . TexUvScale , self . TexUvWhitePixel , self . Fonts , self . CustomRects , self . ConfigData , self . FontBuilderIO , self . FontBuilderFlags , self . PackIdMouseCursors , self . PackIdLines)
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImFont {
    pub IndexAdvanceX: ImVector_float,
    pub FallbackAdvanceX: f32,
    pub FontSize: f32,
    pub IndexLookup: ImVector_ImWchar,
    pub Glyphs: ImVector_ImFontGlyph,
    pub FallbackGlyph: *const ImFontGlyph,
    pub ContainerAtlas: *mut ImFontAtlas,
    pub ConfigData: *const ImFontConfig,
    pub ConfigDataCount: cty::c_short,
    pub FallbackChar: ImWchar,
    pub EllipsisChar: ImWchar,
    pub DirtyLookupTables: bool,
    pub Scale: f32,
    pub Ascent: f32,
    pub Descent: f32,
    pub MetricsTotalSurface: cty::c_int,
    pub Used4kPagesMap: [ImU8; 34usize],
}
impl Default for ImFont {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::fmt::Debug for ImFont {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write ! (f , "ImFont {{ IndexAdvanceX: {:?}, FallbackAdvanceX: {:?}, FontSize: {:?}, IndexLookup: {:?}, Glyphs: {:?}, FallbackGlyph: {:?}, ContainerAtlas: {:?}, ConfigData: {:?}, ConfigDataCount: {:?}, FallbackChar: {:?}, EllipsisChar: {:?}, DirtyLookupTables: {:?}, Scale: {:?}, Ascent: {:?}, Descent: {:?}, MetricsTotalSurface: {:?}, Used4kPagesMap: [...] }}" , self . IndexAdvanceX , self . FallbackAdvanceX , self . FontSize , self . IndexLookup , self . Glyphs , self . FallbackGlyph , self . ContainerAtlas , self . ConfigData , self . ConfigDataCount , self . FallbackChar , self . EllipsisChar , self . DirtyLookupTables , self . Scale , self . Ascent , self . Descent , self . MetricsTotalSurface)
    }
}
pub const ImGuiViewportFlags_None: ImGuiViewportFlags_ = 0;
pub const ImGuiViewportFlags_IsPlatformWindow: ImGuiViewportFlags_ = 1;
pub const ImGuiViewportFlags_IsPlatformMonitor: ImGuiViewportFlags_ = 2;
pub const ImGuiViewportFlags_OwnedByApp: ImGuiViewportFlags_ = 4;
pub type ImGuiViewportFlags_ = cty::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImGuiViewport {
    pub Flags: ImGuiViewportFlags,
    pub Pos: ImVec2,
    pub Size: ImVec2,
    pub WorkPos: ImVec2,
    pub WorkSize: ImVec2,
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImVec2_ImVec2Nil() -> *mut ImVec2;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImVec2_destroy(self_: *mut ImVec2);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImVec2_ImVec2Float(_x: f32, _y: f32) -> *mut ImVec2;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImVec4_ImVec4Nil() -> *mut ImVec4;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImVec4_destroy(self_: *mut ImVec4);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImVec4_ImVec4Float(_x: f32, _y: f32, _z: f32, _w: f32) -> *mut ImVec4;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igCreateContext(shared_font_atlas: *mut ImFontAtlas) -> *mut ImGuiContext;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igDestroyContext(ctx: *mut ImGuiContext);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetCurrentContext() -> *mut ImGuiContext;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetCurrentContext(ctx: *mut ImGuiContext);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetIO() -> *mut ImGuiIO;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetStyle() -> *mut ImGuiStyle;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igNewFrame();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igEndFrame();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igRender();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetDrawData() -> *mut ImDrawData;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igShowDemoWindow(p_open: *mut bool);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igShowMetricsWindow(p_open: *mut bool);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igShowAboutWindow(p_open: *mut bool);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igShowStyleEditor(ref_: *mut ImGuiStyle);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igShowStyleSelector(label: *const cty::c_char) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igShowFontSelector(label: *const cty::c_char);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igShowUserGuide();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetVersion() -> *const cty::c_char;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igStyleColorsDark(dst: *mut ImGuiStyle);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igStyleColorsLight(dst: *mut ImGuiStyle);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igStyleColorsClassic(dst: *mut ImGuiStyle);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igBegin(name: *const cty::c_char, p_open: *mut bool, flags: ImGuiWindowFlags) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igEnd();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igBeginChildStr(
        str_id: *const cty::c_char,
        size: ImVec2,
        border: bool,
        flags: ImGuiWindowFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igBeginChildID(id: ImGuiID, size: ImVec2, border: bool, flags: ImGuiWindowFlags)
        -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igEndChild();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsWindowAppearing() -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsWindowCollapsed() -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsWindowFocused(flags: ImGuiFocusedFlags) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsWindowHovered(flags: ImGuiHoveredFlags) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetWindowDrawList() -> *mut ImDrawList;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetWindowPos(pOut: *mut ImVec2);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetWindowSize(pOut: *mut ImVec2);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetWindowWidth() -> f32;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetWindowHeight() -> f32;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetNextWindowPos(pos: ImVec2, cond: ImGuiCond, pivot: ImVec2);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetNextWindowSize(size: ImVec2, cond: ImGuiCond);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetNextWindowSizeConstraints(
        size_min: ImVec2,
        size_max: ImVec2,
        custom_callback: ImGuiSizeCallback,
        custom_callback_data: *mut cty::c_void,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetNextWindowContentSize(size: ImVec2);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetNextWindowCollapsed(collapsed: bool, cond: ImGuiCond);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetNextWindowFocus();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetNextWindowBgAlpha(alpha: f32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetWindowPosVec2(pos: ImVec2, cond: ImGuiCond);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetWindowSizeVec2(size: ImVec2, cond: ImGuiCond);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetWindowCollapsedBool(collapsed: bool, cond: ImGuiCond);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetWindowFocusNil();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetWindowFontScale(scale: f32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetWindowPosStr(name: *const cty::c_char, pos: ImVec2, cond: ImGuiCond);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetWindowSizeStr(name: *const cty::c_char, size: ImVec2, cond: ImGuiCond);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetWindowCollapsedStr(name: *const cty::c_char, collapsed: bool, cond: ImGuiCond);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetWindowFocusStr(name: *const cty::c_char);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetContentRegionAvail(pOut: *mut ImVec2);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetContentRegionMax(pOut: *mut ImVec2);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetWindowContentRegionMin(pOut: *mut ImVec2);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetWindowContentRegionMax(pOut: *mut ImVec2);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetWindowContentRegionWidth() -> f32;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetScrollX() -> f32;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetScrollY() -> f32;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetScrollX(scroll_x: f32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetScrollY(scroll_y: f32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetScrollMaxX() -> f32;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetScrollMaxY() -> f32;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetScrollHereX(center_x_ratio: f32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetScrollHereY(center_y_ratio: f32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetScrollFromPosX(local_x: f32, center_x_ratio: f32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetScrollFromPosY(local_y: f32, center_y_ratio: f32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igPushFont(font: *mut ImFont);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igPopFont();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igPushStyleColorU32(idx: ImGuiCol, col: ImU32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igPushStyleColorVec4(idx: ImGuiCol, col: ImVec4);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igPopStyleColor(count: cty::c_int);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igPushStyleVarFloat(idx: ImGuiStyleVar, val: f32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igPushStyleVarVec2(idx: ImGuiStyleVar, val: ImVec2);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igPopStyleVar(count: cty::c_int);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igPushAllowKeyboardFocus(allow_keyboard_focus: bool);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igPopAllowKeyboardFocus();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igPushButtonRepeat(repeat: bool);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igPopButtonRepeat();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igPushItemWidth(item_width: f32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igPopItemWidth();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetNextItemWidth(item_width: f32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igCalcItemWidth() -> f32;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igPushTextWrapPos(wrap_local_pos_x: f32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igPopTextWrapPos();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetFont() -> *mut ImFont;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetFontSize() -> f32;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetFontTexUvWhitePixel(pOut: *mut ImVec2);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetColorU32Col(idx: ImGuiCol, alpha_mul: f32) -> ImU32;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetColorU32Vec4(col: ImVec4) -> ImU32;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetColorU32U32(col: ImU32) -> ImU32;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetStyleColorVec4(idx: ImGuiCol) -> *const ImVec4;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSeparator();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSameLine(offset_from_start_x: f32, spacing: f32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igNewLine();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSpacing();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igDummy(size: ImVec2);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIndent(indent_w: f32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igUnindent(indent_w: f32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igBeginGroup();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igEndGroup();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetCursorPos(pOut: *mut ImVec2);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetCursorPosX() -> f32;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetCursorPosY() -> f32;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetCursorPos(local_pos: ImVec2);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetCursorPosX(local_x: f32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetCursorPosY(local_y: f32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetCursorStartPos(pOut: *mut ImVec2);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetCursorScreenPos(pOut: *mut ImVec2);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetCursorScreenPos(pos: ImVec2);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igAlignTextToFramePadding();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetTextLineHeight() -> f32;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetTextLineHeightWithSpacing() -> f32;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetFrameHeight() -> f32;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetFrameHeightWithSpacing() -> f32;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igPushIDStr(str_id: *const cty::c_char);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igPushIDStrStr(str_id_begin: *const cty::c_char, str_id_end: *const cty::c_char);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igPushIDPtr(ptr_id: *const cty::c_void);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igPushIDInt(int_id: cty::c_int);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igPopID();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetIDStr(str_id: *const cty::c_char) -> ImGuiID;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetIDStrStr(
        str_id_begin: *const cty::c_char,
        str_id_end: *const cty::c_char,
    ) -> ImGuiID;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetIDPtr(ptr_id: *const cty::c_void) -> ImGuiID;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igTextUnformatted(text: *const cty::c_char, text_end: *const cty::c_char);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igText(fmt: *const cty::c_char, ...);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igTextColored(col: ImVec4, fmt: *const cty::c_char, ...);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igTextDisabled(fmt: *const cty::c_char, ...);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igTextWrapped(fmt: *const cty::c_char, ...);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igLabelText(label: *const cty::c_char, fmt: *const cty::c_char, ...);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igBulletText(fmt: *const cty::c_char, ...);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igButton(label: *const cty::c_char, size: ImVec2) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSmallButton(label: *const cty::c_char) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igInvisibleButton(
        str_id: *const cty::c_char,
        size: ImVec2,
        flags: ImGuiButtonFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igArrowButton(str_id: *const cty::c_char, dir: ImGuiDir) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igImage(
        user_texture_id: ImTextureID,
        size: ImVec2,
        uv0: ImVec2,
        uv1: ImVec2,
        tint_col: ImVec4,
        border_col: ImVec4,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igImageButton(
        user_texture_id: ImTextureID,
        size: ImVec2,
        uv0: ImVec2,
        uv1: ImVec2,
        frame_padding: cty::c_int,
        bg_col: ImVec4,
        tint_col: ImVec4,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igCheckbox(label: *const cty::c_char, v: *mut bool) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igCheckboxFlagsIntPtr(
        label: *const cty::c_char,
        flags: *mut cty::c_int,
        flags_value: cty::c_int,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igCheckboxFlagsUintPtr(
        label: *const cty::c_char,
        flags: *mut cty::c_uint,
        flags_value: cty::c_uint,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igRadioButtonBool(label: *const cty::c_char, active: bool) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igRadioButtonIntPtr(
        label: *const cty::c_char,
        v: *mut cty::c_int,
        v_button: cty::c_int,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igProgressBar(fraction: f32, size_arg: ImVec2, overlay: *const cty::c_char);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igBullet();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igBeginCombo(
        label: *const cty::c_char,
        preview_value: *const cty::c_char,
        flags: ImGuiComboFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igEndCombo();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igComboStr_arr(
        label: *const cty::c_char,
        current_item: *mut cty::c_int,
        items: *const *const cty::c_char,
        items_count: cty::c_int,
        popup_max_height_in_items: cty::c_int,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igComboStr(
        label: *const cty::c_char,
        current_item: *mut cty::c_int,
        items_separated_by_zeros: *const cty::c_char,
        popup_max_height_in_items: cty::c_int,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igComboFnBoolPtr(
        label: *const cty::c_char,
        current_item: *mut cty::c_int,
        items_getter: ::core::option::Option<
            unsafe extern "C" fn(
                data: *mut cty::c_void,
                idx: cty::c_int,
                out_text: *mut *const cty::c_char,
            ) -> bool,
        >,
        data: *mut cty::c_void,
        items_count: cty::c_int,
        popup_max_height_in_items: cty::c_int,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igDragFloat(
        label: *const cty::c_char,
        v: *mut f32,
        v_speed: f32,
        v_min: f32,
        v_max: f32,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igDragFloat2(
        label: *const cty::c_char,
        v: *mut f32,
        v_speed: f32,
        v_min: f32,
        v_max: f32,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igDragFloat3(
        label: *const cty::c_char,
        v: *mut f32,
        v_speed: f32,
        v_min: f32,
        v_max: f32,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igDragFloat4(
        label: *const cty::c_char,
        v: *mut f32,
        v_speed: f32,
        v_min: f32,
        v_max: f32,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igDragFloatRange2(
        label: *const cty::c_char,
        v_current_min: *mut f32,
        v_current_max: *mut f32,
        v_speed: f32,
        v_min: f32,
        v_max: f32,
        format: *const cty::c_char,
        format_max: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igDragInt(
        label: *const cty::c_char,
        v: *mut cty::c_int,
        v_speed: f32,
        v_min: cty::c_int,
        v_max: cty::c_int,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igDragInt2(
        label: *const cty::c_char,
        v: *mut cty::c_int,
        v_speed: f32,
        v_min: cty::c_int,
        v_max: cty::c_int,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igDragInt3(
        label: *const cty::c_char,
        v: *mut cty::c_int,
        v_speed: f32,
        v_min: cty::c_int,
        v_max: cty::c_int,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igDragInt4(
        label: *const cty::c_char,
        v: *mut cty::c_int,
        v_speed: f32,
        v_min: cty::c_int,
        v_max: cty::c_int,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igDragIntRange2(
        label: *const cty::c_char,
        v_current_min: *mut cty::c_int,
        v_current_max: *mut cty::c_int,
        v_speed: f32,
        v_min: cty::c_int,
        v_max: cty::c_int,
        format: *const cty::c_char,
        format_max: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igDragScalar(
        label: *const cty::c_char,
        data_type: ImGuiDataType,
        p_data: *mut cty::c_void,
        v_speed: f32,
        p_min: *const cty::c_void,
        p_max: *const cty::c_void,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igDragScalarN(
        label: *const cty::c_char,
        data_type: ImGuiDataType,
        p_data: *mut cty::c_void,
        components: cty::c_int,
        v_speed: f32,
        p_min: *const cty::c_void,
        p_max: *const cty::c_void,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSliderFloat(
        label: *const cty::c_char,
        v: *mut f32,
        v_min: f32,
        v_max: f32,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSliderFloat2(
        label: *const cty::c_char,
        v: *mut f32,
        v_min: f32,
        v_max: f32,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSliderFloat3(
        label: *const cty::c_char,
        v: *mut f32,
        v_min: f32,
        v_max: f32,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSliderFloat4(
        label: *const cty::c_char,
        v: *mut f32,
        v_min: f32,
        v_max: f32,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSliderAngle(
        label: *const cty::c_char,
        v_rad: *mut f32,
        v_degrees_min: f32,
        v_degrees_max: f32,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSliderInt(
        label: *const cty::c_char,
        v: *mut cty::c_int,
        v_min: cty::c_int,
        v_max: cty::c_int,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSliderInt2(
        label: *const cty::c_char,
        v: *mut cty::c_int,
        v_min: cty::c_int,
        v_max: cty::c_int,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSliderInt3(
        label: *const cty::c_char,
        v: *mut cty::c_int,
        v_min: cty::c_int,
        v_max: cty::c_int,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSliderInt4(
        label: *const cty::c_char,
        v: *mut cty::c_int,
        v_min: cty::c_int,
        v_max: cty::c_int,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSliderScalar(
        label: *const cty::c_char,
        data_type: ImGuiDataType,
        p_data: *mut cty::c_void,
        p_min: *const cty::c_void,
        p_max: *const cty::c_void,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSliderScalarN(
        label: *const cty::c_char,
        data_type: ImGuiDataType,
        p_data: *mut cty::c_void,
        components: cty::c_int,
        p_min: *const cty::c_void,
        p_max: *const cty::c_void,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igVSliderFloat(
        label: *const cty::c_char,
        size: ImVec2,
        v: *mut f32,
        v_min: f32,
        v_max: f32,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igVSliderInt(
        label: *const cty::c_char,
        size: ImVec2,
        v: *mut cty::c_int,
        v_min: cty::c_int,
        v_max: cty::c_int,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igVSliderScalar(
        label: *const cty::c_char,
        size: ImVec2,
        data_type: ImGuiDataType,
        p_data: *mut cty::c_void,
        p_min: *const cty::c_void,
        p_max: *const cty::c_void,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igInputText(
        label: *const cty::c_char,
        buf: *mut cty::c_char,
        buf_size: usize,
        flags: ImGuiInputTextFlags,
        callback: ImGuiInputTextCallback,
        user_data: *mut cty::c_void,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igInputTextMultiline(
        label: *const cty::c_char,
        buf: *mut cty::c_char,
        buf_size: usize,
        size: ImVec2,
        flags: ImGuiInputTextFlags,
        callback: ImGuiInputTextCallback,
        user_data: *mut cty::c_void,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igInputTextWithHint(
        label: *const cty::c_char,
        hint: *const cty::c_char,
        buf: *mut cty::c_char,
        buf_size: usize,
        flags: ImGuiInputTextFlags,
        callback: ImGuiInputTextCallback,
        user_data: *mut cty::c_void,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igInputFloat(
        label: *const cty::c_char,
        v: *mut f32,
        step: f32,
        step_fast: f32,
        format: *const cty::c_char,
        flags: ImGuiInputTextFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igInputFloat2(
        label: *const cty::c_char,
        v: *mut f32,
        format: *const cty::c_char,
        flags: ImGuiInputTextFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igInputFloat3(
        label: *const cty::c_char,
        v: *mut f32,
        format: *const cty::c_char,
        flags: ImGuiInputTextFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igInputFloat4(
        label: *const cty::c_char,
        v: *mut f32,
        format: *const cty::c_char,
        flags: ImGuiInputTextFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igInputInt(
        label: *const cty::c_char,
        v: *mut cty::c_int,
        step: cty::c_int,
        step_fast: cty::c_int,
        flags: ImGuiInputTextFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igInputInt2(
        label: *const cty::c_char,
        v: *mut cty::c_int,
        flags: ImGuiInputTextFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igInputInt3(
        label: *const cty::c_char,
        v: *mut cty::c_int,
        flags: ImGuiInputTextFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igInputInt4(
        label: *const cty::c_char,
        v: *mut cty::c_int,
        flags: ImGuiInputTextFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igInputDouble(
        label: *const cty::c_char,
        v: *mut f64,
        step: f64,
        step_fast: f64,
        format: *const cty::c_char,
        flags: ImGuiInputTextFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igInputScalar(
        label: *const cty::c_char,
        data_type: ImGuiDataType,
        p_data: *mut cty::c_void,
        p_step: *const cty::c_void,
        p_step_fast: *const cty::c_void,
        format: *const cty::c_char,
        flags: ImGuiInputTextFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igInputScalarN(
        label: *const cty::c_char,
        data_type: ImGuiDataType,
        p_data: *mut cty::c_void,
        components: cty::c_int,
        p_step: *const cty::c_void,
        p_step_fast: *const cty::c_void,
        format: *const cty::c_char,
        flags: ImGuiInputTextFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igColorEdit3(
        label: *const cty::c_char,
        col: *mut f32,
        flags: ImGuiColorEditFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igColorEdit4(
        label: *const cty::c_char,
        col: *mut f32,
        flags: ImGuiColorEditFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igColorPicker3(
        label: *const cty::c_char,
        col: *mut f32,
        flags: ImGuiColorEditFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igColorPicker4(
        label: *const cty::c_char,
        col: *mut f32,
        flags: ImGuiColorEditFlags,
        ref_col: *const f32,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igColorButton(
        desc_id: *const cty::c_char,
        col: ImVec4,
        flags: ImGuiColorEditFlags,
        size: ImVec2,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetColorEditOptions(flags: ImGuiColorEditFlags);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igTreeNodeStr(label: *const cty::c_char) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igTreeNodeStrStr(str_id: *const cty::c_char, fmt: *const cty::c_char, ...) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igTreeNodePtr(ptr_id: *const cty::c_void, fmt: *const cty::c_char, ...) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igTreeNodeExStr(label: *const cty::c_char, flags: ImGuiTreeNodeFlags) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igTreeNodeExStrStr(
        str_id: *const cty::c_char,
        flags: ImGuiTreeNodeFlags,
        fmt: *const cty::c_char,
        ...
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igTreeNodeExPtr(
        ptr_id: *const cty::c_void,
        flags: ImGuiTreeNodeFlags,
        fmt: *const cty::c_char,
        ...
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igTreePushStr(str_id: *const cty::c_char);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igTreePushPtr(ptr_id: *const cty::c_void);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igTreePop();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetTreeNodeToLabelSpacing() -> f32;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igCollapsingHeaderTreeNodeFlags(
        label: *const cty::c_char,
        flags: ImGuiTreeNodeFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igCollapsingHeaderBoolPtr(
        label: *const cty::c_char,
        p_visible: *mut bool,
        flags: ImGuiTreeNodeFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetNextItemOpen(is_open: bool, cond: ImGuiCond);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSelectableBool(
        label: *const cty::c_char,
        selected: bool,
        flags: ImGuiSelectableFlags,
        size: ImVec2,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSelectableBoolPtr(
        label: *const cty::c_char,
        p_selected: *mut bool,
        flags: ImGuiSelectableFlags,
        size: ImVec2,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igBeginListBox(label: *const cty::c_char, size: ImVec2) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igEndListBox();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igListBoxStr_arr(
        label: *const cty::c_char,
        current_item: *mut cty::c_int,
        items: *const *const cty::c_char,
        items_count: cty::c_int,
        height_in_items: cty::c_int,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igListBoxFnBoolPtr(
        label: *const cty::c_char,
        current_item: *mut cty::c_int,
        items_getter: ::core::option::Option<
            unsafe extern "C" fn(
                data: *mut cty::c_void,
                idx: cty::c_int,
                out_text: *mut *const cty::c_char,
            ) -> bool,
        >,
        data: *mut cty::c_void,
        items_count: cty::c_int,
        height_in_items: cty::c_int,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igPlotLinesFloatPtr(
        label: *const cty::c_char,
        values: *const f32,
        values_count: cty::c_int,
        values_offset: cty::c_int,
        overlay_text: *const cty::c_char,
        scale_min: f32,
        scale_max: f32,
        graph_size: ImVec2,
        stride: cty::c_int,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igPlotLinesFnFloatPtr(
        label: *const cty::c_char,
        values_getter: ::core::option::Option<
            unsafe extern "C" fn(data: *mut cty::c_void, idx: cty::c_int) -> f32,
        >,
        data: *mut cty::c_void,
        values_count: cty::c_int,
        values_offset: cty::c_int,
        overlay_text: *const cty::c_char,
        scale_min: f32,
        scale_max: f32,
        graph_size: ImVec2,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igPlotHistogramFloatPtr(
        label: *const cty::c_char,
        values: *const f32,
        values_count: cty::c_int,
        values_offset: cty::c_int,
        overlay_text: *const cty::c_char,
        scale_min: f32,
        scale_max: f32,
        graph_size: ImVec2,
        stride: cty::c_int,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igPlotHistogramFnFloatPtr(
        label: *const cty::c_char,
        values_getter: ::core::option::Option<
            unsafe extern "C" fn(data: *mut cty::c_void, idx: cty::c_int) -> f32,
        >,
        data: *mut cty::c_void,
        values_count: cty::c_int,
        values_offset: cty::c_int,
        overlay_text: *const cty::c_char,
        scale_min: f32,
        scale_max: f32,
        graph_size: ImVec2,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igValueBool(prefix: *const cty::c_char, b: bool);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igValueInt(prefix: *const cty::c_char, v: cty::c_int);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igValueUint(prefix: *const cty::c_char, v: cty::c_uint);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igValueFloat(prefix: *const cty::c_char, v: f32, float_format: *const cty::c_char);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igBeginMenuBar() -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igEndMenuBar();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igBeginMainMenuBar() -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igEndMainMenuBar();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igBeginMenu(label: *const cty::c_char, enabled: bool) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igEndMenu();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igMenuItemBool(
        label: *const cty::c_char,
        shortcut: *const cty::c_char,
        selected: bool,
        enabled: bool,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igMenuItemBoolPtr(
        label: *const cty::c_char,
        shortcut: *const cty::c_char,
        p_selected: *mut bool,
        enabled: bool,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igBeginTooltip();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igEndTooltip();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetTooltip(fmt: *const cty::c_char, ...);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igBeginPopup(str_id: *const cty::c_char, flags: ImGuiWindowFlags) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igBeginPopupModal(
        name: *const cty::c_char,
        p_open: *mut bool,
        flags: ImGuiWindowFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igEndPopup();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igOpenPopup(str_id: *const cty::c_char, popup_flags: ImGuiPopupFlags);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igOpenPopupOnItemClick(str_id: *const cty::c_char, popup_flags: ImGuiPopupFlags);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igCloseCurrentPopup();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igBeginPopupContextItem(
        str_id: *const cty::c_char,
        popup_flags: ImGuiPopupFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igBeginPopupContextWindow(
        str_id: *const cty::c_char,
        popup_flags: ImGuiPopupFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igBeginPopupContextVoid(
        str_id: *const cty::c_char,
        popup_flags: ImGuiPopupFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsPopupOpen(str_id: *const cty::c_char, flags: ImGuiPopupFlags) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igBeginTable(
        str_id: *const cty::c_char,
        column: cty::c_int,
        flags: ImGuiTableFlags,
        outer_size: ImVec2,
        inner_width: f32,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igEndTable();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igTableNextRow(row_flags: ImGuiTableRowFlags, min_row_height: f32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igTableNextColumn() -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igTableSetColumnIndex(column_n: cty::c_int) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igTableSetupColumn(
        label: *const cty::c_char,
        flags: ImGuiTableColumnFlags,
        init_width_or_weight: f32,
        user_id: ImGuiID,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igTableSetupScrollFreeze(cols: cty::c_int, rows: cty::c_int);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igTableHeadersRow();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igTableHeader(label: *const cty::c_char);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igTableGetSortSpecs() -> *mut ImGuiTableSortSpecs;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igTableGetColumnCount() -> cty::c_int;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igTableGetColumnIndex() -> cty::c_int;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igTableGetRowIndex() -> cty::c_int;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igTableGetColumnName(column_n: cty::c_int) -> *const cty::c_char;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igTableGetColumnFlags(column_n: cty::c_int) -> ImGuiTableColumnFlags;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igTableSetBgColor(target: ImGuiTableBgTarget, color: ImU32, column_n: cty::c_int);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igColumns(count: cty::c_int, id: *const cty::c_char, border: bool);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igNextColumn();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetColumnIndex() -> cty::c_int;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetColumnWidth(column_index: cty::c_int) -> f32;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetColumnWidth(column_index: cty::c_int, width: f32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetColumnOffset(column_index: cty::c_int) -> f32;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetColumnOffset(column_index: cty::c_int, offset_x: f32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetColumnsCount() -> cty::c_int;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igBeginTabBar(str_id: *const cty::c_char, flags: ImGuiTabBarFlags) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igEndTabBar();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igBeginTabItem(
        label: *const cty::c_char,
        p_open: *mut bool,
        flags: ImGuiTabItemFlags,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igEndTabItem();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igTabItemButton(label: *const cty::c_char, flags: ImGuiTabItemFlags) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetTabItemClosed(tab_or_docked_window_label: *const cty::c_char);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igLogToTTY(auto_open_depth: cty::c_int);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igLogToFile(auto_open_depth: cty::c_int, filename: *const cty::c_char);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igLogToClipboard(auto_open_depth: cty::c_int);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igLogFinish();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igLogButtons();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igBeginDragDropSource(flags: ImGuiDragDropFlags) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetDragDropPayload(
        type_: *const cty::c_char,
        data: *const cty::c_void,
        sz: usize,
        cond: ImGuiCond,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igEndDragDropSource();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igBeginDragDropTarget() -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igAcceptDragDropPayload(
        type_: *const cty::c_char,
        flags: ImGuiDragDropFlags,
    ) -> *const ImGuiPayload;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igEndDragDropTarget();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetDragDropPayload() -> *const ImGuiPayload;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igPushClipRect(
        clip_rect_min: ImVec2,
        clip_rect_max: ImVec2,
        intersect_with_current_clip_rect: bool,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igPopClipRect();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetItemDefaultFocus();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetKeyboardFocusHere(offset: cty::c_int);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsItemHovered(flags: ImGuiHoveredFlags) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsItemActive() -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsItemFocused() -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsItemClicked(mouse_button: ImGuiMouseButton) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsItemVisible() -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsItemEdited() -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsItemActivated() -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsItemDeactivated() -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsItemDeactivatedAfterEdit() -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsItemToggledOpen() -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsAnyItemHovered() -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsAnyItemActive() -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsAnyItemFocused() -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetItemRectMin(pOut: *mut ImVec2);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetItemRectMax(pOut: *mut ImVec2);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetItemRectSize(pOut: *mut ImVec2);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetItemAllowOverlap();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetMainViewport() -> *mut ImGuiViewport;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsRectVisibleNil(size: ImVec2) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsRectVisibleVec2(rect_min: ImVec2, rect_max: ImVec2) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetTime() -> f64;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetFrameCount() -> cty::c_int;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetBackgroundDrawList() -> *mut ImDrawList;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetForegroundDrawList() -> *mut ImDrawList;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetDrawListSharedData() -> *mut ImDrawListSharedData;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetStyleColorName(idx: ImGuiCol) -> *const cty::c_char;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetStateStorage(storage: *mut ImGuiStorage);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetStateStorage() -> *mut ImGuiStorage;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igCalcListClipping(
        items_count: cty::c_int,
        items_height: f32,
        out_items_display_start: *mut cty::c_int,
        out_items_display_end: *mut cty::c_int,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igBeginChildFrame(id: ImGuiID, size: ImVec2, flags: ImGuiWindowFlags) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igEndChildFrame();
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igCalcTextSize(
        pOut: *mut ImVec2,
        text: *const cty::c_char,
        text_end: *const cty::c_char,
        hide_text_after_double_hash: bool,
        wrap_width: f32,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igColorConvertU32ToFloat4(pOut: *mut ImVec4, in_: ImU32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igColorConvertFloat4ToU32(in_: ImVec4) -> ImU32;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igColorConvertRGBtoHSV(
        r: f32,
        g: f32,
        b: f32,
        out_h: *mut f32,
        out_s: *mut f32,
        out_v: *mut f32,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igColorConvertHSVtoRGB(
        h: f32,
        s: f32,
        v: f32,
        out_r: *mut f32,
        out_g: *mut f32,
        out_b: *mut f32,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetKeyIndex(imgui_key: ImGuiKey) -> cty::c_int;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsKeyDown(user_key_index: cty::c_int) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsKeyPressed(user_key_index: cty::c_int, repeat: bool) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsKeyReleased(user_key_index: cty::c_int) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetKeyPressedAmount(key_index: cty::c_int, repeat_delay: f32, rate: f32)
        -> cty::c_int;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igCaptureKeyboardFromApp(want_capture_keyboard_value: bool);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsMouseDown(button: ImGuiMouseButton) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsMouseClicked(button: ImGuiMouseButton, repeat: bool) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsMouseReleased(button: ImGuiMouseButton) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsMouseDoubleClicked(button: ImGuiMouseButton) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsMouseHoveringRect(r_min: ImVec2, r_max: ImVec2, clip: bool) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsMousePosValid(mouse_pos: *const ImVec2) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsAnyMouseDown() -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetMousePos(pOut: *mut ImVec2);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetMousePosOnOpeningCurrentPopup(pOut: *mut ImVec2);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igIsMouseDragging(button: ImGuiMouseButton, lock_threshold: f32) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetMouseDragDelta(pOut: *mut ImVec2, button: ImGuiMouseButton, lock_threshold: f32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igResetMouseDragDelta(button: ImGuiMouseButton);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetMouseCursor() -> ImGuiMouseCursor;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetMouseCursor(cursor_type: ImGuiMouseCursor);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igCaptureMouseFromApp(want_capture_mouse_value: bool);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetClipboardText() -> *const cty::c_char;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetClipboardText(text: *const cty::c_char);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igLoadIniSettingsFromDisk(ini_filename: *const cty::c_char);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igLoadIniSettingsFromMemory(ini_data: *const cty::c_char, ini_size: usize);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSaveIniSettingsToDisk(ini_filename: *const cty::c_char);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSaveIniSettingsToMemory(out_ini_size: *mut usize) -> *const cty::c_char;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igDebugCheckVersionAndDataLayout(
        version_str: *const cty::c_char,
        sz_io: usize,
        sz_style: usize,
        sz_vec2: usize,
        sz_vec4: usize,
        sz_drawvert: usize,
        sz_drawidx: usize,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igSetAllocatorFunctions(
        alloc_func: ImGuiMemAllocFunc,
        free_func: ImGuiMemFreeFunc,
        user_data: *mut cty::c_void,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igGetAllocatorFunctions(
        p_alloc_func: *mut ImGuiMemAllocFunc,
        p_free_func: *mut ImGuiMemFreeFunc,
        p_user_data: *mut *mut cty::c_void,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igMemAlloc(size: usize) -> *mut cty::c_void;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igMemFree(ptr: *mut cty::c_void);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiStyle_ImGuiStyle() -> *mut ImGuiStyle;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiStyle_destroy(self_: *mut ImGuiStyle);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiStyle_ScaleAllSizes(self_: *mut ImGuiStyle, scale_factor: f32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiIO_AddInputCharacter(self_: *mut ImGuiIO, c: cty::c_uint);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiIO_AddInputCharacterUTF16(self_: *mut ImGuiIO, c: ImWchar16);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiIO_AddInputCharactersUTF8(self_: *mut ImGuiIO, str_: *const cty::c_char);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiIO_ClearInputCharacters(self_: *mut ImGuiIO);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiIO_ImGuiIO() -> *mut ImGuiIO;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiIO_destroy(self_: *mut ImGuiIO);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiInputTextCallbackData_ImGuiInputTextCallbackData() -> *mut ImGuiInputTextCallbackData;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiInputTextCallbackData_destroy(self_: *mut ImGuiInputTextCallbackData);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiInputTextCallbackData_DeleteChars(
        self_: *mut ImGuiInputTextCallbackData,
        pos: cty::c_int,
        bytes_count: cty::c_int,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiInputTextCallbackData_InsertChars(
        self_: *mut ImGuiInputTextCallbackData,
        pos: cty::c_int,
        text: *const cty::c_char,
        text_end: *const cty::c_char,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiInputTextCallbackData_SelectAll(self_: *mut ImGuiInputTextCallbackData);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiInputTextCallbackData_ClearSelection(self_: *mut ImGuiInputTextCallbackData);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiInputTextCallbackData_HasSelection(self_: *mut ImGuiInputTextCallbackData) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiPayload_ImGuiPayload() -> *mut ImGuiPayload;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiPayload_destroy(self_: *mut ImGuiPayload);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiPayload_Clear(self_: *mut ImGuiPayload);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiPayload_IsDataType(self_: *mut ImGuiPayload, type_: *const cty::c_char) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiPayload_IsPreview(self_: *mut ImGuiPayload) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiPayload_IsDelivery(self_: *mut ImGuiPayload) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiTableColumnSortSpecs_ImGuiTableColumnSortSpecs() -> *mut ImGuiTableColumnSortSpecs;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiTableColumnSortSpecs_destroy(self_: *mut ImGuiTableColumnSortSpecs);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiTableSortSpecs_ImGuiTableSortSpecs() -> *mut ImGuiTableSortSpecs;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiTableSortSpecs_destroy(self_: *mut ImGuiTableSortSpecs);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiOnceUponAFrame_ImGuiOnceUponAFrame() -> *mut ImGuiOnceUponAFrame;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiOnceUponAFrame_destroy(self_: *mut ImGuiOnceUponAFrame);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiTextFilter_ImGuiTextFilter(
        default_filter: *const cty::c_char,
    ) -> *mut ImGuiTextFilter;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiTextFilter_destroy(self_: *mut ImGuiTextFilter);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiTextFilter_Draw(
        self_: *mut ImGuiTextFilter,
        label: *const cty::c_char,
        width: f32,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiTextFilter_PassFilter(
        self_: *mut ImGuiTextFilter,
        text: *const cty::c_char,
        text_end: *const cty::c_char,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiTextFilter_Build(self_: *mut ImGuiTextFilter);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiTextFilter_Clear(self_: *mut ImGuiTextFilter);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiTextFilter_IsActive(self_: *mut ImGuiTextFilter) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiTextRange_ImGuiTextRangeNil() -> *mut ImGuiTextRange;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiTextRange_destroy(self_: *mut ImGuiTextRange);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiTextRange_ImGuiTextRangeStr(
        _b: *const cty::c_char,
        _e: *const cty::c_char,
    ) -> *mut ImGuiTextRange;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiTextRange_empty(self_: *mut ImGuiTextRange) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiTextRange_split(
        self_: *mut ImGuiTextRange,
        separator: cty::c_char,
        out: *mut ImVector_ImGuiTextRange,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiTextBuffer_ImGuiTextBuffer() -> *mut ImGuiTextBuffer;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiTextBuffer_destroy(self_: *mut ImGuiTextBuffer);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiTextBuffer_begin(self_: *mut ImGuiTextBuffer) -> *const cty::c_char;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiTextBuffer_end(self_: *mut ImGuiTextBuffer) -> *const cty::c_char;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiTextBuffer_size(self_: *mut ImGuiTextBuffer) -> cty::c_int;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiTextBuffer_empty(self_: *mut ImGuiTextBuffer) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiTextBuffer_clear(self_: *mut ImGuiTextBuffer);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiTextBuffer_reserve(self_: *mut ImGuiTextBuffer, capacity: cty::c_int);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiTextBuffer_c_str(self_: *mut ImGuiTextBuffer) -> *const cty::c_char;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiTextBuffer_append(
        self_: *mut ImGuiTextBuffer,
        str_: *const cty::c_char,
        str_end: *const cty::c_char,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiStoragePair_ImGuiStoragePairInt(
        _key: ImGuiID,
        _val_i: cty::c_int,
    ) -> *mut ImGuiStoragePair;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiStoragePair_destroy(self_: *mut ImGuiStoragePair);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiStoragePair_ImGuiStoragePairFloat(
        _key: ImGuiID,
        _val_f: f32,
    ) -> *mut ImGuiStoragePair;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiStoragePair_ImGuiStoragePairPtr(
        _key: ImGuiID,
        _val_p: *mut cty::c_void,
    ) -> *mut ImGuiStoragePair;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiStorage_Clear(self_: *mut ImGuiStorage);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiStorage_GetInt(
        self_: *mut ImGuiStorage,
        key: ImGuiID,
        default_val: cty::c_int,
    ) -> cty::c_int;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiStorage_SetInt(self_: *mut ImGuiStorage, key: ImGuiID, val: cty::c_int);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiStorage_GetBool(self_: *mut ImGuiStorage, key: ImGuiID, default_val: bool) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiStorage_SetBool(self_: *mut ImGuiStorage, key: ImGuiID, val: bool);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiStorage_GetFloat(self_: *mut ImGuiStorage, key: ImGuiID, default_val: f32) -> f32;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiStorage_SetFloat(self_: *mut ImGuiStorage, key: ImGuiID, val: f32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiStorage_GetVoidPtr(self_: *mut ImGuiStorage, key: ImGuiID) -> *mut cty::c_void;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiStorage_SetVoidPtr(self_: *mut ImGuiStorage, key: ImGuiID, val: *mut cty::c_void);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiStorage_GetIntRef(
        self_: *mut ImGuiStorage,
        key: ImGuiID,
        default_val: cty::c_int,
    ) -> *mut cty::c_int;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiStorage_GetBoolRef(
        self_: *mut ImGuiStorage,
        key: ImGuiID,
        default_val: bool,
    ) -> *mut bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiStorage_GetFloatRef(
        self_: *mut ImGuiStorage,
        key: ImGuiID,
        default_val: f32,
    ) -> *mut f32;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiStorage_GetVoidPtrRef(
        self_: *mut ImGuiStorage,
        key: ImGuiID,
        default_val: *mut cty::c_void,
    ) -> *mut *mut cty::c_void;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiStorage_SetAllInt(self_: *mut ImGuiStorage, val: cty::c_int);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiStorage_BuildSortByKey(self_: *mut ImGuiStorage);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiListClipper_ImGuiListClipper() -> *mut ImGuiListClipper;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiListClipper_destroy(self_: *mut ImGuiListClipper);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiListClipper_Begin(
        self_: *mut ImGuiListClipper,
        items_count: cty::c_int,
        items_height: f32,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiListClipper_End(self_: *mut ImGuiListClipper);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiListClipper_Step(self_: *mut ImGuiListClipper) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImColor_ImColorNil() -> *mut ImColor;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImColor_destroy(self_: *mut ImColor);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImColor_ImColorInt(
        r: cty::c_int,
        g: cty::c_int,
        b: cty::c_int,
        a: cty::c_int,
    ) -> *mut ImColor;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImColor_ImColorU32(rgba: ImU32) -> *mut ImColor;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImColor_ImColorFloat(r: f32, g: f32, b: f32, a: f32) -> *mut ImColor;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImColor_ImColorVec4(col: ImVec4) -> *mut ImColor;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImColor_SetHSV(self_: *mut ImColor, h: f32, s: f32, v: f32, a: f32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImColor_HSV(pOut: *mut ImColor, h: f32, s: f32, v: f32, a: f32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawCmd_ImDrawCmd() -> *mut ImDrawCmd;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawCmd_destroy(self_: *mut ImDrawCmd);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawListSplitter_ImDrawListSplitter() -> *mut ImDrawListSplitter;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawListSplitter_destroy(self_: *mut ImDrawListSplitter);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawListSplitter_Clear(self_: *mut ImDrawListSplitter);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawListSplitter_ClearFreeMemory(self_: *mut ImDrawListSplitter);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawListSplitter_Split(
        self_: *mut ImDrawListSplitter,
        draw_list: *mut ImDrawList,
        count: cty::c_int,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawListSplitter_Merge(self_: *mut ImDrawListSplitter, draw_list: *mut ImDrawList);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawListSplitter_SetCurrentChannel(
        self_: *mut ImDrawListSplitter,
        draw_list: *mut ImDrawList,
        channel_idx: cty::c_int,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_ImDrawList(shared_data: *const ImDrawListSharedData) -> *mut ImDrawList;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_destroy(self_: *mut ImDrawList);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_PushClipRect(
        self_: *mut ImDrawList,
        clip_rect_min: ImVec2,
        clip_rect_max: ImVec2,
        intersect_with_current_clip_rect: bool,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_PushClipRectFullScreen(self_: *mut ImDrawList);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_PopClipRect(self_: *mut ImDrawList);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_PushTextureID(self_: *mut ImDrawList, texture_id: ImTextureID);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_PopTextureID(self_: *mut ImDrawList);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_GetClipRectMin(pOut: *mut ImVec2, self_: *mut ImDrawList);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_GetClipRectMax(pOut: *mut ImVec2, self_: *mut ImDrawList);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_AddLine(
        self_: *mut ImDrawList,
        p1: ImVec2,
        p2: ImVec2,
        col: ImU32,
        thickness: f32,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_AddRect(
        self_: *mut ImDrawList,
        p_min: ImVec2,
        p_max: ImVec2,
        col: ImU32,
        rounding: f32,
        flags: ImDrawFlags,
        thickness: f32,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_AddRectFilled(
        self_: *mut ImDrawList,
        p_min: ImVec2,
        p_max: ImVec2,
        col: ImU32,
        rounding: f32,
        flags: ImDrawFlags,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_AddRectFilledMultiColor(
        self_: *mut ImDrawList,
        p_min: ImVec2,
        p_max: ImVec2,
        col_upr_left: ImU32,
        col_upr_right: ImU32,
        col_bot_right: ImU32,
        col_bot_left: ImU32,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_AddQuad(
        self_: *mut ImDrawList,
        p1: ImVec2,
        p2: ImVec2,
        p3: ImVec2,
        p4: ImVec2,
        col: ImU32,
        thickness: f32,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_AddQuadFilled(
        self_: *mut ImDrawList,
        p1: ImVec2,
        p2: ImVec2,
        p3: ImVec2,
        p4: ImVec2,
        col: ImU32,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_AddTriangle(
        self_: *mut ImDrawList,
        p1: ImVec2,
        p2: ImVec2,
        p3: ImVec2,
        col: ImU32,
        thickness: f32,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_AddTriangleFilled(
        self_: *mut ImDrawList,
        p1: ImVec2,
        p2: ImVec2,
        p3: ImVec2,
        col: ImU32,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_AddCircle(
        self_: *mut ImDrawList,
        center: ImVec2,
        radius: f32,
        col: ImU32,
        num_segments: cty::c_int,
        thickness: f32,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_AddCircleFilled(
        self_: *mut ImDrawList,
        center: ImVec2,
        radius: f32,
        col: ImU32,
        num_segments: cty::c_int,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_AddNgon(
        self_: *mut ImDrawList,
        center: ImVec2,
        radius: f32,
        col: ImU32,
        num_segments: cty::c_int,
        thickness: f32,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_AddNgonFilled(
        self_: *mut ImDrawList,
        center: ImVec2,
        radius: f32,
        col: ImU32,
        num_segments: cty::c_int,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_AddTextVec2(
        self_: *mut ImDrawList,
        pos: ImVec2,
        col: ImU32,
        text_begin: *const cty::c_char,
        text_end: *const cty::c_char,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_AddTextFontPtr(
        self_: *mut ImDrawList,
        font: *const ImFont,
        font_size: f32,
        pos: ImVec2,
        col: ImU32,
        text_begin: *const cty::c_char,
        text_end: *const cty::c_char,
        wrap_width: f32,
        cpu_fine_clip_rect: *const ImVec4,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_AddPolyline(
        self_: *mut ImDrawList,
        points: *const ImVec2,
        num_points: cty::c_int,
        col: ImU32,
        flags: ImDrawFlags,
        thickness: f32,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_AddConvexPolyFilled(
        self_: *mut ImDrawList,
        points: *const ImVec2,
        num_points: cty::c_int,
        col: ImU32,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_AddBezierCubic(
        self_: *mut ImDrawList,
        p1: ImVec2,
        p2: ImVec2,
        p3: ImVec2,
        p4: ImVec2,
        col: ImU32,
        thickness: f32,
        num_segments: cty::c_int,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_AddBezierQuadratic(
        self_: *mut ImDrawList,
        p1: ImVec2,
        p2: ImVec2,
        p3: ImVec2,
        col: ImU32,
        thickness: f32,
        num_segments: cty::c_int,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_AddImage(
        self_: *mut ImDrawList,
        user_texture_id: ImTextureID,
        p_min: ImVec2,
        p_max: ImVec2,
        uv_min: ImVec2,
        uv_max: ImVec2,
        col: ImU32,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_AddImageQuad(
        self_: *mut ImDrawList,
        user_texture_id: ImTextureID,
        p1: ImVec2,
        p2: ImVec2,
        p3: ImVec2,
        p4: ImVec2,
        uv1: ImVec2,
        uv2: ImVec2,
        uv3: ImVec2,
        uv4: ImVec2,
        col: ImU32,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_AddImageRounded(
        self_: *mut ImDrawList,
        user_texture_id: ImTextureID,
        p_min: ImVec2,
        p_max: ImVec2,
        uv_min: ImVec2,
        uv_max: ImVec2,
        col: ImU32,
        rounding: f32,
        flags: ImDrawFlags,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_PathClear(self_: *mut ImDrawList);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_PathLineTo(self_: *mut ImDrawList, pos: ImVec2);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_PathLineToMergeDuplicate(self_: *mut ImDrawList, pos: ImVec2);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_PathFillConvex(self_: *mut ImDrawList, col: ImU32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_PathStroke(
        self_: *mut ImDrawList,
        col: ImU32,
        flags: ImDrawFlags,
        thickness: f32,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_PathArcTo(
        self_: *mut ImDrawList,
        center: ImVec2,
        radius: f32,
        a_min: f32,
        a_max: f32,
        num_segments: cty::c_int,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_PathArcToFast(
        self_: *mut ImDrawList,
        center: ImVec2,
        radius: f32,
        a_min_of_12: cty::c_int,
        a_max_of_12: cty::c_int,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_PathBezierCubicCurveTo(
        self_: *mut ImDrawList,
        p2: ImVec2,
        p3: ImVec2,
        p4: ImVec2,
        num_segments: cty::c_int,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_PathBezierQuadraticCurveTo(
        self_: *mut ImDrawList,
        p2: ImVec2,
        p3: ImVec2,
        num_segments: cty::c_int,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_PathRect(
        self_: *mut ImDrawList,
        rect_min: ImVec2,
        rect_max: ImVec2,
        rounding: f32,
        flags: ImDrawFlags,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_AddCallback(
        self_: *mut ImDrawList,
        callback: ImDrawCallback,
        callback_data: *mut cty::c_void,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_AddDrawCmd(self_: *mut ImDrawList);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_CloneOutput(self_: *mut ImDrawList) -> *mut ImDrawList;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_ChannelsSplit(self_: *mut ImDrawList, count: cty::c_int);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_ChannelsMerge(self_: *mut ImDrawList);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_ChannelsSetCurrent(self_: *mut ImDrawList, n: cty::c_int);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_PrimReserve(
        self_: *mut ImDrawList,
        idx_count: cty::c_int,
        vtx_count: cty::c_int,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_PrimUnreserve(
        self_: *mut ImDrawList,
        idx_count: cty::c_int,
        vtx_count: cty::c_int,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_PrimRect(self_: *mut ImDrawList, a: ImVec2, b: ImVec2, col: ImU32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_PrimRectUV(
        self_: *mut ImDrawList,
        a: ImVec2,
        b: ImVec2,
        uv_a: ImVec2,
        uv_b: ImVec2,
        col: ImU32,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_PrimQuadUV(
        self_: *mut ImDrawList,
        a: ImVec2,
        b: ImVec2,
        c: ImVec2,
        d: ImVec2,
        uv_a: ImVec2,
        uv_b: ImVec2,
        uv_c: ImVec2,
        uv_d: ImVec2,
        col: ImU32,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_PrimWriteVtx(self_: *mut ImDrawList, pos: ImVec2, uv: ImVec2, col: ImU32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_PrimWriteIdx(self_: *mut ImDrawList, idx: ImDrawIdx);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList_PrimVtx(self_: *mut ImDrawList, pos: ImVec2, uv: ImVec2, col: ImU32);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList__ResetForNewFrame(self_: *mut ImDrawList);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList__ClearFreeMemory(self_: *mut ImDrawList);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList__PopUnusedDrawCmd(self_: *mut ImDrawList);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList__OnChangedClipRect(self_: *mut ImDrawList);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList__OnChangedTextureID(self_: *mut ImDrawList);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList__OnChangedVtxOffset(self_: *mut ImDrawList);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList__CalcCircleAutoSegmentCount(
        self_: *mut ImDrawList,
        radius: f32,
    ) -> cty::c_int;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList__PathArcToFastEx(
        self_: *mut ImDrawList,
        center: ImVec2,
        radius: f32,
        a_min_sample: cty::c_int,
        a_max_sample: cty::c_int,
        a_step: cty::c_int,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawList__PathArcToN(
        self_: *mut ImDrawList,
        center: ImVec2,
        radius: f32,
        a_min: f32,
        a_max: f32,
        num_segments: cty::c_int,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawData_ImDrawData() -> *mut ImDrawData;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawData_destroy(self_: *mut ImDrawData);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawData_Clear(self_: *mut ImDrawData);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawData_DeIndexAllBuffers(self_: *mut ImDrawData);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImDrawData_ScaleClipRects(self_: *mut ImDrawData, fb_scale: ImVec2);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontConfig_ImFontConfig() -> *mut ImFontConfig;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontConfig_destroy(self_: *mut ImFontConfig);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontGlyphRangesBuilder_ImFontGlyphRangesBuilder() -> *mut ImFontGlyphRangesBuilder;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontGlyphRangesBuilder_destroy(self_: *mut ImFontGlyphRangesBuilder);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontGlyphRangesBuilder_Clear(self_: *mut ImFontGlyphRangesBuilder);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontGlyphRangesBuilder_GetBit(self_: *mut ImFontGlyphRangesBuilder, n: usize) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontGlyphRangesBuilder_SetBit(self_: *mut ImFontGlyphRangesBuilder, n: usize);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontGlyphRangesBuilder_AddChar(self_: *mut ImFontGlyphRangesBuilder, c: ImWchar);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontGlyphRangesBuilder_AddText(
        self_: *mut ImFontGlyphRangesBuilder,
        text: *const cty::c_char,
        text_end: *const cty::c_char,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontGlyphRangesBuilder_AddRanges(
        self_: *mut ImFontGlyphRangesBuilder,
        ranges: *const ImWchar,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontGlyphRangesBuilder_BuildRanges(
        self_: *mut ImFontGlyphRangesBuilder,
        out_ranges: *mut ImVector_ImWchar,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlasCustomRect_ImFontAtlasCustomRect() -> *mut ImFontAtlasCustomRect;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlasCustomRect_destroy(self_: *mut ImFontAtlasCustomRect);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlasCustomRect_IsPacked(self_: *mut ImFontAtlasCustomRect) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_ImFontAtlas() -> *mut ImFontAtlas;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_destroy(self_: *mut ImFontAtlas);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_AddFont(
        self_: *mut ImFontAtlas,
        font_cfg: *const ImFontConfig,
    ) -> *mut ImFont;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_AddFontDefault(
        self_: *mut ImFontAtlas,
        font_cfg: *const ImFontConfig,
    ) -> *mut ImFont;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_AddFontFromFileTTF(
        self_: *mut ImFontAtlas,
        filename: *const cty::c_char,
        size_pixels: f32,
        font_cfg: *const ImFontConfig,
        glyph_ranges: *const ImWchar,
    ) -> *mut ImFont;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_AddFontFromMemoryTTF(
        self_: *mut ImFontAtlas,
        font_data: *mut cty::c_void,
        font_size: cty::c_int,
        size_pixels: f32,
        font_cfg: *const ImFontConfig,
        glyph_ranges: *const ImWchar,
    ) -> *mut ImFont;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_AddFontFromMemoryCompressedTTF(
        self_: *mut ImFontAtlas,
        compressed_font_data: *const cty::c_void,
        compressed_font_size: cty::c_int,
        size_pixels: f32,
        font_cfg: *const ImFontConfig,
        glyph_ranges: *const ImWchar,
    ) -> *mut ImFont;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_AddFontFromMemoryCompressedBase85TTF(
        self_: *mut ImFontAtlas,
        compressed_font_data_base85: *const cty::c_char,
        size_pixels: f32,
        font_cfg: *const ImFontConfig,
        glyph_ranges: *const ImWchar,
    ) -> *mut ImFont;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_ClearInputData(self_: *mut ImFontAtlas);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_ClearTexData(self_: *mut ImFontAtlas);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_ClearFonts(self_: *mut ImFontAtlas);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_Clear(self_: *mut ImFontAtlas);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_Build(self_: *mut ImFontAtlas) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_GetTexDataAsAlpha8(
        self_: *mut ImFontAtlas,
        out_pixels: *mut *mut cty::c_uchar,
        out_width: *mut cty::c_int,
        out_height: *mut cty::c_int,
        out_bytes_per_pixel: *mut cty::c_int,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_GetTexDataAsRGBA32(
        self_: *mut ImFontAtlas,
        out_pixels: *mut *mut cty::c_uchar,
        out_width: *mut cty::c_int,
        out_height: *mut cty::c_int,
        out_bytes_per_pixel: *mut cty::c_int,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_IsBuilt(self_: *mut ImFontAtlas) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_SetTexID(self_: *mut ImFontAtlas, id: ImTextureID);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_GetGlyphRangesDefault(self_: *mut ImFontAtlas) -> *const ImWchar;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_GetGlyphRangesKorean(self_: *mut ImFontAtlas) -> *const ImWchar;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_GetGlyphRangesJapanese(self_: *mut ImFontAtlas) -> *const ImWchar;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_GetGlyphRangesChineseFull(self_: *mut ImFontAtlas) -> *const ImWchar;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_GetGlyphRangesChineseSimplifiedCommon(
        self_: *mut ImFontAtlas,
    ) -> *const ImWchar;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_GetGlyphRangesCyrillic(self_: *mut ImFontAtlas) -> *const ImWchar;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_GetGlyphRangesThai(self_: *mut ImFontAtlas) -> *const ImWchar;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_GetGlyphRangesVietnamese(self_: *mut ImFontAtlas) -> *const ImWchar;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_AddCustomRectRegular(
        self_: *mut ImFontAtlas,
        width: cty::c_int,
        height: cty::c_int,
    ) -> cty::c_int;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_AddCustomRectFontGlyph(
        self_: *mut ImFontAtlas,
        font: *mut ImFont,
        id: ImWchar,
        width: cty::c_int,
        height: cty::c_int,
        advance_x: f32,
        offset: ImVec2,
    ) -> cty::c_int;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_GetCustomRectByIndex(
        self_: *mut ImFontAtlas,
        index: cty::c_int,
    ) -> *mut ImFontAtlasCustomRect;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_CalcCustomRectUV(
        self_: *mut ImFontAtlas,
        rect: *const ImFontAtlasCustomRect,
        out_uv_min: *mut ImVec2,
        out_uv_max: *mut ImVec2,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFontAtlas_GetMouseCursorTexData(
        self_: *mut ImFontAtlas,
        cursor: ImGuiMouseCursor,
        out_offset: *mut ImVec2,
        out_size: *mut ImVec2,
        out_uv_border: *mut ImVec2,
        out_uv_fill: *mut ImVec2,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFont_ImFont() -> *mut ImFont;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFont_destroy(self_: *mut ImFont);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFont_FindGlyph(self_: *mut ImFont, c: ImWchar) -> *const ImFontGlyph;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFont_FindGlyphNoFallback(self_: *mut ImFont, c: ImWchar) -> *const ImFontGlyph;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFont_GetCharAdvance(self_: *mut ImFont, c: ImWchar) -> f32;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFont_IsLoaded(self_: *mut ImFont) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFont_GetDebugName(self_: *mut ImFont) -> *const cty::c_char;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFont_CalcTextSizeA(
        pOut: *mut ImVec2,
        self_: *mut ImFont,
        size: f32,
        max_width: f32,
        wrap_width: f32,
        text_begin: *const cty::c_char,
        text_end: *const cty::c_char,
        remaining: *mut *const cty::c_char,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFont_CalcWordWrapPositionA(
        self_: *mut ImFont,
        scale: f32,
        text: *const cty::c_char,
        text_end: *const cty::c_char,
        wrap_width: f32,
    ) -> *const cty::c_char;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFont_RenderChar(
        self_: *mut ImFont,
        draw_list: *mut ImDrawList,
        size: f32,
        pos: ImVec2,
        col: ImU32,
        c: ImWchar,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFont_RenderText(
        self_: *mut ImFont,
        draw_list: *mut ImDrawList,
        size: f32,
        pos: ImVec2,
        col: ImU32,
        clip_rect: ImVec4,
        text_begin: *const cty::c_char,
        text_end: *const cty::c_char,
        wrap_width: f32,
        cpu_fine_clip: bool,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFont_BuildLookupTable(self_: *mut ImFont);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFont_ClearOutputData(self_: *mut ImFont);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFont_GrowIndex(self_: *mut ImFont, new_size: cty::c_int);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFont_AddGlyph(
        self_: *mut ImFont,
        src_cfg: *const ImFontConfig,
        c: ImWchar,
        x0: f32,
        y0: f32,
        x1: f32,
        y1: f32,
        u0: f32,
        v0: f32,
        u1: f32,
        v1: f32,
        advance_x: f32,
    );
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFont_AddRemapChar(self_: *mut ImFont, dst: ImWchar, src: ImWchar, overwrite_dst: bool);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFont_SetGlyphVisible(self_: *mut ImFont, c: ImWchar, visible: bool);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFont_SetFallbackChar(self_: *mut ImFont, c: ImWchar);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImFont_IsGlyphRangeUnused(
        self_: *mut ImFont,
        c_begin: cty::c_uint,
        c_last: cty::c_uint,
    ) -> bool;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiViewport_ImGuiViewport() -> *mut ImGuiViewport;
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiViewport_destroy(self_: *mut ImGuiViewport);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiViewport_GetCenter(pOut: *mut ImVec2, self_: *mut ImGuiViewport);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiViewport_GetWorkCenter(pOut: *mut ImVec2, self_: *mut ImGuiViewport);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn igLogText(fmt: *const cty::c_char, ...);
}
#[link(wasm_import_module = "imgui-sys-v0")]
extern "C" {
    pub fn ImGuiTextBuffer_appendf(buffer: *mut ImGuiTextBuffer, fmt: *const cty::c_char, ...);
}
