# ash-direct-entry

This crate provides an `EntryCustom` that directly links to libvulkan, so situations where `dlopen()`-ing it is undesirable (e.g. NixOS) can be avoided.

## Example

```rust
use ash::{vk, version::EntryV1_0};
use ash_direct_entry::LibVulkan;

fn main() {
    let entry = LibVulkan::entry();

    let app_info = vk::ApplicationInfo {
        api_version: vk::make_version(1, 0, 0),
        ..Default::default()
    };
    let create_info = vk::InstanceCreateInfo {
        p_application_info: &app_info,
        ..Default::default()
    };
    unsafe {
        entry.create_instance(&create_info, None).unwrap();
    }
}
```
