#![no_std]

//! Library that helps you to simulate exception without `panic` in async Rust.
//!
//! There is an unsync version [unsync::ExceptionContext] and a sync version [sync::ExceptionContext].
//!
//! Check [this blog](https://jason5lee.me/2022/03/11/rust-exception-async/) for the main idea.
//!
//! Example:
//!
//! ```
//! type ExcptCtx = asex::unsync::ExceptionContext<String>;
//!
//! async fn perform(ctx: &ExcptCtx, success: bool) -> String {
//!     if success {
//!         "success".to_string()
//!     } else {
//!         ctx.throw("failed".to_string()).await
//!     }
//! }
//!
//! tokio_test::block_on(async {
//!     let r = ExcptCtx::new()
//!         .catching(|ctx| async move {
//!             assert_eq!("success".to_string(), perform(ctx, true).await);
//!             perform(ctx, false).await;
//!             unreachable!() // The previous statement throws an exception.
//!         })
//!         .await;
//!     assert_eq!(Err("failed".to_string()), r)
//! });
//! ```
pub mod sync;
pub mod unsync;
