#![no_std]

pub mod sync;
pub mod unsync;

#[must_use] // We always want it to be await-ed, so the code after throw won't be executed.
pub struct AlwaysPending;

impl core::future::Future for AlwaysPending {
    type Output = core::convert::Infallible;

    fn poll(
        self: core::pin::Pin<&mut Self>,
        _: &mut core::task::Context<'_>,
    ) -> core::task::Poll<Self::Output> {
        core::task::Poll::Pending
    }
}
