# Summary

1. [Introduction](introduction/introduction.md)
2. [Datalog](datalog/index.md)
   1. [Abstract Syntax](datalog/abstract.md)
   2. [Concrete Syntax](datalog/concrete.md)
   3. [Relational Algebra Mapping](datalog/relational.md)
   4. [Language Features](datalog/features.md)
3. [Model API](model/index.md)
   1. [Programs](model/programs.md)
      1. [Features](model/program_features.md)
      2. [Parser](model/program_parser.md)
      3. [Visitor](model/program_visitor.md)
   2. [Relations](model/relations.md)
      1. [Input/Output](model/relation_io.md)
   3. [Rules](model/rules.md)
   4. [Evaluation](model/eval.md)
      1. [Stratification](model/eval_strata.md)
   5. [Queries & Views](model/queries.md)
      1. [Relational Algebra](model/query_relational.md)
   6. [Error Handling](model/errors.md)
4. [Model Extension](extension/index.md)
   2. [RelationSet I/O](extension/i_o.md)
   1. [Writing an Evaluator](extension/evaluator.md)
   3. [Writing a Typesetter](extension/formatting.md)

5. [Appendix: Abstract Graphical View](reference/abstract_graph.md)
6. [Appendix: First-Order Logic & Horn Clauses](reference/logic.md)
7. [Appendix: Datalog EBNF](reference/datalog_ebnf.md)
8. [Appendix: Relational Algebra EBNF](reference/relational_ebnf.md)
9. [Appendix: References](reference/references.md)
