use std::ops::Deref;
use std::{clone, cmp::max, rc::Rc};

#[derive(Clone, PartialEq, Eq, Debug, Hash)]
pub enum LambdaCalcExpr {
   Ref(&'static str),
   Lam(&'static str, Rc<LambdaCalcExpr>),
   App(Rc<LambdaCalcExpr>, Rc<LambdaCalcExpr>),
}

use LambdaCalcExpr::*;

impl LambdaCalcExpr {
   #[allow(dead_code)]
   fn depth(&self) -> usize {
      match self {
         LambdaCalcExpr::Ref(_) => 0,
         LambdaCalcExpr::Lam(_x, b) => 1 + b.depth(),
         LambdaCalcExpr::App(f, e) => 1 + max(f.depth(), e.depth()),
      }
   }
}
fn app(f: LambdaCalcExpr, a: LambdaCalcExpr) -> LambdaCalcExpr {
   App(Rc::new(f), Rc::new(a))
}
fn lam(x: &'static str, e: LambdaCalcExpr) -> LambdaCalcExpr {
   Lam(x, Rc::new(e))
}

fn sub(exp: &LambdaCalcExpr, var: &str, e: &LambdaCalcExpr) -> LambdaCalcExpr {
   match exp {
      Ref(x) if *x == var => e.clone(),
      Ref(_x) => exp.clone(),
      App(ef, ea) => app(sub(ef, var, e), sub(ea, var, e)),
      Lam(x, _eb) if *x == var => exp.clone(),
      Lam(x, eb) => lam(x, sub(eb, var, e)),
   }
}

#[allow(non_snake_case)]
fn U() -> LambdaCalcExpr {
   lam("x", app(Ref("x"), Ref("x")))
}
#[allow(non_snake_case)]
fn I() -> LambdaCalcExpr {
   lam("x", Ref("x"))
}

fn min<'a>(inp: impl Iterator<Item = (&'a i32,)>) -> impl Iterator<Item = i32> {
   inp.map(|tuple| tuple.0).min().cloned().into_iter()
}

#[warn(warnings)]
#[allow(unused_imports)]
#[cfg(test)]
fn _test() {
   use ascent::aggregators::*;
   use ascent::lattice::set::Set;

   pub struct AscentProgram {
      pub bar: Vec<(i32, i32)>,
      #[allow(non_snake_case)]
      pub bar_indices_0_1: ascent::internal::RelFullIndexType<(i32, i32)>,
      pub foo: Vec<(i32, Option<i32>)>,
      #[allow(non_snake_case)]
      pub foo_indices_0_1: ascent::internal::RelFullIndexType<(i32, Option<i32>)>,
      #[allow(non_snake_case)]
      pub foo_indices_: ascent::internal::RelIndexType<()>,
      pub scc0_duration: std::time::Duration,
      pub scc1_duration: std::time::Duration,
      pub scc2_duration: std::time::Duration,
      pub scc3_duration: std::time::Duration,
      pub scc4_duration: std::time::Duration,
   }
   impl AscentProgram {
      #[allow(unused_imports)]
      pub fn run(&mut self) {
         use core::cmp::PartialEq;
         self.update_indices_priv();
         let _self = self;
         ascent::internal::comment("scc 0");
         {
            let _scc_start_time = ::std::time::Instant::now();
            #[allow(non_snake_case)]
            let foo_indices_0_1_delta: &mut ascent::internal::RelFullIndexType<(i32, Option<i32>)> =
               &mut _self.foo_indices_0_1;
            #[allow(non_snake_case)]
            let mut foo_indices_0_1_total: ascent::internal::RelFullIndexType<(i32, Option<i32>)> = Default::default();
            #[allow(non_snake_case)]
            let mut foo_indices_0_1_new: ascent::internal::RelFullIndexType<(i32, Option<i32>)> = Default::default();
            #[allow(non_snake_case)]
            let foo_indices__delta: &mut ascent::internal::RelIndexType<()> = &mut _self.foo_indices_;
            #[allow(non_snake_case)]
            let mut foo_indices__total: ascent::internal::RelIndexType<()> = Default::default();
            #[allow(non_snake_case)]
            let mut foo_indices__new: ascent::internal::RelIndexType<()> = Default::default();
            #[allow(unused_assignments, unused_variables)]
            {
               let mut __changed = false;
               ascent::internal::comment("foo <-- ");
               let __new_row: (i32, Option<i32>) = (2, Some(2));
               let __new_row_ind = _self.foo.len();
               if !(foo_indices_0_1_total.contains_key(&__new_row) || foo_indices_0_1_delta.contains_key(&__new_row)) {
                  if ascent::internal::full_index_insert_if_not_present(
                     &mut foo_indices_0_1_new,
                     &__new_row,
                     __new_row_ind,
                  ) {
                     ascent::internal::RelIndexTrait::index_insert(&mut foo_indices__new, (), __new_row_ind);
                     _self.foo.push(__new_row);
                     __changed = true;
                  }
               }
               ascent::internal::RelIndexTrait::move_index_contents(foo_indices_0_1_delta, &mut foo_indices_0_1_total);
               std::mem::swap(&mut foo_indices_0_1_new, foo_indices_0_1_delta);
               ascent::internal::RelIndexTrait::move_index_contents(foo_indices__delta, &mut foo_indices__total);
               std::mem::swap(&mut foo_indices__new, foo_indices__delta);
               ascent::internal::RelIndexTrait::move_index_contents(foo_indices_0_1_delta, &mut foo_indices_0_1_total);
               std::mem::swap(&mut foo_indices_0_1_new, foo_indices_0_1_delta);
               ascent::internal::RelIndexTrait::move_index_contents(foo_indices__delta, &mut foo_indices__total);
               std::mem::swap(&mut foo_indices__new, foo_indices__delta);
            }
            _self.foo_indices_0_1 = foo_indices_0_1_total;
            _self.foo_indices_ = foo_indices__total;
            _self.scc0_duration += _scc_start_time.elapsed();
         }
         ascent::internal::comment("scc 1");
         {
            let _scc_start_time = ::std::time::Instant::now();
            #[allow(non_snake_case)]
            let foo_indices_0_1_delta: &mut ascent::internal::RelFullIndexType<(i32, Option<i32>)> =
               &mut _self.foo_indices_0_1;
            #[allow(non_snake_case)]
            let mut foo_indices_0_1_total: ascent::internal::RelFullIndexType<(i32, Option<i32>)> = Default::default();
            #[allow(non_snake_case)]
            let mut foo_indices_0_1_new: ascent::internal::RelFullIndexType<(i32, Option<i32>)> = Default::default();
            #[allow(non_snake_case)]
            let foo_indices__delta: &mut ascent::internal::RelIndexType<()> = &mut _self.foo_indices_;
            #[allow(non_snake_case)]
            let mut foo_indices__total: ascent::internal::RelIndexType<()> = Default::default();
            #[allow(non_snake_case)]
            let mut foo_indices__new: ascent::internal::RelIndexType<()> = Default::default();
            #[allow(unused_assignments, unused_variables)]
            {
               let mut __changed = false;
               ascent::internal::comment("foo <-- ");
               let __new_row: (i32, Option<i32>) = (1, ascent::internal::Convert::convert(None));
               let __new_row_ind = _self.foo.len();
               if !(foo_indices_0_1_total.contains_key(&__new_row) || foo_indices_0_1_delta.contains_key(&__new_row)) {
                  if ascent::internal::full_index_insert_if_not_present(
                     &mut foo_indices_0_1_new,
                     &__new_row,
                     __new_row_ind,
                  ) {
                     ascent::internal::RelIndexTrait::index_insert(&mut foo_indices__new, (), __new_row_ind);
                     _self.foo.push(__new_row);
                     __changed = true;
                  }
               }
               ascent::internal::RelIndexTrait::move_index_contents(foo_indices_0_1_delta, &mut foo_indices_0_1_total);
               std::mem::swap(&mut foo_indices_0_1_new, foo_indices_0_1_delta);
               ascent::internal::RelIndexTrait::move_index_contents(foo_indices__delta, &mut foo_indices__total);
               std::mem::swap(&mut foo_indices__new, foo_indices__delta);
               ascent::internal::RelIndexTrait::move_index_contents(foo_indices_0_1_delta, &mut foo_indices_0_1_total);
               std::mem::swap(&mut foo_indices_0_1_new, foo_indices_0_1_delta);
               ascent::internal::RelIndexTrait::move_index_contents(foo_indices__delta, &mut foo_indices__total);
               std::mem::swap(&mut foo_indices__new, foo_indices__delta);
            }
            _self.foo_indices_0_1 = foo_indices_0_1_total;
            _self.foo_indices_ = foo_indices__total;
            _self.scc1_duration += _scc_start_time.elapsed();
         }
         ascent::internal::comment("scc 2");
         {
            let _scc_start_time = ::std::time::Instant::now();
            #[allow(non_snake_case)]
            let foo_indices__delta: &mut ascent::internal::RelIndexType<()> = &mut _self.foo_indices_;
            #[allow(non_snake_case)]
            let mut foo_indices__total: ascent::internal::RelIndexType<()> = Default::default();
            #[allow(non_snake_case)]
            let mut foo_indices__new: ascent::internal::RelIndexType<()> = Default::default();
            #[allow(non_snake_case)]
            let foo_indices_0_1_delta: &mut ascent::internal::RelFullIndexType<(i32, Option<i32>)> =
               &mut _self.foo_indices_0_1;
            #[allow(non_snake_case)]
            let mut foo_indices_0_1_total: ascent::internal::RelFullIndexType<(i32, Option<i32>)> = Default::default();
            #[allow(non_snake_case)]
            let mut foo_indices_0_1_new: ascent::internal::RelFullIndexType<(i32, Option<i32>)> = Default::default();
            #[allow(unused_assignments, unused_variables)]
            {
               let mut __changed = false;
               ascent::internal::comment("foo <-- ");
               let __new_row: (i32, Option<i32>) = (3, Some(30));
               let __new_row_ind = _self.foo.len();
               if !(foo_indices_0_1_total.contains_key(&__new_row) || foo_indices_0_1_delta.contains_key(&__new_row)) {
                  if ascent::internal::full_index_insert_if_not_present(
                     &mut foo_indices_0_1_new,
                     &__new_row,
                     __new_row_ind,
                  ) {
                     ascent::internal::RelIndexTrait::index_insert(&mut foo_indices__new, (), __new_row_ind);
                     _self.foo.push(__new_row);
                     __changed = true;
                  }
               }
               ascent::internal::RelIndexTrait::move_index_contents(foo_indices__delta, &mut foo_indices__total);
               std::mem::swap(&mut foo_indices__new, foo_indices__delta);
               ascent::internal::RelIndexTrait::move_index_contents(foo_indices_0_1_delta, &mut foo_indices_0_1_total);
               std::mem::swap(&mut foo_indices_0_1_new, foo_indices_0_1_delta);
               ascent::internal::RelIndexTrait::move_index_contents(foo_indices__delta, &mut foo_indices__total);
               std::mem::swap(&mut foo_indices__new, foo_indices__delta);
               ascent::internal::RelIndexTrait::move_index_contents(foo_indices_0_1_delta, &mut foo_indices_0_1_total);
               std::mem::swap(&mut foo_indices_0_1_new, foo_indices_0_1_delta);
            }
            _self.foo_indices_ = foo_indices__total;
            _self.foo_indices_0_1 = foo_indices_0_1_total;
            _self.scc2_duration += _scc_start_time.elapsed();
         }
         ascent::internal::comment("scc 3");
         {
            let _scc_start_time = ::std::time::Instant::now();
            #[allow(non_snake_case)]
            let bar_indices_0_1_delta: &mut ascent::internal::RelFullIndexType<(i32, i32)> = &mut _self.bar_indices_0_1;
            #[allow(non_snake_case)]
            let mut bar_indices_0_1_total: ascent::internal::RelFullIndexType<(i32, i32)> = Default::default();
            #[allow(non_snake_case)]
            let mut bar_indices_0_1_new: ascent::internal::RelFullIndexType<(i32, i32)> = Default::default();
            #[allow(non_snake_case)]
            let foo_indices__total: &mut ascent::internal::RelIndexType<()> = &mut _self.foo_indices_;
            #[allow(unused_assignments, unused_variables)]
            {
               let mut __changed = false;
               ascent::internal::comment("bar <-- foo_indices__total");
               if let Some(__matching) = foo_indices__total.get(&()) {
                  for &__ind in __matching.iter() {
                     let __row = &_self.foo[__ind].clone();
                     let x = &__row.0;
                     let _arg_pattern_6 = &__row.1;
                     if let Some(y) = _arg_pattern_6 {
                        if y != x {
                           let __new_row: (i32, i32) = (*x, *y);
                           let __new_row_ind = _self.bar.len();
                           if !(bar_indices_0_1_total.contains_key(&__new_row)
                              || bar_indices_0_1_delta.contains_key(&__new_row))
                           {
                              if ascent::internal::full_index_insert_if_not_present(
                                 &mut bar_indices_0_1_new,
                                 &__new_row,
                                 __new_row_ind,
                              ) {
                                 _self.bar.push(__new_row);
                                 __changed = true;
                              }
                           }
                        }
                     }
                  }
               }
               ascent::internal::RelIndexTrait::move_index_contents(bar_indices_0_1_delta, &mut bar_indices_0_1_total);
               std::mem::swap(&mut bar_indices_0_1_new, bar_indices_0_1_delta);
               ascent::internal::RelIndexTrait::move_index_contents(bar_indices_0_1_delta, &mut bar_indices_0_1_total);
               std::mem::swap(&mut bar_indices_0_1_new, bar_indices_0_1_delta);
            }
            _self.bar_indices_0_1 = bar_indices_0_1_total;
            _self.scc3_duration += _scc_start_time.elapsed();
         }
         ascent::internal::comment("scc 4");
         {
            let _scc_start_time = ::std::time::Instant::now();
            #[allow(non_snake_case)]
            let bar_indices_0_1_delta: &mut ascent::internal::RelFullIndexType<(i32, i32)> = &mut _self.bar_indices_0_1;
            #[allow(non_snake_case)]
            let mut bar_indices_0_1_total: ascent::internal::RelFullIndexType<(i32, i32)> = Default::default();
            #[allow(non_snake_case)]
            let mut bar_indices_0_1_new: ascent::internal::RelFullIndexType<(i32, i32)> = Default::default();
            #[allow(non_snake_case)]
            let foo_indices__total: &mut ascent::internal::RelIndexType<()> = &mut _self.foo_indices_;
            #[allow(unused_assignments, unused_variables)]
            {
               let mut __changed = false;
               ascent::internal::comment("bar <-- foo_indices__total");
               if let Some(__matching) = foo_indices__total.get(&()) {
                  for &__ind in __matching.iter() {
                     let __row = &_self.foo[__ind].clone();
                     let x = &__row.0;
                     let y_opt = &__row.1;
                     if let Some(y) = y_opt {
                        if y != x {
                           let __new_row: (i32, i32) = (*x, *y);
                           let __new_row_ind = _self.bar.len();
                           if !(bar_indices_0_1_total.contains_key(&__new_row)
                              || bar_indices_0_1_delta.contains_key(&__new_row))
                           {
                              if ascent::internal::full_index_insert_if_not_present(
                                 &mut bar_indices_0_1_new,
                                 &__new_row,
                                 __new_row_ind,
                              ) {
                                 _self.bar.push(__new_row);
                                 __changed = true;
                              }
                           }
                        }
                     }
                  }
               }
               ascent::internal::RelIndexTrait::move_index_contents(bar_indices_0_1_delta, &mut bar_indices_0_1_total);
               std::mem::swap(&mut bar_indices_0_1_new, bar_indices_0_1_delta);
               ascent::internal::RelIndexTrait::move_index_contents(bar_indices_0_1_delta, &mut bar_indices_0_1_total);
               std::mem::swap(&mut bar_indices_0_1_new, bar_indices_0_1_delta);
            }
            _self.bar_indices_0_1 = bar_indices_0_1_total;
            _self.scc4_duration += _scc_start_time.elapsed();
         }
      }
      fn update_indices_priv(&mut self) {
         for (i, tuple) in self.bar.iter().enumerate() {
            let selection_tuple = (tuple.0.clone(), tuple.1.clone());
            ascent::internal::RelIndexTrait::index_insert(&mut self.bar_indices_0_1, selection_tuple, i);
         }
         for (i, tuple) in self.foo.iter().enumerate() {
            let selection_tuple = (tuple.0.clone(), tuple.1.clone());
            ascent::internal::RelIndexTrait::index_insert(&mut self.foo_indices_0_1, selection_tuple, i);
            let selection_tuple = ();
            ascent::internal::RelIndexTrait::index_insert(&mut self.foo_indices_, selection_tuple, i);
         }
      }
      #[deprecated = "Explicit call to update_indices not required anymore."]
      pub fn update_indices(&mut self) {
         self.update_indices_priv();
      }
      #[allow(unused_imports)]
      fn type_constaints() {
         let _type_constraints: ascent::internal::TypeConstraints<i32>;
         let _type_constraints: ascent::internal::TypeConstraints<Option<i32>>;
      }
      pub fn summary() -> &'static str {
         "scc 0, is_looping: false:\n  foo <-- \n  dynamic relations: foo\nscc 1, is_looping: false:\n  foo <-- \n  dynamic relations: foo\nscc 2, is_looping: false:\n  foo <-- \n  dynamic relations: foo\nscc 3, is_looping: false:\n  bar <-- foo_indices__total\n  dynamic relations: bar\nscc 4, is_looping: false:\n  bar <-- foo_indices__total\n  dynamic relations: bar\n"
      }
      pub fn relation_sizes_summary(&self) -> String {
         use std::fmt::Write;
         let mut res = String::new();
         writeln!(&mut res, "{} size: {}", "bar", self.bar.len()).unwrap();
         writeln!(&mut res, "{} size: {}", "foo", self.foo.len()).unwrap();
         res
      }
      pub fn scc_times_summary(&self) -> String {
         use std::fmt::Write;
         let mut res = String::new();
         writeln!(&mut res, "scc {} time: {:?}", "0", self.scc0_duration).unwrap();
         writeln!(&mut res, "scc {} time: {:?}", "1", self.scc1_duration).unwrap();
         writeln!(&mut res, "scc {} time: {:?}", "2", self.scc2_duration).unwrap();
         writeln!(&mut res, "scc {} time: {:?}", "3", self.scc3_duration).unwrap();
         writeln!(&mut res, "scc {} time: {:?}", "4", self.scc4_duration).unwrap();
         res
      }
   }
   impl Default for AscentProgram {
      fn default() -> Self {
         let mut _self = AscentProgram {
            bar: Default::default(),
            bar_indices_0_1: Default::default(),
            foo: Default::default(),
            foo_indices_0_1: Default::default(),
            foo_indices_: Default::default(),
            scc0_duration: std::time::Duration::ZERO,
            scc1_duration: std::time::Duration::ZERO,
            scc2_duration: std::time::Duration::ZERO,
            scc3_duration: std::time::Duration::ZERO,
            scc4_duration: std::time::Duration::ZERO,
         };
         _self
      }
   };
}
