use clap::Parser;

mod git;
mod interactive;
mod pipe;

#[derive(Parser, Debug)]
#[clap(author, version, about, long_about = None)]
struct Args {
    #[clap(short, long)]
    interactive: bool,
}

fn main() {
    let args = Args::parse();

    if args.interactive {
        interactive::exec()
    } else {
        pipe::exec()
    }
}
