use std::io::{stdin, stdout, Write};
use std::ops::Add;
use std::process::Command;

use crate::git;

pub fn exec() {
    let ticket_result = git::get_ticket_id();

    if ticket_result.is_err() {
        return eprintln!("{}", ticket_result.err().unwrap());
    }

    let ticket_id = ticket_result.ok().unwrap();

    print!("message: {} ", ticket_id);

    stdout().flush().unwrap();

    let mut buffer = String::new();
    let stdin = stdin();

    stdin.read_line(&mut buffer).unwrap();

    let commit_message = ticket_id
        .add(" ")
        .add(&buffer);

    println!("committing: {}", commit_message);

    let status = Command::new("/usr/bin/git")
        .arg("commit")
        .arg("-m")
        .arg(commit_message)
        .status()
        .unwrap();

    if status.success() {
        return println!("commit success!");
    }
}